/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.service;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import net.flectone.pulse.library.adventure.key.Key;
import net.flectone.pulse.library.adventure.text.Component;
import net.flectone.pulse.library.adventure.text.TranslatableComponent;
import net.flectone.pulse.library.adventure.translation.GlobalTranslator;
import net.flectone.pulse.library.adventure.translation.Translator;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.guice.name.Named;
import net.flectone.pulse.library.jackson.core.type.TypeReference;
import net.flectone.pulse.library.jackson.databind.ObjectMapper;
import net.flectone.pulse.platform.provider.PacketProvider;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.logging.FLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
public class MinecraftTranslationService {
    private static final String MINECRAFT_TRANSLATION_API = "https://assets.mcasset.cloud/<version>/assets/minecraft/lang/<language>";
    private final Map<String, String> translations = new HashMap<String, String>();
    @Named(value="translationPath")
    private final Path translationPath;
    private final PacketProvider packetProvider;
    private final FileResolver fileResolver;
    private final FLogger fLogger;
    private Translator translator;
    private boolean isModern;

    public void reload() {
        this.isModern = this.detectModernVersion();
        this.translations.clear();
        if (this.downloadLocalizationFile()) {
            this.loadTranslations();
            this.initGlobalTranslator();
        }
    }

    public String getVersion() {
        return this.packetProvider.getServerVersion().getReleaseName();
    }

    public String getLanguage() {
        return this.fileResolver.getConfig().getLanguage().getType().toLowerCase(Locale.ROOT);
    }

    @Nullable
    public String translate(String key) {
        return this.translations.get(key);
    }

    public boolean downloadLocalizationFile() {
        String formattedLanguage;
        Path outputPath = this.resolveLocalizationFile();
        if (Files.exists(outputPath, new LinkOption[0])) {
            return true;
        }
        String language = this.getLanguage();
        String string = formattedLanguage = this.isModern ? language : this.formatLegacyLanguage(language);
        if (formattedLanguage == null) {
            return false;
        }
        String url = this.buildLocalizationUrl(this.getVersion(), formattedLanguage, this.isModern ? ".json" : ".lang");
        return this.downloadFile(url, outputPath);
    }

    public void loadTranslations() {
        Path localizationFile = this.resolveLocalizationFile();
        if (!Files.exists(localizationFile, new LinkOption[0])) {
            return;
        }
        try {
            Map<String, String> loadedTranslations = this.isModern ? this.loadJsonTranslations(localizationFile) : this.loadLegacyTranslations(localizationFile);
            this.translations.putAll(loadedTranslations);
            this.fLogger.info("Loaded translation /localization/minecraft/" + String.valueOf(localizationFile.getFileName()));
        }
        catch (IOException e) {
            this.fLogger.warning("Failed to load translations");
        }
    }

    public void initGlobalTranslator() {
        if (this.translator != null) {
            GlobalTranslator.translator().removeSource(this.translator);
        }
        this.translator = this.createFlectonePulseTranslator();
        GlobalTranslator.translator().addSource(this.translator);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean downloadFile(String fileUrl, Path outputPath) {
        try {
            HttpURLConnection connection = this.createConnection(fileUrl);
            if (connection.getResponseCode() != 200) {
                this.fLogger.warning("Failed to download translation. HTTP response: " + connection.getResponseCode() + " - " + fileUrl);
                return false;
            }
            this.fLogger.info("Downloading translation " + fileUrl);
            try (InputStream inputStream = connection.getInputStream();){
                Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
                Files.copy(inputStream, outputPath, new CopyOption[0]);
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            this.fLogger.warning("Failed to download translation file");
        }
        return false;
    }

    private Path resolveLocalizationFile() {
        String language = this.getLanguage();
        String version = this.getVersion();
        String extension = this.isModern ? ".json" : ".lang";
        return this.translationPath.resolve(version + "_" + language + extension);
    }

    private Map<String, String> loadJsonTranslations(Path file) throws IOException {
        return (Map)new ObjectMapper().readValue(file, (TypeReference)new TypeReference<Map<String, String>>(this){});
    }

    private Map<String, String> loadLegacyTranslations(Path file) throws IOException {
        HashMap<String, String> result = new HashMap<String, String>();
        Files.readAllLines(file).forEach(line -> {
            String[] parts = line.split("=", 2);
            if (parts.length == 2) {
                result.put(parts[0], parts[1]);
            }
        });
        return result;
    }

    private Translator createFlectonePulseTranslator() {
        return new Translator(){

            @NotNull
            public Key name() {
                return Key.key((String)"flectonepulse:translation");
            }

            @Nullable
            public MessageFormat translate(@NotNull String key, @NotNull Locale locale) {
                String translated = MinecraftTranslationService.this.translations.get(key);
                if (translated == null) {
                    return null;
                }
                return new MessageFormat(translated, locale);
            }

            @Nullable
            public Component translate(@NotNull TranslatableComponent component, @NotNull Locale locale) {
                String translated = MinecraftTranslationService.this.translations.get(component.key());
                if (translated == null) {
                    return null;
                }
                return Component.text((String)translated).style(component.style());
            }
        };
    }

    private String buildLocalizationUrl(String version, String language, String extension) {
        return StringUtils.replaceEach((String)(MINECRAFT_TRANSLATION_API + extension), (String[])new String[]{"<version>", "<language>"}, (String[])new String[]{version, language});
    }

    private HttpURLConnection createConnection(String url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)URI.create(url).toURL().openConnection();
        connection.setRequestProperty("User-Agent", "Mozilla/5.0");
        connection.setRequestMethod("GET");
        connection.setConnectTimeout(10000);
        connection.setReadTimeout(10000);
        return connection;
    }

    private boolean detectModernVersion() {
        try {
            String url = this.buildLocalizationUrl(this.getVersion(), "en_us", ".json");
            HttpURLConnection connection = this.createConnection(url);
            return connection.getResponseCode() == 200;
        }
        catch (IOException e) {
            return false;
        }
    }

    private String formatLegacyLanguage(String language) {
        String[] parts = language.split("_");
        if (parts.length != 2) {
            return null;
        }
        return parts[0] + "_" + parts[1].toUpperCase(Locale.ROOT);
    }

    @Inject
    @Generated
    public MinecraftTranslationService(@Named(value="translationPath") Path translationPath, PacketProvider packetProvider, FileResolver fileResolver, FLogger fLogger) {
        this.translationPath = translationPath;
        this.packetProvider = packetProvider;
        this.fileResolver = fileResolver;
        this.fLogger = fLogger;
    }
}

