/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.util.checker;

import java.util.UUID;
import lombok.Generated;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.integration.IntegrationModule;
import net.flectone.pulse.util.checker.PermissionChecker;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;

@Singleton
public class BukkitPermissionChecker
implements PermissionChecker {
    private final IntegrationModule integrationModule;

    @Override
    public boolean check(FEntity entity, String permission) {
        FPlayer fPlayer;
        if (permission == null) {
            return true;
        }
        if (!(entity instanceof FPlayer) || (fPlayer = (FPlayer)entity).isUnknown()) {
            return true;
        }
        Permission bukkitPermission = Bukkit.getPluginManager().getPermission(permission);
        boolean value = bukkitPermission != null && bukkitPermission.getDefault() == PermissionDefault.TRUE || Bukkit.getOperators().stream().anyMatch(offlinePlayer -> offlinePlayer.getUniqueId().equals(entity.getUuid()));
        Player player = Bukkit.getPlayer((UUID)entity.getUuid());
        if (player != null) {
            value = player.hasPermission(permission);
        }
        return value || this.integrationModule.hasFPlayerPermission(fPlayer, permission);
    }

    @Override
    public boolean check(FEntity entity, Permission.IPermission permission) {
        return permission == null || this.check(entity, permission.getName());
    }

    @Inject
    @Generated
    public BukkitPermissionChecker(IntegrationModule integrationModule) {
        this.integrationModule = integrationModule;
    }
}

