/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse;

import lombok.Generated;
import net.flectone.pulse.BukkitInjector;
import net.flectone.pulse.FlectonePulse;
import net.flectone.pulse.FlectonePulseAPI;
import net.flectone.pulse.exception.ReloadException;
import net.flectone.pulse.library.guice.Guice;
import net.flectone.pulse.library.guice.Injector;
import net.flectone.pulse.library.guice.Module;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.packetevents.PacketEvents;
import net.flectone.pulse.library.packetevents.PacketEventsAPI;
import net.flectone.pulse.library.packetevents.impl.factory.spigot.SpigotPacketEventsBuilder;
import net.flectone.pulse.processing.resolver.BukkitLibraryResolver;
import net.flectone.pulse.processing.resolver.LibraryResolver;
import net.flectone.pulse.util.logging.FLogger;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

@Singleton
public class BukkitFlectonePulse
extends JavaPlugin
implements FlectonePulse {
    private FLogger fLogger;
    private LibraryResolver libraryResolver;
    private Injector injector;

    public void onLoad() {
        this.fLogger = new FLogger(this.getLogger());
        this.fLogger.logEnabling();
        this.libraryResolver = new BukkitLibraryResolver((Plugin)this, this.fLogger);
        this.libraryResolver.addLibraries();
        this.libraryResolver.resolveRepositories();
        this.libraryResolver.loadLibraries();
        System.setProperty("packetevents.nbt.default-max-size", "2097152");
        PacketEvents.setAPI((PacketEventsAPI)SpigotPacketEventsBuilder.build((Plugin)this));
        PacketEvents.getAPI().getSettings().reEncodeByDefault(false).checkForUpdates(false).debug(false);
        try {
            this.injector = Guice.createInjector((Module[])new Module[]{new BukkitInjector(this, (Plugin)this, this.libraryResolver, this.fLogger)});
        }
        catch (RuntimeException e) {
            this.fLogger.warning("FAILED TO ENABLE");
            this.fLogger.warning(e);
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        PacketEvents.getAPI().load();
    }

    @Override
    public <T> T get(Class<T> type) {
        if (this.injector == null) {
            throw new IllegalStateException("FlectonePulse not initialized yet");
        }
        return (T)this.injector.getInstance(type);
    }

    @Override
    public boolean isReady() {
        return this.injector != null;
    }

    @Override
    public void onEnable() {
        if (!this.isReady()) {
            return;
        }
        ((FlectonePulseAPI)this.injector.getInstance(FlectonePulseAPI.class)).onEnable();
    }

    @Override
    public void onDisable() {
        if (!this.isReady()) {
            return;
        }
        ((FlectonePulseAPI)this.injector.getInstance(FlectonePulseAPI.class)).onDisable();
    }

    @Override
    public void reload() throws ReloadException {
        if (!this.isReady()) {
            return;
        }
        ((FlectonePulseAPI)this.injector.getInstance(FlectonePulseAPI.class)).reload();
    }

    @Generated
    public FLogger getFLogger() {
        return this.fLogger;
    }

    @Generated
    public LibraryResolver getLibraryResolver() {
        return this.libraryResolver;
    }

    @Generated
    public Injector getInjector() {
        return this.injector;
    }
}

