/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse;

import net.flectone.pulse.processing.processor.ProxyMessageProcessor;
import net.flectone.pulse.util.constant.MessageType;
import net.flectone.pulse.util.logging.FLogger;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.event.PlayerDisconnectEvent;
import net.md_5.bungee.api.event.PluginMessageEvent;
import net.md_5.bungee.api.event.ServerConnectedEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.event.EventHandler;

public final class FlectonePulseBungeecord
extends Plugin
implements Listener {
    private static final String CHANNEL = "BungeeCord";
    private FLogger fLogger;

    public void onEnable() {
        this.fLogger = new FLogger(this.getLogger());
        this.fLogger.logEnabling();
        this.registerChannel();
        this.fLogger.logDescription();
        this.fLogger.logEnabled();
    }

    public void onDisable() {
        this.fLogger.logDisabling();
        this.unregisterChannel();
        this.fLogger.logDisabled();
    }

    @EventHandler
    public void onPluginMessageEvent(PluginMessageEvent event) {
        if (!event.getTag().equals(CHANNEL)) {
            return;
        }
        byte[] data = ProxyMessageProcessor.create(event.getData());
        if (data == null) {
            return;
        }
        ProxyServer.getInstance().getServers().values().stream().filter(serverInfo -> !serverInfo.getPlayers().isEmpty()).forEach(serverInfo -> serverInfo.sendData(CHANNEL, data));
    }

    @EventHandler
    public void onServerConnectedEvent(ServerConnectedEvent event) {
        byte[] data = ProxyMessageProcessor.create(MessageType.SYSTEM_ONLINE, event.getPlayer().getUniqueId());
        ProxyServer.getInstance().getServers().values().stream().filter(serverInfo -> !serverInfo.getPlayers().isEmpty()).forEach(serverInfo -> serverInfo.sendData(CHANNEL, data));
    }

    @EventHandler
    public void onDisconnectEvent(PlayerDisconnectEvent event) {
        byte[] data = ProxyMessageProcessor.create(MessageType.SYSTEM_OFFLINE, event.getPlayer().getUniqueId());
        ProxyServer.getInstance().getServers().values().stream().filter(serverInfo -> !serverInfo.getPlayers().isEmpty()).forEach(serverInfo -> serverInfo.sendData(CHANNEL, data));
    }

    public void reload() {
        this.fLogger.logReloading();
        this.unregisterChannel();
        this.registerChannel();
        this.fLogger.logReloaded();
    }

    private void registerChannel() {
        this.getProxy().registerChannel(CHANNEL);
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)this);
    }

    private void unregisterChannel() {
        this.getProxy().unregisterChannel(CHANNEL);
        this.getProxy().getPluginManager().unregisterListener((Listener)this);
    }
}

