/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.config.localization;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.flectone.pulse.config.ModuleConfig;
import net.flectone.pulse.config.YamlFile;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.jackson.annotation.JsonIgnore;
import net.flectone.pulse.library.jackson.annotation.JsonMerge;
import net.flectone.pulse.library.jackson.annotation.JsonPropertyDescription;
import net.flectone.pulse.library.jackson.annotation.OptBoolean;

public final class Localization
extends YamlFile
implements ModuleConfig {
    public static final String FOLDER_NAME = "localizations";
    @JsonIgnore
    private final String language;
    @JsonIgnore
    private boolean initialized;
    @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/message/")
    String cooldown;
    Time time = new Time();
    @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/command/")
    Command command = new Command();
    @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/integration/")
    Integration integration = new Integration();
    @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/message/")
    Message message = new Message();

    public Localization(Path projectPath, String language) {
        super(Paths.get(projectPath.toString(), FOLDER_NAME, language + ".yml"));
        this.language = language;
    }

    @Generated
    public String getLanguage() {
        return this.language;
    }

    @Generated
    public boolean isInitialized() {
        return this.initialized;
    }

    @Generated
    public String getCooldown() {
        return this.cooldown;
    }

    @Generated
    public Time getTime() {
        return this.time;
    }

    @Override
    @Generated
    public Command getCommand() {
        return this.command;
    }

    @Override
    @Generated
    public Integration getIntegration() {
        return this.integration;
    }

    @Override
    @Generated
    public Message getMessage() {
        return this.message;
    }

    @Generated
    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public static final class Time {
        String format;
        String permanent;
        String zero;

        @Generated
        public String getFormat() {
            return this.format;
        }

        @Generated
        public String getPermanent() {
            return this.permanent;
        }

        @Generated
        public String getZero() {
            return this.zero;
        }
    }

    public static final class Command
    implements ModuleConfig.CommandConfig,
    Localizable {
        Exception exception = new Exception();
        Prompt prompt = new Prompt();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/command/anon/")
        Anon anon = new Anon();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/command/ball/")
        Ball ball = new Ball();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/command/ban/")
        Ban ban = new Ban();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/command/banlist/")
        Banlist banlist = new Banlist();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/command/broadcast/")
        Broadcast broadcast = new Broadcast();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/command/chatcolor/")
        Chatcolor chatcolor = new Chatcolor();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/command/chatsetting/")
        Chatsetting chatsetting = new Chatsetting();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/command/clearchat/")
        Clearchat clearchat = new Clearchat();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/command/clearmail/")
        Clearmail clearmail = new Clearmail();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/command/coin/")
        Coin coin = new Coin();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/command/deletemessage/")
        Deletemessage deletemessage = new Deletemessage();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/command/dice/")
        Dice dice = new Dice();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/command/do/")
        Do Do = new Do();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/command/flectonepulse/")
        Flectonepulse flectonepulse = new Flectonepulse();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/command/geolocate/")
        Geolocate geolocate = new Geolocate();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/command/helper/")
        Helper helper = new Helper();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/command/ignore/")
        Ignore ignore = new Ignore();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/command/ignorelist/")
        Ignorelist ignorelist = new Ignorelist();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/command/kick/")
        Kick kick = new Kick();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/command/mail/")
        Mail mail = new Mail();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/command/maintenance/")
        Maintenance maintenance = new Maintenance();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/command/me/")
        Me me = new Me();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/command/mute/")
        Mute mute = new Mute();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/command/mutelist/")
        Mutelist mutelist = new Mutelist();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/command/online/")
        Online online = new Online();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/command/ping/")
        Ping ping = new Ping();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/command/poll/")
        Poll poll = new Poll();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/command/reply/")
        Reply reply = new Reply();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/command/rockpaperscissors/")
        Rockpaperscissors rockpaperscissors = new Rockpaperscissors();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/command/spy/")
        Spy spy = new Spy();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/command/stream/")
        Stream stream = new Stream();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/command/symbol/")
        Symbol symbol = new Symbol();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/command/tell/")
        Tell tell = new Tell();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/command/tictactoe/")
        Tictactoe tictactoe = new Tictactoe();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/command/toponline/")
        Toponline toponline = new Toponline();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/command/translateto/")
        Translateto translateto = new Translateto();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/command/try/")
        Try Try = new Try();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/command/unban/")
        Unban unban = new Unban();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/command/unmute/")
        Unmute unmute = new Unmute();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/command/unwarn/")
        Unwarn unwarn = new Unwarn();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/command/warn/")
        Warn warn = new Warn();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/command/warnlist/")
        Warnlist warnlist = new Warnlist();

        @Override
        public ModuleConfig.CommandConfig.SubCommandConfig getAfk() {
            return null;
        }

        @Generated
        public Exception getException() {
            return this.exception;
        }

        @Generated
        public Prompt getPrompt() {
            return this.prompt;
        }

        @Override
        @Generated
        public Anon getAnon() {
            return this.anon;
        }

        @Override
        @Generated
        public Ball getBall() {
            return this.ball;
        }

        @Override
        @Generated
        public Ban getBan() {
            return this.ban;
        }

        @Override
        @Generated
        public Banlist getBanlist() {
            return this.banlist;
        }

        @Override
        @Generated
        public Broadcast getBroadcast() {
            return this.broadcast;
        }

        @Override
        @Generated
        public Chatcolor getChatcolor() {
            return this.chatcolor;
        }

        @Override
        @Generated
        public Chatsetting getChatsetting() {
            return this.chatsetting;
        }

        @Override
        @Generated
        public Clearchat getClearchat() {
            return this.clearchat;
        }

        @Override
        @Generated
        public Clearmail getClearmail() {
            return this.clearmail;
        }

        @Override
        @Generated
        public Coin getCoin() {
            return this.coin;
        }

        @Override
        @Generated
        public Deletemessage getDeletemessage() {
            return this.deletemessage;
        }

        @Override
        @Generated
        public Dice getDice() {
            return this.dice;
        }

        @Override
        @Generated
        public Do getDo() {
            return this.Do;
        }

        @Override
        @Generated
        public Flectonepulse getFlectonepulse() {
            return this.flectonepulse;
        }

        @Override
        @Generated
        public Geolocate getGeolocate() {
            return this.geolocate;
        }

        @Override
        @Generated
        public Helper getHelper() {
            return this.helper;
        }

        @Override
        @Generated
        public Ignore getIgnore() {
            return this.ignore;
        }

        @Override
        @Generated
        public Ignorelist getIgnorelist() {
            return this.ignorelist;
        }

        @Override
        @Generated
        public Kick getKick() {
            return this.kick;
        }

        @Override
        @Generated
        public Mail getMail() {
            return this.mail;
        }

        @Override
        @Generated
        public Maintenance getMaintenance() {
            return this.maintenance;
        }

        @Override
        @Generated
        public Me getMe() {
            return this.me;
        }

        @Override
        @Generated
        public Mute getMute() {
            return this.mute;
        }

        @Override
        @Generated
        public Mutelist getMutelist() {
            return this.mutelist;
        }

        @Override
        @Generated
        public Online getOnline() {
            return this.online;
        }

        @Override
        @Generated
        public Ping getPing() {
            return this.ping;
        }

        @Override
        @Generated
        public Poll getPoll() {
            return this.poll;
        }

        @Override
        @Generated
        public Reply getReply() {
            return this.reply;
        }

        @Override
        @Generated
        public Rockpaperscissors getRockpaperscissors() {
            return this.rockpaperscissors;
        }

        @Override
        @Generated
        public Spy getSpy() {
            return this.spy;
        }

        @Override
        @Generated
        public Stream getStream() {
            return this.stream;
        }

        @Override
        @Generated
        public Symbol getSymbol() {
            return this.symbol;
        }

        @Override
        @Generated
        public Tell getTell() {
            return this.tell;
        }

        @Override
        @Generated
        public Tictactoe getTictactoe() {
            return this.tictactoe;
        }

        @Override
        @Generated
        public Toponline getToponline() {
            return this.toponline;
        }

        @Override
        @Generated
        public Translateto getTranslateto() {
            return this.translateto;
        }

        @Override
        @Generated
        public Try getTry() {
            return this.Try;
        }

        @Override
        @Generated
        public Unban getUnban() {
            return this.unban;
        }

        @Override
        @Generated
        public Unmute getUnmute() {
            return this.unmute;
        }

        @Override
        @Generated
        public Unwarn getUnwarn() {
            return this.unwarn;
        }

        @Override
        @Generated
        public Warn getWarn() {
            return this.warn;
        }

        @Override
        @Generated
        public Warnlist getWarnlist() {
            return this.warnlist;
        }

        @Generated
        public void setException(Exception exception) {
            this.exception = exception;
        }

        @Generated
        public void setPrompt(Prompt prompt) {
            this.prompt = prompt;
        }

        @Generated
        public void setAnon(Anon anon) {
            this.anon = anon;
        }

        @Generated
        public void setBall(Ball ball) {
            this.ball = ball;
        }

        @Generated
        public void setBan(Ban ban) {
            this.ban = ban;
        }

        @Generated
        public void setBanlist(Banlist banlist) {
            this.banlist = banlist;
        }

        @Generated
        public void setBroadcast(Broadcast broadcast) {
            this.broadcast = broadcast;
        }

        @Generated
        public void setChatcolor(Chatcolor chatcolor) {
            this.chatcolor = chatcolor;
        }

        @Generated
        public void setChatsetting(Chatsetting chatsetting) {
            this.chatsetting = chatsetting;
        }

        @Generated
        public void setClearchat(Clearchat clearchat) {
            this.clearchat = clearchat;
        }

        @Generated
        public void setClearmail(Clearmail clearmail) {
            this.clearmail = clearmail;
        }

        @Generated
        public void setCoin(Coin coin) {
            this.coin = coin;
        }

        @Generated
        public void setDeletemessage(Deletemessage deletemessage) {
            this.deletemessage = deletemessage;
        }

        @Generated
        public void setDice(Dice dice) {
            this.dice = dice;
        }

        @Generated
        public void setDo(Do Do2) {
            this.Do = Do2;
        }

        @Generated
        public void setFlectonepulse(Flectonepulse flectonepulse) {
            this.flectonepulse = flectonepulse;
        }

        @Generated
        public void setGeolocate(Geolocate geolocate) {
            this.geolocate = geolocate;
        }

        @Generated
        public void setHelper(Helper helper) {
            this.helper = helper;
        }

        @Generated
        public void setIgnore(Ignore ignore) {
            this.ignore = ignore;
        }

        @Generated
        public void setIgnorelist(Ignorelist ignorelist) {
            this.ignorelist = ignorelist;
        }

        @Generated
        public void setKick(Kick kick) {
            this.kick = kick;
        }

        @Generated
        public void setMail(Mail mail) {
            this.mail = mail;
        }

        @Generated
        public void setMaintenance(Maintenance maintenance) {
            this.maintenance = maintenance;
        }

        @Generated
        public void setMe(Me me) {
            this.me = me;
        }

        @Generated
        public void setMute(Mute mute) {
            this.mute = mute;
        }

        @Generated
        public void setMutelist(Mutelist mutelist) {
            this.mutelist = mutelist;
        }

        @Generated
        public void setOnline(Online online) {
            this.online = online;
        }

        @Generated
        public void setPing(Ping ping) {
            this.ping = ping;
        }

        @Generated
        public void setPoll(Poll poll) {
            this.poll = poll;
        }

        @Generated
        public void setReply(Reply reply) {
            this.reply = reply;
        }

        @Generated
        public void setRockpaperscissors(Rockpaperscissors rockpaperscissors) {
            this.rockpaperscissors = rockpaperscissors;
        }

        @Generated
        public void setSpy(Spy spy) {
            this.spy = spy;
        }

        @Generated
        public void setStream(Stream stream) {
            this.stream = stream;
        }

        @Generated
        public void setSymbol(Symbol symbol) {
            this.symbol = symbol;
        }

        @Generated
        public void setTell(Tell tell) {
            this.tell = tell;
        }

        @Generated
        public void setTictactoe(Tictactoe tictactoe) {
            this.tictactoe = tictactoe;
        }

        @Generated
        public void setToponline(Toponline toponline) {
            this.toponline = toponline;
        }

        @Generated
        public void setTranslateto(Translateto translateto) {
            this.translateto = translateto;
        }

        @Generated
        public void setTry(Try Try2) {
            this.Try = Try2;
        }

        @Generated
        public void setUnban(Unban unban) {
            this.unban = unban;
        }

        @Generated
        public void setUnmute(Unmute unmute) {
            this.unmute = unmute;
        }

        @Generated
        public void setUnwarn(Unwarn unwarn) {
            this.unwarn = unwarn;
        }

        @Generated
        public void setWarn(Warn warn) {
            this.warn = warn;
        }

        @Generated
        public void setWarnlist(Warnlist warnlist) {
            this.warnlist = warnlist;
        }

        public static final class Exception {
            String execution;
            String parseUnknown;
            String parseBoolean;
            String parseNumber;
            String parseString;
            String permission;
            String syntax;

            @Generated
            public String getExecution() {
                return this.execution;
            }

            @Generated
            public String getParseUnknown() {
                return this.parseUnknown;
            }

            @Generated
            public String getParseBoolean() {
                return this.parseBoolean;
            }

            @Generated
            public String getParseNumber() {
                return this.parseNumber;
            }

            @Generated
            public String getParseString() {
                return this.parseString;
            }

            @Generated
            public String getPermission() {
                return this.permission;
            }

            @Generated
            public String getSyntax() {
                return this.syntax;
            }

            @Generated
            public Exception() {
            }
        }

        public static final class Prompt {
            String message;
            String hard;
            String accept;
            String turn;
            String type;
            String reason;
            String category;
            String id;
            String time;
            String repeatTime;
            String multipleVote;
            String player;
            String number;
            String color;
            String language;
            String url;
            String move;
            String value;

            @Generated
            public String getMessage() {
                return this.message;
            }

            @Generated
            public String getHard() {
                return this.hard;
            }

            @Generated
            public String getAccept() {
                return this.accept;
            }

            @Generated
            public String getTurn() {
                return this.turn;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public String getReason() {
                return this.reason;
            }

            @Generated
            public String getCategory() {
                return this.category;
            }

            @Generated
            public String getId() {
                return this.id;
            }

            @Generated
            public String getTime() {
                return this.time;
            }

            @Generated
            public String getRepeatTime() {
                return this.repeatTime;
            }

            @Generated
            public String getMultipleVote() {
                return this.multipleVote;
            }

            @Generated
            public String getPlayer() {
                return this.player;
            }

            @Generated
            public String getNumber() {
                return this.number;
            }

            @Generated
            public String getColor() {
                return this.color;
            }

            @Generated
            public String getLanguage() {
                return this.language;
            }

            @Generated
            public String getUrl() {
                return this.url;
            }

            @Generated
            public String getMove() {
                return this.move;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public Prompt() {
            }
        }

        public static final class Anon
        implements ModuleConfig.CommandConfig.SubCommandConfig,
        Localizable {
            String format;

            @Generated
            public String getFormat() {
                return this.format;
            }
        }

        public static final class Ball
        implements ModuleConfig.CommandConfig.SubCommandConfig,
        Localizable {
            String format;
            @JsonMerge(value=OptBoolean.FALSE)
            List<String> answers = new LinkedList<String>();

            @Generated
            public String getFormat() {
                return this.format;
            }

            @Generated
            public List<String> getAnswers() {
                return this.answers;
            }
        }

        public static final class Ban
        implements ModuleConfig.CommandConfig.SubCommandConfig,
        Localizable {
            String nullPlayer;
            String nullTime;
            @JsonMerge(value=OptBoolean.FALSE)
            ReasonMap reasons = new ReasonMap();
            String server;
            String person;
            String connectionAttempt;

            @Generated
            public String getNullPlayer() {
                return this.nullPlayer;
            }

            @Generated
            public String getNullTime() {
                return this.nullTime;
            }

            @Generated
            public ReasonMap getReasons() {
                return this.reasons;
            }

            @Generated
            public String getServer() {
                return this.server;
            }

            @Generated
            public String getPerson() {
                return this.person;
            }

            @Generated
            public String getConnectionAttempt() {
                return this.connectionAttempt;
            }

            public static final class Type {
                String connectionAttempt;
                @JsonMerge(value=OptBoolean.FALSE)
                ReasonMap reasons = new ReasonMap();

                @Generated
                public String getConnectionAttempt() {
                    return this.connectionAttempt;
                }

                @Generated
                public ReasonMap getReasons() {
                    return this.reasons;
                }

                @Generated
                public Type() {
                }
            }
        }

        public static final class Banlist
        implements ModuleConfig.CommandConfig.SubCommandConfig,
        Localizable {
            String empty;
            String nullPage;
            String nullPlayer;
            ListTypeMessage global = new ListTypeMessage();
            ListTypeMessage player = new ListTypeMessage();

            @Generated
            public String getEmpty() {
                return this.empty;
            }

            @Generated
            public String getNullPage() {
                return this.nullPage;
            }

            @Generated
            public String getNullPlayer() {
                return this.nullPlayer;
            }

            @Generated
            public ListTypeMessage getGlobal() {
                return this.global;
            }

            @Generated
            public ListTypeMessage getPlayer() {
                return this.player;
            }
        }

        public static final class Broadcast
        implements ModuleConfig.CommandConfig.SubCommandConfig,
        Localizable {
            String format;

            @Generated
            public String getFormat() {
                return this.format;
            }
        }

        public static final class Chatcolor
        implements ModuleConfig.CommandConfig.SubCommandConfig,
        Localizable {
            String nullPlayer;
            String nullType;
            String nullColor;
            String format;

            @Generated
            public String getNullPlayer() {
                return this.nullPlayer;
            }

            @Generated
            public String getNullType() {
                return this.nullType;
            }

            @Generated
            public String getNullColor() {
                return this.nullColor;
            }

            @Generated
            public String getFormat() {
                return this.format;
            }
        }

        public static final class Chatsetting
        implements ModuleConfig.CommandConfig.SubCommandConfig,
        Localizable {
            String noPermission;
            String disabledSelf;
            String disabledOther;
            String inventory;
            Checkbox checkbox = new Checkbox();
            Menu menu = new Menu();

            @Generated
            public String getNoPermission() {
                return this.noPermission;
            }

            @Generated
            public String getDisabledSelf() {
                return this.disabledSelf;
            }

            @Generated
            public String getDisabledOther() {
                return this.disabledOther;
            }

            @Generated
            public String getInventory() {
                return this.inventory;
            }

            @Generated
            public Checkbox getCheckbox() {
                return this.checkbox;
            }

            @Generated
            public Menu getMenu() {
                return this.menu;
            }

            public static final class Checkbox {
                String enabledColor;
                String enabledHover;
                String disabledColor;
                String disabledHover;
                @JsonMerge(value=OptBoolean.FALSE)
                Map<String, String> types = new LinkedHashMap<String, String>();

                @Generated
                public String getEnabledColor() {
                    return this.enabledColor;
                }

                @Generated
                public String getEnabledHover() {
                    return this.enabledHover;
                }

                @Generated
                public String getDisabledColor() {
                    return this.disabledColor;
                }

                @Generated
                public String getDisabledHover() {
                    return this.disabledHover;
                }

                @Generated
                public Map<String, String> getTypes() {
                    return this.types;
                }

                @Generated
                public Checkbox() {
                }
            }

            public static final class Menu {
                SubMenu chat = new SubMenu();
                SubMenu see = new SubMenu();
                SubMenu out = new SubMenu();

                @Generated
                public SubMenu getChat() {
                    return this.chat;
                }

                @Generated
                public SubMenu getSee() {
                    return this.see;
                }

                @Generated
                public SubMenu getOut() {
                    return this.out;
                }

                @Generated
                public Menu() {
                }

                public static class SubMenu {
                    String item;
                    String inventory;
                    @JsonMerge(value=OptBoolean.FALSE)
                    Map<String, String> types = new LinkedHashMap<String, String>();

                    @Generated
                    public String getItem() {
                        return this.item;
                    }

                    @Generated
                    public String getInventory() {
                        return this.inventory;
                    }

                    @Generated
                    public Map<String, String> getTypes() {
                        return this.types;
                    }

                    @Generated
                    public SubMenu() {
                    }
                }
            }
        }

        public static final class Clearchat
        implements ModuleConfig.CommandConfig.SubCommandConfig,
        Localizable {
            String nullPlayer;
            String format;

            @Generated
            public String getNullPlayer() {
                return this.nullPlayer;
            }

            @Generated
            public String getFormat() {
                return this.format;
            }
        }

        public static final class Clearmail
        implements ModuleConfig.CommandConfig.SubCommandConfig,
        Localizable {
            String nullMail;
            String format;

            @Generated
            public String getNullMail() {
                return this.nullMail;
            }

            @Generated
            public String getFormat() {
                return this.format;
            }
        }

        public static final class Coin
        implements ModuleConfig.CommandConfig.SubCommandConfig,
        Localizable {
            String head;
            String tail;
            String format;
            String formatDraw;

            @Generated
            public String getHead() {
                return this.head;
            }

            @Generated
            public String getTail() {
                return this.tail;
            }

            @Generated
            public String getFormat() {
                return this.format;
            }

            @Generated
            public String getFormatDraw() {
                return this.formatDraw;
            }
        }

        public static final class Deletemessage
        implements ModuleConfig.CommandConfig.SubCommandConfig,
        Localizable {
            String nullMessage;
            String format;

            @Generated
            public String getNullMessage() {
                return this.nullMessage;
            }

            @Generated
            public String getFormat() {
                return this.format;
            }
        }

        public static final class Dice
        implements ModuleConfig.CommandConfig.SubCommandConfig,
        Localizable {
            @JsonMerge(value=OptBoolean.FALSE)
            Map<Integer, String> symbols = new LinkedHashMap<Integer, String>();
            String format;

            @Generated
            public Map<Integer, String> getSymbols() {
                return this.symbols;
            }

            @Generated
            public String getFormat() {
                return this.format;
            }
        }

        public static final class Do
        implements ModuleConfig.CommandConfig.SubCommandConfig,
        Localizable {
            String format;

            @Generated
            public String getFormat() {
                return this.format;
            }
        }

        public static final class Flectonepulse
        implements ModuleConfig.CommandConfig.SubCommandConfig,
        Localizable {
            String nullHostEditor;
            String formatFalse;
            String formatTrue;
            String formatWebStarting;
            String formatEditor;

            @Generated
            public String getNullHostEditor() {
                return this.nullHostEditor;
            }

            @Generated
            public String getFormatFalse() {
                return this.formatFalse;
            }

            @Generated
            public String getFormatTrue() {
                return this.formatTrue;
            }

            @Generated
            public String getFormatWebStarting() {
                return this.formatWebStarting;
            }

            @Generated
            public String getFormatEditor() {
                return this.formatEditor;
            }
        }

        public static final class Geolocate
        implements ModuleConfig.CommandConfig.SubCommandConfig,
        Localizable {
            String nullPlayer;
            String nullOrError;
            String format;

            @Generated
            public String getNullPlayer() {
                return this.nullPlayer;
            }

            @Generated
            public String getNullOrError() {
                return this.nullOrError;
            }

            @Generated
            public String getFormat() {
                return this.format;
            }
        }

        public static final class Helper
        implements ModuleConfig.CommandConfig.SubCommandConfig,
        Localizable {
            String nullHelper;
            String global;
            String player;

            @Generated
            public String getNullHelper() {
                return this.nullHelper;
            }

            @Generated
            public String getGlobal() {
                return this.global;
            }

            @Generated
            public String getPlayer() {
                return this.player;
            }
        }

        public static final class Ignore
        implements ModuleConfig.CommandConfig.SubCommandConfig,
        Localizable {
            String nullPlayer;
            String myself;
            String he;
            String you;
            String formatTrue;
            String formatFalse;

            @Generated
            public String getNullPlayer() {
                return this.nullPlayer;
            }

            @Generated
            public String getMyself() {
                return this.myself;
            }

            @Generated
            public String getHe() {
                return this.he;
            }

            @Generated
            public String getYou() {
                return this.you;
            }

            @Generated
            public String getFormatTrue() {
                return this.formatTrue;
            }

            @Generated
            public String getFormatFalse() {
                return this.formatFalse;
            }
        }

        public static final class Ignorelist
        implements ModuleConfig.CommandConfig.SubCommandConfig,
        Localizable {
            String empty;
            String nullPage;
            String header;
            String line;
            String footer;

            @Generated
            public String getEmpty() {
                return this.empty;
            }

            @Generated
            public String getNullPage() {
                return this.nullPage;
            }

            @Generated
            public String getHeader() {
                return this.header;
            }

            @Generated
            public String getLine() {
                return this.line;
            }

            @Generated
            public String getFooter() {
                return this.footer;
            }
        }

        public static final class Kick
        implements ModuleConfig.CommandConfig.SubCommandConfig,
        Localizable {
            String nullPlayer;
            @JsonMerge(value=OptBoolean.FALSE)
            ReasonMap reasons = new ReasonMap();
            String server;
            String person;

            @Generated
            public String getNullPlayer() {
                return this.nullPlayer;
            }

            @Generated
            public ReasonMap getReasons() {
                return this.reasons;
            }

            @Generated
            public String getServer() {
                return this.server;
            }

            @Generated
            public String getPerson() {
                return this.person;
            }
        }

        public static final class Mail
        implements ModuleConfig.CommandConfig.SubCommandConfig,
        Localizable {
            String nullPlayer;
            String onlinePlayer;
            String sender;
            String receiver;

            @Generated
            public String getNullPlayer() {
                return this.nullPlayer;
            }

            @Generated
            public String getOnlinePlayer() {
                return this.onlinePlayer;
            }

            @Generated
            public String getSender() {
                return this.sender;
            }

            @Generated
            public String getReceiver() {
                return this.receiver;
            }
        }

        public static final class Maintenance
        implements ModuleConfig.CommandConfig.SubCommandConfig,
        Localizable {
            String serverDescription;
            String serverVersion;
            String kick;
            String formatTrue;
            String formatFalse;

            @Generated
            public String getServerDescription() {
                return this.serverDescription;
            }

            @Generated
            public String getServerVersion() {
                return this.serverVersion;
            }

            @Generated
            public String getKick() {
                return this.kick;
            }

            @Generated
            public String getFormatTrue() {
                return this.formatTrue;
            }

            @Generated
            public String getFormatFalse() {
                return this.formatFalse;
            }
        }

        public static final class Me
        implements ModuleConfig.CommandConfig.SubCommandConfig,
        Localizable {
            String format;

            @Generated
            public String getFormat() {
                return this.format;
            }
        }

        public static final class Mute
        implements ModuleConfig.CommandConfig.SubCommandConfig,
        Localizable {
            String nullPlayer;
            String nullTime;
            @JsonMerge(value=OptBoolean.FALSE)
            ReasonMap reasons = new ReasonMap();
            String server;
            String person;

            @Generated
            public String getNullPlayer() {
                return this.nullPlayer;
            }

            @Generated
            public String getNullTime() {
                return this.nullTime;
            }

            @Generated
            public ReasonMap getReasons() {
                return this.reasons;
            }

            @Generated
            public String getServer() {
                return this.server;
            }

            @Generated
            public String getPerson() {
                return this.person;
            }
        }

        public static final class Mutelist
        implements ModuleConfig.CommandConfig.SubCommandConfig,
        Localizable {
            String empty;
            String nullPage;
            String nullPlayer;
            ListTypeMessage global = new ListTypeMessage();
            ListTypeMessage player = new ListTypeMessage();

            @Generated
            public String getEmpty() {
                return this.empty;
            }

            @Generated
            public String getNullPage() {
                return this.nullPage;
            }

            @Generated
            public String getNullPlayer() {
                return this.nullPlayer;
            }

            @Generated
            public ListTypeMessage getGlobal() {
                return this.global;
            }

            @Generated
            public ListTypeMessage getPlayer() {
                return this.player;
            }
        }

        public static final class Online
        implements ModuleConfig.CommandConfig.SubCommandConfig,
        Localizable {
            String nullPlayer;
            String formatCurrent;
            String formatFirst;
            String formatLast;
            String formatTotal;

            @Generated
            public String getNullPlayer() {
                return this.nullPlayer;
            }

            @Generated
            public String getFormatCurrent() {
                return this.formatCurrent;
            }

            @Generated
            public String getFormatFirst() {
                return this.formatFirst;
            }

            @Generated
            public String getFormatLast() {
                return this.formatLast;
            }

            @Generated
            public String getFormatTotal() {
                return this.formatTotal;
            }
        }

        public static final class Ping
        implements ModuleConfig.CommandConfig.SubCommandConfig,
        Localizable {
            String nullPlayer;
            String format;

            @Generated
            public String getNullPlayer() {
                return this.nullPlayer;
            }

            @Generated
            public String getFormat() {
                return this.format;
            }
        }

        public static final class Poll
        implements ModuleConfig.CommandConfig.SubCommandConfig,
        Localizable {
            String nullPoll;
            String expired;
            String already;
            String voteTrue;
            String voteFalse;
            String format;
            String answerTemplate;
            Status status = new Status();
            Modern modern = new Modern();

            @Generated
            public String getNullPoll() {
                return this.nullPoll;
            }

            @Generated
            public String getExpired() {
                return this.expired;
            }

            @Generated
            public String getAlready() {
                return this.already;
            }

            @Generated
            public String getVoteTrue() {
                return this.voteTrue;
            }

            @Generated
            public String getVoteFalse() {
                return this.voteFalse;
            }

            @Generated
            public String getFormat() {
                return this.format;
            }

            @Generated
            public String getAnswerTemplate() {
                return this.answerTemplate;
            }

            @Generated
            public Status getStatus() {
                return this.status;
            }

            @Generated
            public Modern getModern() {
                return this.modern;
            }

            public static final class Status {
                String start;
                String run;
                String end;

                @Generated
                public String getStart() {
                    return this.start;
                }

                @Generated
                public String getRun() {
                    return this.run;
                }

                @Generated
                public String getEnd() {
                    return this.end;
                }
            }

            public static final class Modern {
                String header;
                String inputName;
                String inputInitial;
                String multipleName;
                String endTimeName;
                String repeatTimeName;
                String newAnswerButtonName;
                String removeAnswerButtonName;
                String inputAnswerName;
                String inputAnswersInitial;
                String createButtonName;

                @Generated
                public String getHeader() {
                    return this.header;
                }

                @Generated
                public String getInputName() {
                    return this.inputName;
                }

                @Generated
                public String getInputInitial() {
                    return this.inputInitial;
                }

                @Generated
                public String getMultipleName() {
                    return this.multipleName;
                }

                @Generated
                public String getEndTimeName() {
                    return this.endTimeName;
                }

                @Generated
                public String getRepeatTimeName() {
                    return this.repeatTimeName;
                }

                @Generated
                public String getNewAnswerButtonName() {
                    return this.newAnswerButtonName;
                }

                @Generated
                public String getRemoveAnswerButtonName() {
                    return this.removeAnswerButtonName;
                }

                @Generated
                public String getInputAnswerName() {
                    return this.inputAnswerName;
                }

                @Generated
                public String getInputAnswersInitial() {
                    return this.inputAnswersInitial;
                }

                @Generated
                public String getCreateButtonName() {
                    return this.createButtonName;
                }
            }
        }

        public static final class Reply
        implements ModuleConfig.CommandConfig.SubCommandConfig,
        Localizable {
            String nullReceiver;

            @Generated
            public String getNullReceiver() {
                return this.nullReceiver;
            }
        }

        public static final class Rockpaperscissors
        implements ModuleConfig.CommandConfig.SubCommandConfig,
        Localizable {
            String nullPlayer;
            String nullGame;
            String wrongMove;
            String already;
            String myself;
            String sender;
            String receiver;
            String formatMove;
            String formatWin;
            String formatDraw;
            @JsonMerge(value=OptBoolean.FALSE)
            Map<String, String> strategies = new LinkedHashMap<String, String>();

            @Generated
            public String getNullPlayer() {
                return this.nullPlayer;
            }

            @Generated
            public String getNullGame() {
                return this.nullGame;
            }

            @Generated
            public String getWrongMove() {
                return this.wrongMove;
            }

            @Generated
            public String getAlready() {
                return this.already;
            }

            @Generated
            public String getMyself() {
                return this.myself;
            }

            @Generated
            public String getSender() {
                return this.sender;
            }

            @Generated
            public String getReceiver() {
                return this.receiver;
            }

            @Generated
            public String getFormatMove() {
                return this.formatMove;
            }

            @Generated
            public String getFormatWin() {
                return this.formatWin;
            }

            @Generated
            public String getFormatDraw() {
                return this.formatDraw;
            }

            @Generated
            public Map<String, String> getStrategies() {
                return this.strategies;
            }
        }

        public static final class Spy
        implements ModuleConfig.CommandConfig.SubCommandConfig,
        Localizable {
            String formatTrue;
            String formatFalse;
            String formatLog;

            @Generated
            public String getFormatTrue() {
                return this.formatTrue;
            }

            @Generated
            public String getFormatFalse() {
                return this.formatFalse;
            }

            @Generated
            public String getFormatLog() {
                return this.formatLog;
            }
        }

        public static final class Stream
        implements ModuleConfig.CommandConfig.SubCommandConfig,
        Localizable {
            String already;
            String not;
            String prefixTrue;
            String prefixFalse;
            String urlTemplate;
            String formatStart;
            String formatEnd;

            @Generated
            public String getAlready() {
                return this.already;
            }

            @Generated
            public String getNot() {
                return this.not;
            }

            @Generated
            public String getPrefixTrue() {
                return this.prefixTrue;
            }

            @Generated
            public String getPrefixFalse() {
                return this.prefixFalse;
            }

            @Generated
            public String getUrlTemplate() {
                return this.urlTemplate;
            }

            @Generated
            public String getFormatStart() {
                return this.formatStart;
            }

            @Generated
            public String getFormatEnd() {
                return this.formatEnd;
            }
        }

        public static final class Symbol
        implements ModuleConfig.CommandConfig.SubCommandConfig,
        Localizable {
            String format;

            @Generated
            public String getFormat() {
                return this.format;
            }
        }

        public static final class Tell
        implements ModuleConfig.CommandConfig.SubCommandConfig,
        Localizable {
            String nullPlayer;
            String sender;
            String receiver;
            String myself;

            @Generated
            public String getNullPlayer() {
                return this.nullPlayer;
            }

            @Generated
            public String getSender() {
                return this.sender;
            }

            @Generated
            public String getReceiver() {
                return this.receiver;
            }

            @Generated
            public String getMyself() {
                return this.myself;
            }
        }

        public static final class Tictactoe
        implements ModuleConfig.CommandConfig.SubCommandConfig,
        Localizable {
            String nullPlayer;
            String myself;
            String wrongGame;
            String wrongMove;
            String wrongByPlayer;
            Symbol symbol = new Symbol();
            String field;
            String currentMove;
            String lastMove;
            String formatMove;
            String formatWin;
            String formatDraw;
            String sender;
            String receiver;

            @Generated
            public String getNullPlayer() {
                return this.nullPlayer;
            }

            @Generated
            public String getMyself() {
                return this.myself;
            }

            @Generated
            public String getWrongGame() {
                return this.wrongGame;
            }

            @Generated
            public String getWrongMove() {
                return this.wrongMove;
            }

            @Generated
            public String getWrongByPlayer() {
                return this.wrongByPlayer;
            }

            @Generated
            public Symbol getSymbol() {
                return this.symbol;
            }

            @Generated
            public String getField() {
                return this.field;
            }

            @Generated
            public String getCurrentMove() {
                return this.currentMove;
            }

            @Generated
            public String getLastMove() {
                return this.lastMove;
            }

            @Generated
            public String getFormatMove() {
                return this.formatMove;
            }

            @Generated
            public String getFormatWin() {
                return this.formatWin;
            }

            @Generated
            public String getFormatDraw() {
                return this.formatDraw;
            }

            @Generated
            public String getSender() {
                return this.sender;
            }

            @Generated
            public String getReceiver() {
                return this.receiver;
            }

            public static final class Symbol {
                String blank;
                String first;
                String firstRemove;
                String firstWin;
                String second;
                String secondRemove;
                String secondWin;

                @Generated
                public String getBlank() {
                    return this.blank;
                }

                @Generated
                public String getFirst() {
                    return this.first;
                }

                @Generated
                public String getFirstRemove() {
                    return this.firstRemove;
                }

                @Generated
                public String getFirstWin() {
                    return this.firstWin;
                }

                @Generated
                public String getSecond() {
                    return this.second;
                }

                @Generated
                public String getSecondRemove() {
                    return this.secondRemove;
                }

                @Generated
                public String getSecondWin() {
                    return this.secondWin;
                }

                @Generated
                public Symbol() {
                }
            }
        }

        public static final class Toponline
        implements ModuleConfig.CommandConfig.SubCommandConfig,
        Localizable {
            String nullPage;
            String header;
            String line;
            String footer;

            @Generated
            public String getNullPage() {
                return this.nullPage;
            }

            @Generated
            public String getHeader() {
                return this.header;
            }

            @Generated
            public String getLine() {
                return this.line;
            }

            @Generated
            public String getFooter() {
                return this.footer;
            }
        }

        public static final class Translateto
        implements ModuleConfig.CommandConfig.SubCommandConfig,
        Localizable {
            String nullOrError;
            String format;

            @Generated
            public String getNullOrError() {
                return this.nullOrError;
            }

            @Generated
            public String getFormat() {
                return this.format;
            }
        }

        public static final class Try
        implements ModuleConfig.CommandConfig.SubCommandConfig,
        Localizable {
            String formatTrue;
            String formatFalse;

            @Generated
            public String getFormatTrue() {
                return this.formatTrue;
            }

            @Generated
            public String getFormatFalse() {
                return this.formatFalse;
            }
        }

        public static final class Unban
        implements ModuleConfig.CommandConfig.SubCommandConfig,
        Localizable {
            String nullPlayer;
            String notBanned;
            String format;

            @Generated
            public String getNullPlayer() {
                return this.nullPlayer;
            }

            @Generated
            public String getNotBanned() {
                return this.notBanned;
            }

            @Generated
            public String getFormat() {
                return this.format;
            }
        }

        public static final class Unmute
        implements ModuleConfig.CommandConfig.SubCommandConfig,
        Localizable {
            String nullPlayer;
            String notMuted;
            String format;

            @Generated
            public String getNullPlayer() {
                return this.nullPlayer;
            }

            @Generated
            public String getNotMuted() {
                return this.notMuted;
            }

            @Generated
            public String getFormat() {
                return this.format;
            }
        }

        public static final class Unwarn
        implements ModuleConfig.CommandConfig.SubCommandConfig,
        Localizable {
            String nullPlayer;
            String notWarned;
            String format;

            @Generated
            public String getNullPlayer() {
                return this.nullPlayer;
            }

            @Generated
            public String getNotWarned() {
                return this.notWarned;
            }

            @Generated
            public String getFormat() {
                return this.format;
            }
        }

        public static final class Warn
        implements ModuleConfig.CommandConfig.SubCommandConfig,
        Localizable {
            String nullPlayer;
            String nullTime;
            @JsonMerge(value=OptBoolean.FALSE)
            ReasonMap reasons = new ReasonMap();
            String server;
            String person;

            @Generated
            public String getNullPlayer() {
                return this.nullPlayer;
            }

            @Generated
            public String getNullTime() {
                return this.nullTime;
            }

            @Generated
            public ReasonMap getReasons() {
                return this.reasons;
            }

            @Generated
            public String getServer() {
                return this.server;
            }

            @Generated
            public String getPerson() {
                return this.person;
            }
        }

        public static final class Warnlist
        implements ModuleConfig.CommandConfig.SubCommandConfig,
        Localizable {
            String empty;
            String nullPage;
            String nullPlayer;
            ListTypeMessage global = new ListTypeMessage();
            ListTypeMessage player = new ListTypeMessage();

            @Generated
            public String getEmpty() {
                return this.empty;
            }

            @Generated
            public String getNullPage() {
                return this.nullPage;
            }

            @Generated
            public String getNullPlayer() {
                return this.nullPlayer;
            }

            @Generated
            public ListTypeMessage getGlobal() {
                return this.global;
            }

            @Generated
            public ListTypeMessage getPlayer() {
                return this.player;
            }
        }
    }

    public static final class Integration
    implements ModuleConfig.IntegrationConfig,
    Localizable {
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/integration/discord/")
        Discord discord = new Discord();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/integration/telegram/")
        Telegram telegram = new Telegram();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/integration/twitch/")
        Twitch twitch = new Twitch();

        @Override
        public ModuleConfig.IntegrationConfig.SubIntegrationConfig getAdvancedban() {
            return null;
        }

        @Override
        public ModuleConfig.IntegrationConfig.SubIntegrationConfig getDeepl() {
            return null;
        }

        @Override
        public ModuleConfig.IntegrationConfig.SubIntegrationConfig getInteractivechat() {
            return null;
        }

        @Override
        public ModuleConfig.IntegrationConfig.SubIntegrationConfig getItemsadder() {
            return null;
        }

        @Override
        public ModuleConfig.IntegrationConfig.SubIntegrationConfig getLitebans() {
            return null;
        }

        @Override
        public ModuleConfig.IntegrationConfig.SubIntegrationConfig getLuckperms() {
            return null;
        }

        @Override
        public ModuleConfig.IntegrationConfig.SubIntegrationConfig getMaintenance() {
            return null;
        }

        @Override
        public ModuleConfig.IntegrationConfig.SubIntegrationConfig getMinimotd() {
            return null;
        }

        @Override
        public ModuleConfig.IntegrationConfig.SubIntegrationConfig getMiniplaceholders() {
            return null;
        }

        @Override
        public ModuleConfig.IntegrationConfig.SubIntegrationConfig getMotd() {
            return null;
        }

        @Override
        public ModuleConfig.IntegrationConfig.SubIntegrationConfig getPlaceholderapi() {
            return null;
        }

        @Override
        public ModuleConfig.IntegrationConfig.SubIntegrationConfig getPlasmovoice() {
            return null;
        }

        @Override
        public ModuleConfig.IntegrationConfig.SubIntegrationConfig getSimplevoice() {
            return null;
        }

        @Override
        public ModuleConfig.IntegrationConfig.SubIntegrationConfig getSkinsrestorer() {
            return null;
        }

        @Override
        public ModuleConfig.IntegrationConfig.SubIntegrationConfig getSupervanish() {
            return null;
        }

        @Override
        public ModuleConfig.IntegrationConfig.SubIntegrationConfig getVault() {
            return null;
        }

        @Override
        public ModuleConfig.IntegrationConfig.SubIntegrationConfig getYandex() {
            return null;
        }

        @Override
        public ModuleConfig.IntegrationConfig.SubIntegrationConfig getTriton() {
            return null;
        }

        @Override
        @Generated
        public Discord getDiscord() {
            return this.discord;
        }

        @Override
        @Generated
        public Telegram getTelegram() {
            return this.telegram;
        }

        @Override
        @Generated
        public Twitch getTwitch() {
            return this.twitch;
        }

        public static final class Discord
        implements ModuleConfig.IntegrationConfig.SubIntegrationConfig,
        Localizable {
            String forMinecraft;
            @JsonMerge(value=OptBoolean.FALSE)
            Map<String, String> infoChannel = new LinkedHashMap<String, String>();
            @JsonMerge(value=OptBoolean.FALSE)
            Map<String, ChannelEmbed> messageChannel = new LinkedHashMap<String, ChannelEmbed>();

            @Generated
            public String getForMinecraft() {
                return this.forMinecraft;
            }

            @Generated
            public Map<String, String> getInfoChannel() {
                return this.infoChannel;
            }

            @Generated
            public Map<String, ChannelEmbed> getMessageChannel() {
                return this.messageChannel;
            }

            public static final class Embed {
                String color;
                String title;
                String url;
                Author author = new Author();
                String description;
                String thumbnail;
                @JsonMerge(value=OptBoolean.FALSE)
                List<Field> fields = new LinkedList<Field>();
                String image;
                boolean timestamp;
                Footer footer = new Footer();

                @Generated
                public String getColor() {
                    return this.color;
                }

                @Generated
                public String getTitle() {
                    return this.title;
                }

                @Generated
                public String getUrl() {
                    return this.url;
                }

                @Generated
                public Author getAuthor() {
                    return this.author;
                }

                @Generated
                public String getDescription() {
                    return this.description;
                }

                @Generated
                public String getThumbnail() {
                    return this.thumbnail;
                }

                @Generated
                public List<Field> getFields() {
                    return this.fields;
                }

                @Generated
                public String getImage() {
                    return this.image;
                }

                @Generated
                public boolean isTimestamp() {
                    return this.timestamp;
                }

                @Generated
                public Footer getFooter() {
                    return this.footer;
                }

                @Generated
                public Embed() {
                }

                @Generated
                public Embed(String color, String title, String url, Author author, String description, String thumbnail, List<Field> fields, String image, boolean timestamp, Footer footer) {
                    this.color = color;
                    this.title = title;
                    this.url = url;
                    this.author = author;
                    this.description = description;
                    this.thumbnail = thumbnail;
                    this.fields = fields;
                    this.image = image;
                    this.timestamp = timestamp;
                    this.footer = footer;
                }

                public static final class Author {
                    String name;
                    String url;
                    String iconUrl;

                    @Generated
                    public String getName() {
                        return this.name;
                    }

                    @Generated
                    public String getUrl() {
                        return this.url;
                    }

                    @Generated
                    public String getIconUrl() {
                        return this.iconUrl;
                    }

                    @Generated
                    public Author() {
                    }

                    @Generated
                    public Author(String name, String url, String iconUrl) {
                        this.name = name;
                        this.url = url;
                        this.iconUrl = iconUrl;
                    }
                }

                public static final class Footer {
                    String text;
                    String iconUrl;

                    @Generated
                    public String getText() {
                        return this.text;
                    }

                    @Generated
                    public String getIconUrl() {
                        return this.iconUrl;
                    }

                    @Generated
                    public Footer() {
                    }

                    @Generated
                    public Footer(String text, String iconUrl) {
                        this.text = text;
                        this.iconUrl = iconUrl;
                    }
                }

                public static final class Field {
                    String name;
                    String value;
                    boolean inline;

                    @Generated
                    public String getName() {
                        return this.name;
                    }

                    @Generated
                    public String getValue() {
                        return this.value;
                    }

                    @Generated
                    public boolean isInline() {
                        return this.inline;
                    }

                    @Generated
                    public Field() {
                    }

                    @Generated
                    public Field(String name, String value, boolean inline) {
                        this.name = name;
                        this.value = value;
                        this.inline = inline;
                    }
                }
            }

            public static final class ChannelEmbed {
                String content;
                String webhookAvatar;
                Embed embed;

                @Generated
                public String getContent() {
                    return this.content;
                }

                @Generated
                public String getWebhookAvatar() {
                    return this.webhookAvatar;
                }

                @Generated
                public Embed getEmbed() {
                    return this.embed;
                }

                @Generated
                public ChannelEmbed() {
                }

                @Generated
                public ChannelEmbed(String content, String webhookAvatar, Embed embed) {
                    this.content = content;
                    this.webhookAvatar = webhookAvatar;
                    this.embed = embed;
                }
            }
        }

        public static final class Telegram
        implements ModuleConfig.IntegrationConfig.SubIntegrationConfig,
        Localizable {
            String forMinecraft;
            @JsonMerge(value=OptBoolean.FALSE)
            Map<String, String> messageChannel = new LinkedHashMap<String, String>();

            @Generated
            public String getForMinecraft() {
                return this.forMinecraft;
            }

            @Generated
            public Map<String, String> getMessageChannel() {
                return this.messageChannel;
            }
        }

        public static final class Twitch
        implements ModuleConfig.IntegrationConfig.SubIntegrationConfig,
        Localizable {
            String forMinecraft;
            @JsonMerge(value=OptBoolean.FALSE)
            Map<String, String> messageChannel = new LinkedHashMap<String, String>();

            @Generated
            public String getForMinecraft() {
                return this.forMinecraft;
            }

            @Generated
            public Map<String, String> getMessageChannel() {
                return this.messageChannel;
            }
        }
    }

    public static final class Message
    implements ModuleConfig.MessageConfig,
    Localizable {
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/message/afk/")
        Afk afk = new Afk();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/message/auto/")
        Auto auto = new Auto();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/message/brand/")
        Brand brand = new Brand();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/message/bubble/")
        Bubble bubble = new Bubble();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/message/chat/")
        Chat chat = new Chat();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/message/format/")
        Format format = new Format();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/message/greeting/")
        Greeting greeting = new Greeting();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/message/join/")
        Join join = new Join();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/message/objective/")
        Objective objective = new Objective();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/message/quit/")
        Quit quit = new Quit();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/message/rightclick/")
        Rightclick rightclick = new Rightclick();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/message/sidebar/")
        Sidebar sidebar = new Sidebar();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/message/status/")
        Status status = new Status();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/message/tab/")
        Tab tab = new Tab();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/message/update/")
        Update update = new Update();
        @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/message/vanilla/")
        Vanilla vanilla = new Vanilla();

        @Override
        public ModuleConfig.MessageConfig.SubMessageConfig getAnvil() {
            return null;
        }

        @Override
        public ModuleConfig.MessageConfig.SubMessageConfig getBook() {
            return null;
        }

        @Override
        public ModuleConfig.MessageConfig.SubMessageConfig getSign() {
            return null;
        }

        @Override
        @Generated
        public Afk getAfk() {
            return this.afk;
        }

        @Override
        @Generated
        public Auto getAuto() {
            return this.auto;
        }

        @Override
        @Generated
        public Brand getBrand() {
            return this.brand;
        }

        @Override
        @Generated
        public Bubble getBubble() {
            return this.bubble;
        }

        @Override
        @Generated
        public Chat getChat() {
            return this.chat;
        }

        @Override
        @Generated
        public Format getFormat() {
            return this.format;
        }

        @Override
        @Generated
        public Greeting getGreeting() {
            return this.greeting;
        }

        @Override
        @Generated
        public Join getJoin() {
            return this.join;
        }

        @Override
        @Generated
        public Objective getObjective() {
            return this.objective;
        }

        @Override
        @Generated
        public Quit getQuit() {
            return this.quit;
        }

        @Override
        @Generated
        public Rightclick getRightclick() {
            return this.rightclick;
        }

        @Override
        @Generated
        public Sidebar getSidebar() {
            return this.sidebar;
        }

        @Override
        @Generated
        public Status getStatus() {
            return this.status;
        }

        @Override
        @Generated
        public Tab getTab() {
            return this.tab;
        }

        @Override
        @Generated
        public Update getUpdate() {
            return this.update;
        }

        @Override
        @Generated
        public Vanilla getVanilla() {
            return this.vanilla;
        }

        @Generated
        public void setAfk(Afk afk) {
            this.afk = afk;
        }

        @Generated
        public void setAuto(Auto auto) {
            this.auto = auto;
        }

        @Generated
        public void setBrand(Brand brand) {
            this.brand = brand;
        }

        @Generated
        public void setBubble(Bubble bubble) {
            this.bubble = bubble;
        }

        @Generated
        public void setChat(Chat chat) {
            this.chat = chat;
        }

        @Generated
        public void setFormat(Format format) {
            this.format = format;
        }

        @Generated
        public void setGreeting(Greeting greeting) {
            this.greeting = greeting;
        }

        @Generated
        public void setJoin(Join join) {
            this.join = join;
        }

        @Generated
        public void setObjective(Objective objective) {
            this.objective = objective;
        }

        @Generated
        public void setQuit(Quit quit) {
            this.quit = quit;
        }

        @Generated
        public void setRightclick(Rightclick rightclick) {
            this.rightclick = rightclick;
        }

        @Generated
        public void setSidebar(Sidebar sidebar) {
            this.sidebar = sidebar;
        }

        @Generated
        public void setStatus(Status status) {
            this.status = status;
        }

        @Generated
        public void setTab(Tab tab) {
            this.tab = tab;
        }

        @Generated
        public void setUpdate(Update update) {
            this.update = update;
        }

        @Generated
        public void setVanilla(Vanilla vanilla) {
            this.vanilla = vanilla;
        }

        public static final class Afk
        implements ModuleConfig.MessageConfig.SubMessageConfig,
        Localizable {
            String suffix;
            Format formatTrue = new Format();
            Format formatFalse = new Format();

            @Generated
            public String getSuffix() {
                return this.suffix;
            }

            @Generated
            public Format getFormatTrue() {
                return this.formatTrue;
            }

            @Generated
            public Format getFormatFalse() {
                return this.formatFalse;
            }

            public static final class Format {
                String global;
                String local;

                @Generated
                public String getGlobal() {
                    return this.global;
                }

                @Generated
                public String getLocal() {
                    return this.local;
                }

                @Generated
                public Format() {
                }
            }
        }

        public static final class Auto
        implements ModuleConfig.MessageConfig.SubMessageConfig,
        Localizable {
            @JsonMerge(value=OptBoolean.FALSE)
            Map<String, List<String>> types = new LinkedHashMap<String, List<String>>();

            @Generated
            public Map<String, List<String>> getTypes() {
                return this.types;
            }
        }

        public static final class Brand
        implements ModuleConfig.MessageConfig.SubMessageConfig,
        Localizable {
            @JsonMerge(value=OptBoolean.FALSE)
            List<String> values = new LinkedList<String>();

            @Generated
            public List<String> getValues() {
                return this.values;
            }
        }

        public static final class Bubble
        implements ModuleConfig.MessageConfig.SubMessageConfig,
        Localizable {
            String format;

            @Generated
            public String getFormat() {
                return this.format;
            }
        }

        public static final class Chat
        implements ModuleConfig.MessageConfig.SubMessageConfig,
        Localizable {
            String nullChat;
            String nullReceiver;
            @JsonMerge(value=OptBoolean.FALSE)
            Map<String, String> types = new LinkedHashMap<String, String>();

            @Generated
            public String getNullChat() {
                return this.nullChat;
            }

            @Generated
            public String getNullReceiver() {
                return this.nullReceiver;
            }

            @Generated
            public Map<String, String> getTypes() {
                return this.types;
            }
        }

        public static final class Format
        implements ModuleConfig.MessageConfig.FormatMessageConfig,
        Localizable {
            @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/message/format/replacement/")
            Replacement replacement = new Replacement();
            @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/message/format/mention/")
            Mention mention = new Mention();
            @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/message/format/moderation/")
            Moderation moderation = new Moderation();
            @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/message/format/names/")
            Names names = new Names();
            @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/message/format/questionanswer/")
            QuestionAnswer questionAnswer = new QuestionAnswer();
            @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/message/format/translate/")
            Translate translate = new Translate();

            @Override
            public ModuleConfig.MessageConfig.FormatMessageConfig.SubFormatMessageConfig getFcolor() {
                return null;
            }

            @Override
            public ModuleConfig.MessageConfig.FormatMessageConfig.SubFormatMessageConfig getFixation() {
                return null;
            }

            @Override
            public ModuleConfig.MessageConfig.FormatMessageConfig.SubFormatMessageConfig getScoreboard() {
                return null;
            }

            @Override
            public ModuleConfig.MessageConfig.FormatMessageConfig.SubFormatMessageConfig getObject() {
                return null;
            }

            @Override
            public ModuleConfig.MessageConfig.FormatMessageConfig.SubFormatMessageConfig getWorld() {
                return null;
            }

            @Override
            @Generated
            public Replacement getReplacement() {
                return this.replacement;
            }

            @Override
            @Generated
            public Mention getMention() {
                return this.mention;
            }

            @Override
            @Generated
            public Moderation getModeration() {
                return this.moderation;
            }

            @Override
            @Generated
            public Names getNames() {
                return this.names;
            }

            @Override
            @Generated
            public QuestionAnswer getQuestionAnswer() {
                return this.questionAnswer;
            }

            @Override
            @Generated
            public Translate getTranslate() {
                return this.translate;
            }

            public static final class Replacement
            implements ModuleConfig.MessageConfig.FormatMessageConfig.SubFormatMessageConfig,
            Localizable {
                String spoilerSymbol;
                @JsonMerge(value=OptBoolean.FALSE)
                Map<String, String> values;

                @Generated
                public String getSpoilerSymbol() {
                    return this.spoilerSymbol;
                }

                @Generated
                public Map<String, String> getValues() {
                    return this.values;
                }
            }

            public static final class Mention
            implements ModuleConfig.MessageConfig.FormatMessageConfig.SubFormatMessageConfig,
            Localizable {
                String person;
                String format;

                @Generated
                public String getPerson() {
                    return this.person;
                }

                @Generated
                public String getFormat() {
                    return this.format;
                }
            }

            public static final class Moderation
            implements ModuleConfig.MessageConfig.FormatMessageConfig.ModerationFormatMessageConfig,
            Localizable {
                @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/message/format/moderation/delete/")
                Delete delete = new Delete();
                @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/message/format/moderation/newbie/")
                Newbie newbie = new Newbie();
                @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/message/format/moderation/swear/")
                Swear swear = new Swear();

                @Override
                public ModuleConfig.MessageConfig.FormatMessageConfig.ModerationFormatMessageConfig.SubModerationFormatMessageConfig getCaps() {
                    return null;
                }

                @Override
                public ModuleConfig.MessageConfig.FormatMessageConfig.ModerationFormatMessageConfig.SubModerationFormatMessageConfig getFlood() {
                    return null;
                }

                @Override
                @Generated
                public Delete getDelete() {
                    return this.delete;
                }

                @Override
                @Generated
                public Newbie getNewbie() {
                    return this.newbie;
                }

                @Override
                @Generated
                public Swear getSwear() {
                    return this.swear;
                }

                public static final class Delete
                implements ModuleConfig.MessageConfig.FormatMessageConfig.ModerationFormatMessageConfig.SubModerationFormatMessageConfig,
                Localizable {
                    String placeholder;
                    String format;

                    @Generated
                    public String getPlaceholder() {
                        return this.placeholder;
                    }

                    @Generated
                    public String getFormat() {
                        return this.format;
                    }
                }

                public static final class Newbie
                implements ModuleConfig.MessageConfig.FormatMessageConfig.ModerationFormatMessageConfig.SubModerationFormatMessageConfig,
                Localizable {
                    String reason;

                    @Generated
                    public String getReason() {
                        return this.reason;
                    }
                }

                public static final class Swear
                implements ModuleConfig.MessageConfig.FormatMessageConfig.ModerationFormatMessageConfig.SubModerationFormatMessageConfig,
                Localizable {
                    String symbol;

                    @Generated
                    public String getSymbol() {
                        return this.symbol;
                    }
                }
            }

            public static final class Names
            implements ModuleConfig.MessageConfig.FormatMessageConfig.SubFormatMessageConfig,
            Localizable {
                String constant;
                String display;
                String entity;
                String unknown;
                String invisible;

                @Generated
                public String getConstant() {
                    return this.constant;
                }

                @Generated
                public String getDisplay() {
                    return this.display;
                }

                @Generated
                public String getEntity() {
                    return this.entity;
                }

                @Generated
                public String getUnknown() {
                    return this.unknown;
                }

                @Generated
                public String getInvisible() {
                    return this.invisible;
                }

                @Generated
                public void setConstant(String constant) {
                    this.constant = constant;
                }

                @Generated
                public void setDisplay(String display) {
                    this.display = display;
                }

                @Generated
                public void setEntity(String entity) {
                    this.entity = entity;
                }

                @Generated
                public void setUnknown(String unknown) {
                    this.unknown = unknown;
                }

                @Generated
                public void setInvisible(String invisible) {
                    this.invisible = invisible;
                }
            }

            public static final class QuestionAnswer
            implements ModuleConfig.MessageConfig.FormatMessageConfig.SubFormatMessageConfig,
            Localizable {
                @JsonMerge(value=OptBoolean.FALSE)
                Map<String, String> questions = new LinkedHashMap<String, String>();

                @Generated
                public Map<String, String> getQuestions() {
                    return this.questions;
                }
            }

            public static final class Translate
            implements ModuleConfig.MessageConfig.FormatMessageConfig.SubFormatMessageConfig,
            Localizable {
                String action;

                @Generated
                public String getAction() {
                    return this.action;
                }
            }
        }

        public static final class Greeting
        implements ModuleConfig.MessageConfig.SubMessageConfig,
        Localizable {
            String format;

            @Generated
            public String getFormat() {
                return this.format;
            }
        }

        public static final class Join
        implements ModuleConfig.MessageConfig.SubMessageConfig,
        Localizable {
            String format;
            String formatFirstTime;

            @Generated
            public String getFormat() {
                return this.format;
            }

            @Generated
            public String getFormatFirstTime() {
                return this.formatFirstTime;
            }
        }

        public static final class Objective
        implements ModuleConfig.MessageConfig.ObjectiveMessageConfig,
        Localizable {
            @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/message/objective/belowname/")
            Belowname belowname = new Belowname();

            @Override
            public ModuleConfig.MessageConfig.ObjectiveMessageConfig.SubObjectiveMessageConfig getTabname() {
                return null;
            }

            @Override
            @Generated
            public Belowname getBelowname() {
                return this.belowname;
            }

            public static final class Belowname
            implements ModuleConfig.MessageConfig.ObjectiveMessageConfig.SubObjectiveMessageConfig,
            Localizable {
                String format;

                @Generated
                public String getFormat() {
                    return this.format;
                }
            }
        }

        public static final class Quit
        implements ModuleConfig.MessageConfig.SubMessageConfig,
        Localizable {
            String format;

            @Generated
            public String getFormat() {
                return this.format;
            }
        }

        public static final class Rightclick
        implements ModuleConfig.MessageConfig.SubMessageConfig,
        Localizable {
            String format;

            @Generated
            public String getFormat() {
                return this.format;
            }
        }

        public static final class Sidebar
        implements ModuleConfig.MessageConfig.SubMessageConfig,
        Localizable {
            @JsonMerge(value=OptBoolean.FALSE)
            List<List<String>> values = new LinkedList<List<String>>();

            @Generated
            public List<List<String>> getValues() {
                return this.values;
            }
        }

        public static final class Status
        implements ModuleConfig.MessageConfig.StatusMessageConfig,
        Localizable {
            @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/message/status/motd/")
            MOTD motd = new MOTD();
            @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/message/status/players/")
            Players players = new Players();
            @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/message/status/version/")
            Version version = new Version();

            @Override
            public ModuleConfig.MessageConfig.StatusMessageConfig.SubStatusMessageConfig getIcon() {
                return null;
            }

            @Override
            @Generated
            public MOTD getMotd() {
                return this.motd;
            }

            @Override
            @Generated
            public Players getPlayers() {
                return this.players;
            }

            @Override
            @Generated
            public Version getVersion() {
                return this.version;
            }

            public static final class MOTD
            implements ModuleConfig.MessageConfig.StatusMessageConfig.SubStatusMessageConfig,
            Localizable {
                @JsonMerge(value=OptBoolean.FALSE)
                List<String> values = new LinkedList<String>();

                @Generated
                public List<String> getValues() {
                    return this.values;
                }
            }

            public static final class Players
            implements ModuleConfig.MessageConfig.StatusMessageConfig.SubStatusMessageConfig,
            Localizable {
                @JsonMerge(value=OptBoolean.FALSE)
                List<Sample> samples = new LinkedList<Sample>();
                String full;

                @Generated
                public List<Sample> getSamples() {
                    return this.samples;
                }

                @Generated
                public String getFull() {
                    return this.full;
                }

                public static final class Sample {
                    String name = "<players>";
                    String id = null;

                    @Generated
                    public String getName() {
                        return this.name;
                    }

                    @Generated
                    public String getId() {
                        return this.id;
                    }

                    @Generated
                    public Sample() {
                    }
                }
            }

            public static final class Version
            implements ModuleConfig.MessageConfig.StatusMessageConfig.SubStatusMessageConfig,
            Localizable {
                String name;

                @Generated
                public String getName() {
                    return this.name;
                }
            }
        }

        public static final class Tab
        implements ModuleConfig.MessageConfig.TabMessageConfig,
        Localizable {
            @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/message/tab/header/")
            Header header = new Header();
            @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/message/tab/footer/")
            Footer footer = new Footer();
            @JsonPropertyDescription(value=" https://flectone.net/pulse/docs/message/tab/playerlistname/")
            Playerlistname playerlistname = new Playerlistname();

            @Override
            @Generated
            public Header getHeader() {
                return this.header;
            }

            @Override
            @Generated
            public Footer getFooter() {
                return this.footer;
            }

            @Override
            @Generated
            public Playerlistname getPlayerlistname() {
                return this.playerlistname;
            }

            public static final class Header
            implements ModuleConfig.MessageConfig.TabMessageConfig.SubTabMessageConfig,
            Localizable {
                @JsonMerge(value=OptBoolean.FALSE)
                List<List<String>> lists = new LinkedList<List<String>>();

                @Generated
                public List<List<String>> getLists() {
                    return this.lists;
                }
            }

            public static final class Footer
            implements ModuleConfig.MessageConfig.TabMessageConfig.SubTabMessageConfig,
            Localizable {
                @JsonMerge(value=OptBoolean.FALSE)
                List<List<String>> lists = new LinkedList<List<String>>();

                @Generated
                public List<List<String>> getLists() {
                    return this.lists;
                }
            }

            public static final class Playerlistname
            implements ModuleConfig.MessageConfig.TabMessageConfig.SubTabMessageConfig,
            Localizable {
                String format;

                @Generated
                public String getFormat() {
                    return this.format;
                }
            }
        }

        public static final class Update
        implements ModuleConfig.MessageConfig.SubMessageConfig,
        Localizable {
            String formatPlayer;
            String formatConsole;

            @Generated
            public String getFormatPlayer() {
                return this.formatPlayer;
            }

            @Generated
            public String getFormatConsole() {
                return this.formatConsole;
            }
        }

        public static final class Vanilla
        implements ModuleConfig.MessageConfig.SubMessageConfig,
        Localizable {
            Map<String, String> types = new LinkedHashMap<String, String>();

            @Generated
            public Map<String, String> getTypes() {
                return this.types;
            }
        }
    }

    public static class ReasonMap
    extends LinkedHashMap<String, String> {
        public String getConstant(String reason) {
            if (StringUtils.isEmpty((CharSequence)reason)) {
                return super.getOrDefault("default", "UNKNOWN");
            }
            return super.getOrDefault(reason, reason);
        }
    }

    public static final class ListTypeMessage {
        String header;
        String line;
        String footer;

        @Generated
        public String getHeader() {
            return this.header;
        }

        @Generated
        public String getLine() {
            return this.line;
        }

        @Generated
        public String getFooter() {
            return this.footer;
        }

        @Generated
        public ListTypeMessage() {
        }
    }

    public static interface Localizable {
    }
}

