/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.data.repository;

import java.util.List;
import java.util.UUID;
import lombok.Generated;
import net.flectone.pulse.data.database.dao.ModerationDAO;
import net.flectone.pulse.library.cloud.cloud.type.tuple.Pair;
import net.flectone.pulse.library.guava.cache.Cache;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.guice.name.Named;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.util.Moderation;

@Singleton
public class ModerationRepository {
    @Named(value="moderation")
    private final Cache<Pair<UUID, Moderation.Type>, List<Moderation>> moderationCache;
    private final ModerationDAO moderationDAO;

    public List<Moderation> getValid(FPlayer player, Moderation.Type type) {
        try {
            Pair key = Pair.of((Object)player.getUuid(), (Object)((Object)type));
            return (List)this.moderationCache.get((Object)key, () -> this.moderationDAO.getValid(player, type).stream().filter(Moderation::isActive).toList());
        }
        catch (Exception e) {
            return List.of();
        }
    }

    public void invalidate(UUID playerId, Moderation.Type type) {
        this.moderationCache.invalidate((Object)Pair.of((Object)playerId, (Object)((Object)type)));
    }

    public void invalidateAll() {
        this.moderationCache.invalidateAll();
    }

    public void invalidateAll(UUID playerId) {
        this.moderationCache.asMap().keySet().removeIf(key -> ((UUID)key.first()).equals(playerId));
    }

    public List<Moderation> get(FPlayer fPlayer, Moderation.Type type) {
        return this.moderationDAO.get(fPlayer, type);
    }

    public Moderation save(FPlayer fTarget, long time, String reason, int moderatorID, Moderation.Type type) {
        return this.moderationDAO.insert(fTarget, time, reason, moderatorID, type);
    }

    public List<Moderation> getValid(Moderation.Type type) {
        return this.moderationDAO.getValid(type);
    }

    public List<String> getValidNames(Moderation.Type type) {
        return this.moderationDAO.getValidPlayersNames(type);
    }

    public void updateValid(Moderation moderation) {
        this.moderationDAO.updateValid(moderation);
    }

    @Inject
    @Generated
    public ModerationRepository(@Named(value="moderation") Cache<Pair<UUID, Moderation.Type>, List<Moderation>> moderationCache, ModerationDAO moderationDAO) {
        this.moderationCache = moderationCache;
        this.moderationDAO = moderationDAO;
    }
}

