/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.listener;

import java.util.UUID;
import lombok.Generated;
import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.execution.dispatcher.EventDispatcher;
import net.flectone.pulse.library.adventure.text.Component;
import net.flectone.pulse.library.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.packetevents.manager.server.ServerVersion;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.player.PlayerLoadEvent;
import net.flectone.pulse.model.event.player.PlayerPersistAndDisposeEvent;
import net.flectone.pulse.model.event.player.PlayerQuitEvent;
import net.flectone.pulse.platform.provider.PacketProvider;
import net.flectone.pulse.processing.processor.PlayerPreLoginProcessor;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerJoinEvent;

@Singleton
public class BukkitBaseListener
implements Listener {
    private final FileResolver fileResolver;
    private final FPlayerService fPlayerService;
    private final EventDispatcher eventDispatcher;
    private final PacketProvider packetProvider;
    private final PlayerPreLoginProcessor playerPreLoginProcessor;

    @EventHandler
    public void onAsyncPreLoginEvent(AsyncPlayerPreLoginEvent event) {
        if (this.packetProvider.getServerVersion().isOlderThanOrEquals(ServerVersion.V_1_20_1)) {
            UUID uuid = event.getUniqueId();
            String name = event.getName();
            this.playerPreLoginProcessor.processLogin(uuid, name, loginEvent -> {}, loginEvent -> {
                event.setLoginResult(AsyncPlayerPreLoginEvent.Result.KICK_OTHER);
                Component reason = loginEvent.getKickReason();
                event.setKickMessage(LegacyComponentSerializer.legacySection().serialize(reason));
            });
        }
    }

    @EventHandler
    public void onPlayerJoinEvent(PlayerJoinEvent event) {
        this.asyncProcessJoinEvent(event);
    }

    @EventHandler
    public void onPlayerQuitEvent(org.bukkit.event.player.PlayerQuitEvent event) {
        this.asyncProcessQuitEvent(event);
    }

    @Async
    public void asyncProcessJoinEvent(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        FPlayer fPlayer = this.fPlayerService.getFPlayer(uuid);
        if (this.packetProvider.getServerVersion().isOlderThan(ServerVersion.V_1_20_2)) {
            String locale = this.getPlayerLocale(player);
            this.fPlayerService.updateLocale(fPlayer, locale);
        }
        this.eventDispatcher.dispatch(new PlayerLoadEvent(fPlayer));
        this.eventDispatcher.dispatch(new net.flectone.pulse.model.event.player.PlayerJoinEvent(fPlayer));
    }

    @Async
    public void asyncProcessQuitEvent(org.bukkit.event.player.PlayerQuitEvent event) {
        UUID uuid = event.getPlayer().getUniqueId();
        FPlayer fPlayer = this.fPlayerService.getFPlayer(uuid);
        this.eventDispatcher.dispatch(new PlayerQuitEvent(fPlayer));
        this.eventDispatcher.dispatch(new PlayerPersistAndDisposeEvent(fPlayer));
    }

    private String getPlayerLocale(Player player) {
        try {
            return player.getLocale();
        }
        catch (NoSuchMethodError e) {
            return this.fileResolver.getConfig().getLanguage().getType();
        }
    }

    @Inject
    @Generated
    public BukkitBaseListener(FileResolver fileResolver, FPlayerService fPlayerService, EventDispatcher eventDispatcher, PacketProvider packetProvider, PlayerPreLoginProcessor playerPreLoginProcessor) {
        this.fileResolver = fileResolver;
        this.fPlayerService = fPlayerService;
        this.eventDispatcher = eventDispatcher;
        this.packetProvider = packetProvider;
        this.playerPreLoginProcessor = playerPreLoginProcessor;
    }
}

