/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.listener;

import lombok.Generated;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.packetevents.event.PacketListener;
import net.flectone.pulse.library.packetevents.event.PacketReceiveEvent;
import net.flectone.pulse.library.packetevents.protocol.packettype.PacketType;
import net.flectone.pulse.library.packetevents.protocol.packettype.PacketTypeCommon;
import net.flectone.pulse.library.packetevents.protocol.player.User;
import net.flectone.pulse.library.packetevents.wrapper.play.client.WrapperPlayClientClickWindow;
import net.flectone.pulse.model.inventory.Inventory;
import net.flectone.pulse.platform.controller.InventoryController;

@Singleton
public class InventoryPacketListener
implements PacketListener {
    private final InventoryController inventoryController;

    public void onPacketReceive(PacketReceiveEvent event) {
        PacketTypeCommon packetType = event.getPacketType();
        if (packetType == PacketType.Play.Client.CLOSE_WINDOW) {
            this.inventoryController.close(event.getUser().getUUID());
            return;
        }
        if (packetType == PacketType.Play.Client.CLICK_WINDOW) {
            User user = event.getUser();
            Inventory inventory = this.inventoryController.get(user.getUUID());
            if (inventory == null) {
                return;
            }
            event.setCancelled(true);
            this.inventoryController.process(user.getUUID(), new WrapperPlayClientClickWindow(event));
        }
    }

    @Inject
    @Generated
    public InventoryPacketListener(InventoryController inventoryController) {
        this.inventoryController = inventoryController;
    }
}

