/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.model.inventory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import lombok.Generated;
import net.flectone.pulse.library.adventure.text.Component;
import net.flectone.pulse.library.packetevents.protocol.item.ItemStack;
import net.flectone.pulse.library.packetevents.wrapper.play.server.WrapperPlayServerOpenWindow;
import net.flectone.pulse.library.packetevents.wrapper.play.server.WrapperPlayServerWindowItems;

public class Inventory {
    private final int size;
    private final Map<Integer, BiConsumer<ItemStack, Inventory>> clickConsumerMap = new HashMap<Integer, BiConsumer<ItemStack, Inventory>>();
    private final List<Consumer<Inventory>> closeConsumerList = new ArrayList<Consumer<Inventory>>();
    private final WrapperPlayServerOpenWindow wrapperWindow;
    private WrapperPlayServerWindowItems wrapperItems;

    public Inventory(int size, Map<Integer, BiConsumer<ItemStack, Inventory>> clickConsumerMap, List<Consumer<Inventory>> closeConsumerList, WrapperPlayServerOpenWindow wrapperWindow, WrapperPlayServerWindowItems wrapperItems) {
        this.size = size;
        this.clickConsumerMap.putAll(clickConsumerMap);
        this.closeConsumerList.addAll(closeConsumerList);
        this.wrapperWindow = wrapperWindow;
        this.wrapperItems = wrapperItems;
    }

    @Generated
    public int getSize() {
        return this.size;
    }

    @Generated
    public Map<Integer, BiConsumer<ItemStack, Inventory>> getClickConsumerMap() {
        return this.clickConsumerMap;
    }

    @Generated
    public List<Consumer<Inventory>> getCloseConsumerList() {
        return this.closeConsumerList;
    }

    @Generated
    public WrapperPlayServerOpenWindow getWrapperWindow() {
        return this.wrapperWindow;
    }

    @Generated
    public WrapperPlayServerWindowItems getWrapperItems() {
        return this.wrapperItems;
    }

    @Generated
    public void setWrapperItems(WrapperPlayServerWindowItems wrapperItems) {
        this.wrapperItems = wrapperItems;
    }

    public static class Builder {
        private Component name = Component.empty();
        private int size;
        private final Map<Integer, ItemStack> itemMap = new HashMap<Integer, ItemStack>();
        private final Map<Integer, BiConsumer<ItemStack, Inventory>> clickConsumerMap = new HashMap<Integer, BiConsumer<ItemStack, Inventory>>();
        private final List<Consumer<Inventory>> closeConsumerList = new ArrayList<Consumer<Inventory>>();

        public Builder name(Component name) {
            this.name = name;
            return this;
        }

        public Builder size(int size) {
            this.size = size;
            return this;
        }

        public Builder addItem(int index, ItemStack itemStack) {
            this.itemMap.put(index, itemStack);
            return this;
        }

        public Builder addClickHandler(int index, BiConsumer<ItemStack, Inventory> consumer) {
            this.clickConsumerMap.put(index, consumer);
            return this;
        }

        public Builder addCloseConsumer(Consumer<Inventory> consumer) {
            this.closeConsumerList.add(consumer);
            return this;
        }

        public Inventory build(boolean modern) {
            WrapperPlayServerOpenWindow wrapperWindow = modern ? new WrapperPlayServerOpenWindow(126, this.size >= 24 ? 5 : this.size, this.name) : new WrapperPlayServerOpenWindow(126, "chest", this.name, this.size, 0);
            ArrayList<ItemStack> items = new ArrayList<ItemStack>(this.size);
            for (int i = 0; i < this.size; ++i) {
                items.add(this.itemMap.getOrDefault(i, ItemStack.EMPTY));
            }
            WrapperPlayServerWindowItems wrapperItems = new WrapperPlayServerWindowItems(126, 0, items, null);
            return new Inventory(this.size, this.clickConsumerMap, this.closeConsumerList, wrapperWindow, wrapperItems);
        }
    }
}

