/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.model.util;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import net.flectone.pulse.library.jackson.annotation.JsonCreator;
import net.flectone.pulse.library.jackson.annotation.JsonValue;
import net.flectone.pulse.model.entity.FPlayer;

public class Cooldown {
    private final HashMap<UUID, Long> playerDuration = new HashMap();
    private final boolean enable;
    private final long duration;
    private String permissionBypass = "";

    public Cooldown(boolean enable, long duration) {
        this.enable = enable;
        this.duration = duration;
    }

    public Cooldown() {
        this(false, 60L);
    }

    public boolean isCooldown(UUID uuid) {
        if (!this.isEnable()) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        Long time = this.playerDuration.get(uuid);
        if (time == null || currentTime >= time) {
            this.playerDuration.put(uuid, currentTime + this.duration * 50L);
            return false;
        }
        return true;
    }

    public long getTimeLeft(FPlayer fPlayer) {
        return this.playerDuration.getOrDefault(fPlayer.getUuid(), 0L) - System.currentTimeMillis();
    }

    @JsonValue
    public Map<String, Object> toJson() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("enable", this.enable);
        if (this.enable) {
            map.put("duration", this.duration);
        }
        return map;
    }

    @JsonCreator
    public static Cooldown fromJson(Map<String, Object> map) {
        boolean isEnable = Boolean.parseBoolean(String.valueOf(map.get("enable")));
        if (!isEnable) {
            return new Cooldown();
        }
        Object duration = map.get("duration");
        long longDuration = duration == null ? 60L : Long.parseLong(String.valueOf(duration));
        return new Cooldown(true, longDuration);
    }

    @Generated
    public HashMap<UUID, Long> getPlayerDuration() {
        return this.playerDuration;
    }

    @Generated
    public boolean isEnable() {
        return this.enable;
    }

    @Generated
    public long getDuration() {
        return this.duration;
    }

    @Generated
    public String getPermissionBypass() {
        return this.permissionBypass;
    }

    @Generated
    public void setPermissionBypass(String permissionBypass) {
        this.permissionBypass = permissionBypass;
    }
}

