/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.model.util;

import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import net.flectone.pulse.library.adventure.bossbar.BossBar;
import net.flectone.pulse.library.jackson.annotation.JsonCreator;
import net.flectone.pulse.library.jackson.annotation.JsonValue;
import net.flectone.pulse.model.util.BossBar;
import net.flectone.pulse.model.util.Times;
import net.flectone.pulse.model.util.Toast;

public class Destination {
    private final Type type;
    private final String subtext;
    private final BossBar bossBar;
    private final Times times;
    private final Toast toast;

    public Destination(Type type, String subtext, BossBar bossBar, Times times, Toast toast) {
        this.type = type != null ? type : Type.CHAT;
        this.subtext = subtext != null ? subtext : "";
        this.bossBar = bossBar != null ? bossBar : new BossBar(100L, 1.0f, BossBar.Overlay.PROGRESS, BossBar.Color.BLUE);
        this.times = times != null ? times : new Times(20, 60, 20);
        this.toast = toast != null ? toast : new Toast("minecraft:diamond", Toast.Type.TASK);
    }

    public Destination() {
        this(null, null, null, null, null);
    }

    public Destination(Type type) {
        this(type, null, null, null, null);
    }

    public Destination(Type type, BossBar bossBar) {
        this(type, null, bossBar, null, null);
    }

    public Destination(Type type, Times times) {
        this(type, null, null, times, null);
    }

    public Destination(Type type, Times times, String subtext) {
        this(type, subtext, null, times, null);
    }

    public Destination(Type type, Toast toast) {
        this(type, null, null, null, toast);
    }

    @JsonValue
    public Map<String, Object> toJson() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("type", (Object)this.type);
        switch (this.type.ordinal()) {
            case 8: {
                Toast toast = this.toast;
                map.put("icon", toast.icon());
                map.put("style", (Object)toast.style());
                break;
            }
            case 0: 
            case 4: 
            case 5: {
                Times times = this.times;
                LinkedHashMap<String, Integer> timesMap = new LinkedHashMap<String, Integer>();
                timesMap.put("stay", times.stayTicks());
                if (this.type != Type.ACTION_BAR) {
                    timesMap.put("fade-in", times.fadeInTicks());
                    timesMap.put("fade-out", times.fadeOutTicks());
                    map.put("subtext", this.subtext);
                }
                map.put("times", timesMap);
                break;
            }
            case 1: {
                BossBar bossBar = this.bossBar;
                map.put("duration", bossBar.getDuration());
                map.put("health", Float.valueOf(bossBar.getHealth()));
                map.put("overlay", bossBar.getOverlay());
                map.put("color", bossBar.getColor());
                map.put("play_boss_music", bossBar.getFlags().contains(BossBar.Flag.PLAY_BOSS_MUSIC));
                map.put("create_world_fog", bossBar.getFlags().contains(BossBar.Flag.CREATE_WORLD_FOG));
                map.put("darken_screen", bossBar.getFlags().contains(BossBar.Flag.DARKEN_SCREEN));
            }
        }
        return map;
    }

    @JsonCreator
    public static Destination fromJson(Map<String, Object> map) {
        Type type = Type.valueOf(String.valueOf(map.get("type")));
        return switch (type.ordinal()) {
            case 8 -> {
                Object icon = map.get("icon");
                String stringIcon = icon == null ? "minecraft:diamond" : String.valueOf(icon);
                Object style = map.get("style");
                Toast.Type toastStyle = style == null ? Toast.Type.TASK : Toast.Type.valueOf(String.valueOf(style));
                yield new Destination(Type.TOAST, new Toast(stringIcon, toastStyle));
            }
            case 0, 4, 5 -> {
                Object times = map.get("times");
                if (times == null) {
                    yield new Destination(type);
                }
                Map timesMap = (Map)times;
                Object fadeIn = timesMap.get("fade_in");
                int fadeInTicks = fadeIn == null ? 20 : Integer.parseInt(String.valueOf(fadeIn));
                Object stay = timesMap.get("stay");
                int stayTicks = stay == null ? 60 : Integer.parseInt(String.valueOf(stay));
                Object fadeOut = timesMap.get("fade_out");
                int fadeOutTicks = fadeOut == null ? 20 : Integer.parseInt(String.valueOf(fadeOut));
                Times titleTimes = new Times(fadeInTicks, stayTicks, fadeOutTicks);
                if (type == Type.ACTION_BAR) {
                    yield new Destination(type, titleTimes);
                }
                Object subtext = map.get("subtext");
                String stringSubtext = subtext == null ? "" : String.valueOf(subtext);
                yield new Destination(type, titleTimes, stringSubtext);
            }
            case 1 -> {
                Object darkenScreen;
                Object createWorldFog;
                Object duration = map.get("duration");
                long longDuration = duration == null ? 100L : Long.parseLong(String.valueOf(duration));
                Object health = map.get("health");
                float floatHealth = health == null ? 1.0f : Float.parseFloat(String.valueOf(health));
                Object overlay = map.get("overlay");
                BossBar.Overlay bossBarOverlay = overlay == null ? BossBar.Overlay.PROGRESS : BossBar.Overlay.valueOf((String)String.valueOf(overlay));
                Object color = map.get("color");
                BossBar.Color bossBarColor = color == null ? BossBar.Color.BLUE : BossBar.Color.valueOf((String)String.valueOf(color));
                BossBar bossBar = new BossBar(longDuration, floatHealth, bossBarOverlay, bossBarColor);
                Object playBossMusic = map.get("play-boss-music");
                if (playBossMusic != null && Boolean.parseBoolean(String.valueOf(playBossMusic))) {
                    bossBar.addFlag(BossBar.Flag.PLAY_BOSS_MUSIC);
                }
                if ((createWorldFog = map.get("create-world-fog")) != null && Boolean.parseBoolean(String.valueOf(createWorldFog))) {
                    bossBar.addFlag(BossBar.Flag.CREATE_WORLD_FOG);
                }
                if ((darkenScreen = map.get("darken-screen")) != null && Boolean.parseBoolean(String.valueOf(darkenScreen))) {
                    bossBar.addFlag(BossBar.Flag.DARKEN_SCREEN);
                }
                yield new Destination(type, bossBar);
            }
            default -> new Destination(type);
        };
    }

    @Generated
    public Type getType() {
        return this.type;
    }

    @Generated
    public String getSubtext() {
        return this.subtext;
    }

    @Generated
    public BossBar getBossBar() {
        return this.bossBar;
    }

    @Generated
    public Times getTimes() {
        return this.times;
    }

    @Generated
    public Toast getToast() {
        return this.toast;
    }

    public static enum Type {
        ACTION_BAR,
        BOSS_BAR,
        BRAND,
        CHAT,
        TITLE,
        SUBTITLE,
        TAB_HEADER,
        TAB_FOOTER,
        TOAST;

    }
}

