/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module;

import bukkit-downgraded.xyz.wagyourtail.jvmdg.j21.stub.java_base.J_U_List;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.library.cloud.cloud.Command;
import net.flectone.pulse.library.cloud.cloud.CommandManager;
import net.flectone.pulse.library.cloud.cloud.context.CommandContext;
import net.flectone.pulse.library.cloud.cloud.execution.CommandExecutionHandler;
import net.flectone.pulse.library.cloud.cloud.meta.CommandMeta;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.AbstractModuleLocalization;
import net.flectone.pulse.platform.registry.CommandRegistry;
import net.flectone.pulse.processing.resolver.FileResolver;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class AbstractModuleCommand<M extends Localization.Localizable>
extends AbstractModuleLocalization<M>
implements CommandExecutionHandler<FPlayer> {
    private final List<String> prompts = new ArrayList<String>();
    @Inject
    private FileResolver fileResolver;
    @Inject
    private CommandRegistry commandParserProvider;

    protected void registerCommand(UnaryOperator<Command.Builder<FPlayer>> commandBuilderOperator) {
        List<String> aliases = this.config().getAliases();
        String commandName = this.getCommandName();
        this.commandParserProvider.registerCommand((CommandManager<FPlayer> manager) -> ((Command.Builder)commandBuilderOperator.apply(manager.commandBuilder(commandName, (Collection)aliases, CommandMeta.empty()))).handler((CommandExecutionHandler)this));
    }

    protected void registerCustomCommand(Function<CommandManager<FPlayer>, Command.Builder<FPlayer>> builder) {
        this.commandParserProvider.registerCommand(builder);
    }

    protected void clearPrompts() {
        if (this.fileResolver.getConfig().getCommand().isUnregisterOnReload()) {
            this.prompts.clear();
        }
    }

    protected String addPrompt(int index, Function<Localization.Command.Prompt, String> promptLocalization) {
        if (this.prompts.size() != index) {
            return "unknown";
        }
        String prompt = promptLocalization.apply(this.fileResolver.getLocalization().getCommand().getPrompt());
        this.prompts.add(prompt);
        return prompt;
    }

    protected String getPrompt(int index) {
        if (this.prompts.size() - 1 < index) {
            throw new IllegalArgumentException("Argument at index " + index + " is not registered in the " + this.getCommandName() + " command");
        }
        return this.prompts.get(index);
    }

    protected <V> V getArgument(CommandContext<FPlayer> commandContext, int promptIndex) {
        String prompt = this.getPrompt(promptIndex);
        return (V)commandContext.get(prompt);
    }

    public String getCommandName() {
        List<String> aliases = this.config().getAliases();
        if (aliases.isEmpty()) {
            return "flectonepulsenull";
        }
        return J_U_List.getFirst(aliases);
    }

    @Override
    public void onEnable() {
        super.onEnable();
        this.createCooldown(this.config().getCooldown(), this.permission().getCooldownBypass());
        this.createSound(this.config().getSound(), this.permission().getSound());
    }

    @Override
    public void onDisable() {
        super.onDisable();
        this.clearPrompts();
    }

    public void execute(@NonNull CommandContext<FPlayer> commandContext) {
        this.execute((FPlayer)commandContext.sender(), commandContext);
    }

    @Override
    public abstract Permission.ICommandPermission permission();

    public abstract void execute(FPlayer var1, CommandContext<FPlayer> var2);

    @Override
    public abstract Command.ICommandFile config();
}

