/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.afk;

import lombok.Generated;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.library.cloud.cloud.context.CommandContext;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.AbstractModuleCommand;
import net.flectone.pulse.platform.sender.SoundPlayer;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.constant.MessageType;
import net.flectone.pulse.util.constant.SettingText;

@Singleton
public class AfkModule
extends AbstractModuleCommand<Localization.Command> {
    private final FileResolver fileResolver;
    private final net.flectone.pulse.module.message.afk.AfkModule afkMessageModule;
    private final SoundPlayer soundPlayer;

    @Override
    public void onEnable() {
        super.onEnable();
        this.registerCommand(commandBuilder -> commandBuilder.permission(this.permission().getName()));
    }

    @Override
    public MessageType messageType() {
        return MessageType.COMMAND_AFK;
    }

    @Override
    public Command.Afk config() {
        return this.fileResolver.getCommand().getAfk();
    }

    @Override
    public Permission.Command.Afk permission() {
        return this.fileResolver.getPermission().getCommand().getAfk();
    }

    @Override
    public Localization.Command localization(FEntity sender) {
        return this.fileResolver.getLocalization(sender).getCommand();
    }

    @Override
    public void execute(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        if (this.isModuleDisabledFor(fPlayer, true)) {
            return;
        }
        if (fPlayer.getSetting(SettingText.AFK_SUFFIX) != null) {
            this.afkMessageModule.remove("afk", fPlayer);
        } else {
            this.afkMessageModule.setAfk(fPlayer);
        }
        this.soundPlayer.play(this.getModuleSound(), fPlayer);
    }

    @Inject
    @Generated
    public AfkModule(FileResolver fileResolver, net.flectone.pulse.module.message.afk.AfkModule afkMessageModule, SoundPlayer soundPlayer) {
        this.fileResolver = fileResolver;
        this.afkMessageModule = afkMessageModule;
        this.soundPlayer = soundPlayer;
    }
}

