/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.anon;

import lombok.Generated;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.library.cloud.cloud.context.CommandContext;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleCommand;
import net.flectone.pulse.platform.provider.CommandParserProvider;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.constant.MessageType;

@Singleton
public class AnonModule
extends AbstractModuleCommand<Localization.Command.Anon> {
    private final FileResolver fileResolver;
    private final CommandParserProvider commandParserProvider;

    @Override
    public void onEnable() {
        super.onEnable();
        String promptMessage = this.addPrompt(0, Localization.Command.Prompt::getMessage);
        this.registerCommand(commandBuilder -> commandBuilder.permission(this.permission().getName()).required(promptMessage, this.commandParserProvider.nativeMessageParser()));
    }

    @Override
    public void execute(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        if (this.isModuleDisabledFor(fPlayer, true)) {
            return;
        }
        String message = (String)this.getArgument(commandContext, 0);
        this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Anon::getFormat)).message(message)).destination(this.config().getDestination())).range(this.config().getRange())).sound(this.getModuleSound())).proxy(dataOutputStream -> dataOutputStream.writeString(message))).integration()).build());
    }

    @Override
    public MessageType messageType() {
        return MessageType.COMMAND_ANON;
    }

    @Override
    public Command.Anon config() {
        return this.fileResolver.getCommand().getAnon();
    }

    @Override
    public Permission.Command.Anon permission() {
        return this.fileResolver.getPermission().getCommand().getAnon();
    }

    @Override
    public Localization.Command.Anon localization(FEntity sender) {
        return this.fileResolver.getLocalization(sender).getCommand().getAnon();
    }

    @Inject
    @Generated
    public AnonModule(FileResolver fileResolver, CommandParserProvider commandParserProvider) {
        this.fileResolver = fileResolver;
        this.commandParserProvider = commandParserProvider;
    }
}

