/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.ball;

import java.util.List;
import java.util.function.Function;
import lombok.Generated;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.cloud.cloud.context.CommandContext;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleCommand;
import net.flectone.pulse.module.command.ball.model.BallMetadata;
import net.flectone.pulse.platform.provider.CommandParserProvider;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.RandomUtil;
import net.flectone.pulse.util.constant.MessageType;

@Singleton
public class BallModule
extends AbstractModuleCommand<Localization.Command.Ball> {
    private final FileResolver fileResolver;
    private final RandomUtil randomUtil;
    private final CommandParserProvider commandParserProvider;

    @Override
    public void onEnable() {
        super.onEnable();
        String promptMessage = this.addPrompt(0, Localization.Command.Prompt::getMessage);
        this.registerCommand(commandBuilder -> commandBuilder.permission(this.permission().getName()).required(promptMessage, this.commandParserProvider.nativeMessageParser()));
    }

    @Override
    public void execute(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        if (this.isModuleDisabledFor(fPlayer, true)) {
            return;
        }
        int answer = this.randomUtil.nextInt(0, ((Localization.Command.Ball)this.localization()).getAnswers().size());
        String message = (String)this.getArgument(commandContext, 0);
        this.sendMessage(((BallMetadata.BallMetadataBuilder)((BallMetadata.BallMetadataBuilder)((BallMetadata.BallMetadataBuilder)((BallMetadata.BallMetadataBuilder)((BallMetadata.BallMetadataBuilder)((BallMetadata.BallMetadataBuilder)((EventMetadata.EventMetadataBuilder)((BallMetadata.BallMetadataBuilder)((BallMetadata.BallMetadataBuilder)BallMetadata.builder().sender(fPlayer)).format(this.replaceAnswer(answer))).answer(answer)).message(message)).destination(this.config().getDestination())).range(this.config().getRange())).sound(this.getModuleSound())).proxy(dataOutputStream -> {
            dataOutputStream.writeInt(answer);
            dataOutputStream.writeString(message);
        })).integration(string -> {
            List<String> answers = ((Localization.Command.Ball)this.localization()).getAnswers();
            String answerString = !answers.isEmpty() ? answers.get(Math.min(answer, answers.size() - 1)) : "";
            return Strings.CS.replace(string, "<answer>", answerString);
        })).build());
    }

    @Override
    public MessageType messageType() {
        return MessageType.COMMAND_BALL;
    }

    @Override
    public Command.Ball config() {
        return this.fileResolver.getCommand().getBall();
    }

    @Override
    public Permission.Command.Ball permission() {
        return this.fileResolver.getPermission().getCommand().getBall();
    }

    @Override
    public Localization.Command.Ball localization(FEntity sender) {
        return this.fileResolver.getLocalization(sender).getCommand().getBall();
    }

    public Function<Localization.Command.Ball, String> replaceAnswer(int answer) {
        return message -> {
            List<String> answers = message.getAnswers();
            String answerString = !answers.isEmpty() ? answers.get(Math.min(answer, answers.size() - 1)) : "";
            return Strings.CS.replace(message.getFormat(), "<answer>", answerString);
        };
    }

    @Inject
    @Generated
    public BallModule(FileResolver fileResolver, RandomUtil randomUtil, CommandParserProvider commandParserProvider) {
        this.fileResolver = fileResolver;
        this.randomUtil = randomUtil;
        this.commandParserProvider = commandParserProvider;
    }
}

