/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.chatcolor;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.library.cloud.cloud.context.CommandContext;
import net.flectone.pulse.library.cloud.cloud.suggestion.BlockingSuggestionProvider;
import net.flectone.pulse.library.cloud.cloud.suggestion.Suggestion;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.FColor;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleCommand;
import net.flectone.pulse.platform.provider.CommandParserProvider;
import net.flectone.pulse.platform.sender.ProxySender;
import net.flectone.pulse.processing.converter.ColorConverter;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.checker.PermissionChecker;
import net.flectone.pulse.util.constant.MessageType;

@Singleton
public class ChatcolorModule
extends AbstractModuleCommand<Localization.Command.Chatcolor> {
    private final FileResolver fileResolver;
    private final FPlayerService fPlayerService;
    private final PermissionChecker permissionChecker;
    private final ProxySender proxySender;
    private final ColorConverter colorConverter;
    private final CommandParserProvider commandParserProvider;

    @Override
    public void onEnable() {
        super.onEnable();
        this.registerPermission(this.permission().getOther());
        this.permission().getColors().values().forEach(this::registerPermission);
        String promptType = this.addPrompt(0, Localization.Command.Prompt::getType);
        String promptColor = this.addPrompt(1, Localization.Command.Prompt::getColor);
        String promptPlayer = this.addPrompt(2, Localization.Command.Prompt::getPlayer);
        this.registerCommand(commandBuilder -> {
            commandBuilder = commandBuilder.permission(this.permission().getName()).required(promptType, this.commandParserProvider.singleMessageParser(), this.typeSuggestion());
            for (int i = 0; i < this.fColorConfig().getDefaultColors().size(); ++i) {
                commandBuilder = commandBuilder.optional(promptColor + " " + (i + 1), this.commandParserProvider.colorParser());
            }
            return commandBuilder.optional(promptPlayer, this.commandParserProvider.nativeMessageParser(), this.commandParserProvider.playerSuggestionPermission(true, this.permission().getOther()));
        });
    }

    @NonNull
    private BlockingSuggestionProvider<FPlayer> typeSuggestion() {
        return (context, input) -> Arrays.stream(FColor.Type.values()).filter(type -> this.permissionChecker.check((FEntity)context.sender(), this.permission().getColors().get(type))).map(setting -> Suggestion.suggestion((String)setting.name().toLowerCase())).toList();
    }

    @Override
    public void execute(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        String promptColor;
        Optional optionalClear;
        Optional<Object> fColorType;
        if (this.isModuleDisabledFor(fPlayer, true)) {
            return;
        }
        String type = (String)this.getArgument(commandContext, 0);
        switch (type.toLowerCase()) {
            case "out": {
                Optional<Object> optional = Optional.of(FColor.Type.OUT);
                break;
            }
            case "see": {
                Optional<Object> optional = Optional.of(FColor.Type.SEE);
                break;
            }
            default: {
                Optional<Object> optional = fColorType = Optional.empty();
            }
        }
        if (fColorType.isEmpty() || !this.permissionChecker.check((FEntity)fPlayer, this.permission().getColors().get(fColorType.get()))) {
            this.sendErrorMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Chatcolor::getNullType)).build());
            return;
        }
        boolean hasOtherPermission = this.permissionChecker.check((FEntity)fPlayer, this.permission().getOther());
        FPlayer fTarget = fPlayer;
        String promptPlayer = this.getPrompt(2);
        Optional optionalTarget = commandContext.optional(promptPlayer);
        if (optionalTarget.isPresent() && hasOtherPermission && (fTarget = this.fPlayerService.getFPlayer((String)optionalTarget.get())).isUnknown()) {
            fTarget = fPlayer;
        }
        if ((optionalClear = commandContext.optional((promptColor = this.getPrompt(1)) + " 1")).isPresent() && ((String)optionalClear.get()).equalsIgnoreCase("clear")) {
            this.setColors(fTarget, (FColor.Type)((Object)fColorType.get()), Collections.emptySet());
            return;
        }
        HashMap<Integer, FColor> newFColors = new HashMap<Integer, FColor>();
        fTarget.getFColors().getOrDefault(fColorType.get(), Set.of()).forEach(c -> newFColors.put(c.number(), (FColor)c));
        for (int i = 0; i < this.fColorConfig().getDefaultColors().size(); ++i) {
            String name;
            Optional optionalColor = commandContext.optional(promptColor + " " + (i + 1));
            if (optionalColor.isEmpty()) continue;
            String string = name = hasOtherPermission ? (String)optionalColor.get() : this.colorConverter.isCorrect(((String)optionalColor.get()).toLowerCase());
            if (name == null || name.equals("null")) continue;
            int number = i + 1;
            FColor fColor = new FColor(number, name);
            newFColors.put(number, fColor);
        }
        if (newFColors.isEmpty()) {
            this.sendErrorMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Chatcolor::getNullColor)).build());
            return;
        }
        this.setColors(fTarget, (FColor.Type)((Object)fColorType.get()), new HashSet<FColor>(newFColors.values()));
    }

    @Override
    public MessageType messageType() {
        return MessageType.COMMAND_CHATCOLOR;
    }

    @Override
    public Command.Chatcolor config() {
        return this.fileResolver.getCommand().getChatcolor();
    }

    @Override
    public Permission.Command.Chatcolor permission() {
        return this.fileResolver.getPermission().getCommand().getChatcolor();
    }

    @Override
    public Localization.Command.Chatcolor localization(FEntity sender) {
        return this.fileResolver.getLocalization(sender).getCommand().getChatcolor();
    }

    public Message.Format.FColor fColorConfig() {
        return this.fileResolver.getMessage().getFormat().getFcolor();
    }

    private void setColors(FPlayer fPlayer, FColor.Type type, Set<FColor> newFColors) {
        Map<FColor.Type, Set<FColor>> fColors = fPlayer.getFColors();
        Set oldFColors = fColors.getOrDefault((Object)type, Collections.emptySet());
        UUID metadataUUID = UUID.randomUUID();
        if (!oldFColors.equals(newFColors)) {
            if (newFColors.isEmpty()) {
                fColors.remove((Object)type);
            } else {
                fColors.put(type, newFColors);
            }
            this.fPlayerService.saveColors(fPlayer);
            this.proxySender.send(fPlayer, MessageType.COMMAND_CHATCOLOR, dataOutputStream -> {}, metadataUUID);
        }
        this.sendMessageWithUpdatedColors(fPlayer, metadataUUID);
    }

    public void sendMessageWithUpdatedColors(FPlayer fPlayer, UUID metadataUUID) {
        this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().uuid(metadataUUID)).sender(fPlayer)).format(Localization.Command.Chatcolor::getFormat)).destination(this.config().getDestination())).sound(this.getModuleSound())).build());
    }

    @Inject
    @Generated
    public ChatcolorModule(FileResolver fileResolver, FPlayerService fPlayerService, PermissionChecker permissionChecker, ProxySender proxySender, ColorConverter colorConverter, CommandParserProvider commandParserProvider) {
        this.fileResolver = fileResolver;
        this.fPlayerService = fPlayerService;
        this.permissionChecker = permissionChecker;
        this.proxySender = proxySender;
        this.colorConverter = colorConverter;
        this.commandParserProvider = commandParserProvider;
    }
}

