/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.clearchat;

import java.util.Optional;
import lombok.Generated;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.library.cloud.cloud.context.CommandContext;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleCommand;
import net.flectone.pulse.platform.adapter.PlatformPlayerAdapter;
import net.flectone.pulse.platform.provider.CommandParserProvider;
import net.flectone.pulse.platform.sender.ProxySender;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.checker.PermissionChecker;
import net.flectone.pulse.util.constant.MessageType;

@Singleton
public class ClearchatModule
extends AbstractModuleCommand<Localization.Command.Clearchat> {
    private final FileResolver fileResolver;
    private final FPlayerService fPlayerService;
    private final PermissionChecker permissionChecker;
    private final CommandParserProvider commandParserProvider;
    private final ProxySender proxySender;
    private final PlatformPlayerAdapter platformPlayerAdapter;

    @Override
    public void onEnable() {
        super.onEnable();
        this.registerPermission(this.permission().getOther());
        String promptPlayer = this.addPrompt(0, Localization.Command.Prompt::getPlayer);
        this.registerCommand(commandBuilder -> commandBuilder.permission(this.permission().getName()).optional(promptPlayer, this.commandParserProvider.playerParser(), this.commandParserProvider.playerSuggestionPermission(false, this.permission().getOther())));
    }

    @Override
    public void execute(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        if (this.isModuleDisabledFor(fPlayer, true)) {
            return;
        }
        String promptPlayer = this.getPrompt(0);
        Optional optionalPlayer = commandContext.optional(promptPlayer);
        FPlayer fTarget = fPlayer;
        if (optionalPlayer.isPresent() && this.permissionChecker.check((FEntity)fPlayer, this.permission().getOther())) {
            String player = (String)optionalPlayer.get();
            if (player.equals("all")) {
                this.fPlayerService.findOnlineFPlayers().forEach(this::clearChat);
                return;
            }
            fTarget = this.fPlayerService.getFPlayer(player);
            if (fTarget.isUnknown()) {
                this.sendErrorMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Clearchat::getNullPlayer)).build());
                return;
            }
        }
        this.clearChat(fTarget);
    }

    @Override
    public MessageType messageType() {
        return MessageType.COMMAND_CLEARCHAT;
    }

    @Override
    public Command.Clearchat config() {
        return this.fileResolver.getCommand().getClearchat();
    }

    @Override
    public Permission.Command.Clearchat permission() {
        return this.fileResolver.getPermission().getCommand().getClearchat();
    }

    @Override
    public Localization.Command.Clearchat localization(FEntity sender) {
        return this.fileResolver.getLocalization(sender).getCommand().getClearchat();
    }

    public void clearChat(FPlayer fPlayer) {
        this.clearChat(fPlayer, true);
    }

    public void clearChat(FPlayer fPlayer, boolean checkProxy) {
        if (checkProxy && !this.platformPlayerAdapter.isOnline(fPlayer) && this.proxySender.send(fPlayer, MessageType.COMMAND_CLEARCHAT)) {
            return;
        }
        this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format("<br> ".repeat(100))).destination(this.config().getDestination())).build());
        this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Clearchat::getFormat)).destination(this.config().getDestination())).sound(this.getModuleSound())).build());
    }

    @Inject
    @Generated
    public ClearchatModule(FileResolver fileResolver, FPlayerService fPlayerService, PermissionChecker permissionChecker, CommandParserProvider commandParserProvider, ProxySender proxySender, PlatformPlayerAdapter platformPlayerAdapter) {
        this.fileResolver = fileResolver;
        this.fPlayerService = fPlayerService;
        this.permissionChecker = permissionChecker;
        this.commandParserProvider = commandParserProvider;
        this.proxySender = proxySender;
        this.platformPlayerAdapter = platformPlayerAdapter;
    }
}

