/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.coin;

import java.util.function.Function;
import lombok.Generated;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.cloud.cloud.context.CommandContext;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleCommand;
import net.flectone.pulse.module.command.coin.model.CoinMetadata;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.RandomUtil;
import net.flectone.pulse.util.constant.MessageType;

@Singleton
public class CoinModule
extends AbstractModuleCommand<Localization.Command.Coin> {
    private final FileResolver fileResolver;
    private final RandomUtil randomUtil;

    @Override
    public void onEnable() {
        super.onEnable();
        this.registerCommand(commandBuilder -> commandBuilder.permission(this.permission().getName()));
    }

    @Override
    public void execute(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        if (this.isModuleDisabledFor(fPlayer, true)) {
            return;
        }
        int percent = this.randomUtil.nextInt(this.config().isDraw() ? 0 : 1, 101);
        this.sendMessage(((CoinMetadata.CoinMetadataBuilder)((CoinMetadata.CoinMetadataBuilder)((CoinMetadata.CoinMetadataBuilder)((CoinMetadata.CoinMetadataBuilder)((CoinMetadata.CoinMetadataBuilder)((EventMetadata.EventMetadataBuilder)((CoinMetadata.CoinMetadataBuilder)((CoinMetadata.CoinMetadataBuilder)CoinMetadata.builder().sender(fPlayer)).format(this.replaceResult(percent))).percent(percent)).range(this.config().getRange())).destination(this.config().getDestination())).sound(this.getModuleSound())).proxy(output -> output.writeInt(percent))).integration(string -> Strings.CS.replace(string, "<result>", percent == 0 ? "" : (percent > 50 ? ((Localization.Command.Coin)this.localization()).getHead() : ((Localization.Command.Coin)this.localization()).getTail())))).build());
    }

    @Override
    public MessageType messageType() {
        return MessageType.COMMAND_COIN;
    }

    @Override
    public Command.Coin config() {
        return this.fileResolver.getCommand().getCoin();
    }

    @Override
    public Permission.Command.Coin permission() {
        return this.fileResolver.getPermission().getCommand().getCoin();
    }

    @Override
    public Localization.Command.Coin localization(FEntity sender) {
        return this.fileResolver.getLocalization(sender).getCommand().getCoin();
    }

    public Function<Localization.Command.Coin, String> replaceResult(int percent) {
        return message -> percent != 0 ? Strings.CS.replace(message.getFormat(), "<result>", percent > 50 ? message.getHead() : message.getTail()) : message.getFormatDraw();
    }

    @Inject
    @Generated
    public CoinModule(FileResolver fileResolver, RandomUtil randomUtil) {
        this.fileResolver = fileResolver;
        this.randomUtil = randomUtil;
    }
}

