/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.mutelist;

import java.util.List;
import java.util.Optional;
import lombok.Generated;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.execution.dispatcher.EventDispatcher;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.library.adventure.text.Component;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.cloud.cloud.context.CommandContext;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.model.event.message.MessageSendEvent;
import net.flectone.pulse.model.util.Moderation;
import net.flectone.pulse.module.AbstractModuleCommand;
import net.flectone.pulse.module.command.unmute.UnmuteModule;
import net.flectone.pulse.platform.formatter.ModerationMessageFormatter;
import net.flectone.pulse.platform.provider.CommandParserProvider;
import net.flectone.pulse.platform.sender.SoundPlayer;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.service.ModerationService;
import net.flectone.pulse.util.constant.MessageType;

@Singleton
public class MutelistModule
extends AbstractModuleCommand<Localization.Command.Mutelist> {
    private final FileResolver fileResolver;
    private final FPlayerService fPlayerService;
    private final ModerationService moderationService;
    private final ModerationMessageFormatter moderationMessageFormatter;
    private final UnmuteModule unmuteModule;
    private final MessagePipeline messagePipeline;
    private final CommandParserProvider commandParserProvider;
    private final EventDispatcher eventDispatcher;
    private final SoundPlayer soundPlayer;

    @Override
    public void onEnable() {
        super.onEnable();
        String promptPlayer = this.addPrompt(0, Localization.Command.Prompt::getPlayer);
        String promptNumber = this.addPrompt(1, Localization.Command.Prompt::getNumber);
        this.registerCommand(commandBuilder -> commandBuilder.permission(this.permission().getName()).optional(promptPlayer, this.commandParserProvider.mutedParser()).optional(promptNumber, this.commandParserProvider.integerParser()));
    }

    @Override
    public void execute(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        int perPage;
        List<Moderation> moderationList;
        if (this.isModuleDisabledFor(fPlayer, true)) {
            return;
        }
        Localization.Command.Mutelist localization = this.localization(fPlayer);
        Localization.ListTypeMessage localizationType = localization.getGlobal();
        String commandLine = "/" + this.getCommandName();
        FPlayer targetFPlayer = null;
        int page = 1;
        String promptPlayer = this.getPrompt(0);
        Optional optionalPlayer = commandContext.optional(promptPlayer);
        if (optionalPlayer.isPresent()) {
            String playerName = (String)optionalPlayer.get();
            if (StringUtils.isNumeric((CharSequence)playerName)) {
                page = Integer.parseInt(playerName);
            } else {
                String promptNumber = this.getPrompt(1);
                Optional optionalNumber = commandContext.optional(promptNumber);
                page = optionalNumber.orElse(page);
                targetFPlayer = this.fPlayerService.getFPlayer(playerName);
                if (targetFPlayer.isUnknown()) {
                    this.sendErrorMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Mutelist::getNullPlayer)).build());
                    return;
                }
                commandLine = commandLine + " " + playerName;
                localizationType = localization.getPlayer();
            }
        }
        List<Moderation> list = moderationList = targetFPlayer == null ? this.moderationService.getValidMutes() : this.moderationService.getValidMutes(targetFPlayer);
        if (moderationList.isEmpty()) {
            this.sendErrorMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Mutelist::getEmpty)).build());
            return;
        }
        int size = moderationList.size();
        int countPage = (int)Math.ceil((double)size / (double)(perPage = this.config().getPerPage()));
        if (page > countPage || page < 1) {
            this.sendErrorMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Mutelist::getNullPage)).build());
            return;
        }
        List finalModerationList = moderationList.stream().skip((long)(page - 1) * (long)perPage).limit(perPage).toList();
        String header = Strings.CS.replace(localizationType.getHeader(), "<count>", String.valueOf(size));
        Component component = this.messagePipeline.builder(fPlayer, header).build().append((Component)Component.newline());
        for (Moderation moderation : finalModerationList) {
            FPlayer fTarget = this.fPlayerService.getFPlayer(moderation.getPlayer());
            String line = Strings.CS.replace(localizationType.getLine(), "<command>", "/" + this.unmuteModule.getCommandName() + " <player> <id>");
            line = this.moderationMessageFormatter.replacePlaceholders(line, fPlayer, moderation);
            component = component.append(this.messagePipeline.builder(fTarget, fPlayer, line).build()).append((Component)Component.newline());
        }
        String footer = StringUtils.replaceEach((String)localizationType.getFooter(), (String[])new String[]{"<command>", "<prev_page>", "<next_page>", "<current_page>", "<last_page>"}, (String[])new String[]{commandLine, String.valueOf(page - 1), String.valueOf(page + 1), String.valueOf(page), String.valueOf(countPage)});
        component = component.append(this.messagePipeline.builder(fPlayer, footer).build());
        this.eventDispatcher.dispatch(new MessageSendEvent(MessageType.COMMAND_MUTELIST, fPlayer, component));
        this.soundPlayer.play(this.getModuleSound(), fPlayer);
    }

    @Override
    public MessageType messageType() {
        return MessageType.COMMAND_MUTELIST;
    }

    @Override
    public Command.Mutelist config() {
        return this.fileResolver.getCommand().getMutelist();
    }

    @Override
    public Permission.Command.Mutelist permission() {
        return this.fileResolver.getPermission().getCommand().getMutelist();
    }

    @Override
    public Localization.Command.Mutelist localization(FEntity sender) {
        return this.fileResolver.getLocalization(sender).getCommand().getMutelist();
    }

    @Inject
    @Generated
    public MutelistModule(FileResolver fileResolver, FPlayerService fPlayerService, ModerationService moderationService, ModerationMessageFormatter moderationMessageFormatter, UnmuteModule unmuteModule, MessagePipeline messagePipeline, CommandParserProvider commandParserProvider, EventDispatcher eventDispatcher, SoundPlayer soundPlayer) {
        this.fileResolver = fileResolver;
        this.fPlayerService = fPlayerService;
        this.moderationService = moderationService;
        this.moderationMessageFormatter = moderationMessageFormatter;
        this.unmuteModule = unmuteModule;
        this.messagePipeline = messagePipeline;
        this.commandParserProvider = commandParserProvider;
        this.eventDispatcher = eventDispatcher;
        this.soundPlayer = soundPlayer;
    }
}

