/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.poll;

import bukkit-downgraded.xyz.wagyourtail.jvmdg.j21.stub.java_base.J_L_MatchException;
import java.io.IOException;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.execution.scheduler.TaskScheduler;
import net.flectone.pulse.library.adventure.text.Component;
import net.flectone.pulse.library.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.cloud.cloud.context.CommandContext;
import net.flectone.pulse.library.cloud.cloud.meta.CommandMeta;
import net.flectone.pulse.library.cloud.cloud.suggestion.BlockingSuggestionProvider;
import net.flectone.pulse.library.cloud.cloud.suggestion.Suggestion;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Provider;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.packetevents.manager.server.ServerVersion;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.model.util.Range;
import net.flectone.pulse.module.AbstractModuleCommand;
import net.flectone.pulse.module.command.poll.builder.DialogPollBuilder;
import net.flectone.pulse.module.command.poll.model.Poll;
import net.flectone.pulse.module.command.poll.model.PollMetadata;
import net.flectone.pulse.platform.provider.CommandParserProvider;
import net.flectone.pulse.platform.provider.PacketProvider;
import net.flectone.pulse.platform.sender.ProxySender;
import net.flectone.pulse.processing.processor.YamlFileProcessor;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.SafeDataOutputStream;
import net.flectone.pulse.util.constant.MessageType;
import net.flectone.pulse.util.logging.FLogger;

@Singleton
public class PollModule
extends AbstractModuleCommand<Localization.Command.Poll> {
    private final HashMap<Integer, Poll> pollMap = new HashMap();
    private final FileResolver fileResolver;
    private final FPlayerService fPlayerService;
    private final ProxySender proxySender;
    private final TaskScheduler taskScheduler;
    private final CommandParserProvider commandParserProvider;
    private final MessagePipeline messagePipeline;
    private final PacketProvider packetProvider;
    private final Provider<DialogPollBuilder> dialogPollBuilderProvider;
    private final YamlFileProcessor yamlFileProcessor;
    private final FLogger fLogger;

    @Override
    public void onEnable() {
        super.onEnable();
        this.registerPermission(this.permission().getCreate());
        String promptTime = this.addPrompt(0, Localization.Command.Prompt::getTime);
        String promptRepeatTime = this.addPrompt(1, Localization.Command.Prompt::getRepeatTime);
        String promptMultipleVote = this.addPrompt(2, Localization.Command.Prompt::getMultipleVote);
        String promptMessage = this.addPrompt(3, Localization.Command.Prompt::getMessage);
        this.registerCommand(manager -> manager.permission(this.permission().getCreate().getName()).required(promptTime, this.commandParserProvider.durationParser()).required(promptRepeatTime, this.commandParserProvider.durationParser()).required(promptMultipleVote, this.commandParserProvider.booleanParser()).required(promptMessage, this.commandParserProvider.messageParser(), this.mapSuggestion()));
        if (this.config().isEnableGui() && this.packetProvider.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_6)) {
            this.registerCustomCommand(manager -> manager.commandBuilder(this.getCommandName() + "gui", CommandMeta.empty(), new String[0]).permission(this.permission().getCreate().getName()).handler(commandContext -> ((DialogPollBuilder)this.dialogPollBuilderProvider.get()).openDialog((FPlayer)commandContext.sender())));
        }
        String promptId = this.addPrompt(4, Localization.Command.Prompt::getId);
        String promptNumber = this.addPrompt(5, Localization.Command.Prompt::getNumber);
        this.registerCustomCommand(manager -> manager.commandBuilder(this.getCommandName() + "vote", CommandMeta.empty(), new String[0]).permission(this.permission().getName()).required(promptId, this.commandParserProvider.integerParser()).required(promptNumber, this.commandParserProvider.integerParser()).handler(commandContext -> this.executeVote((FPlayer)commandContext.sender(), (CommandContext<FPlayer>)commandContext)));
        this.taskScheduler.runAsyncTimer(() -> {
            HashSet toRemove = new HashSet();
            this.pollMap.forEach((id, poll) -> {
                Status status = null;
                if (poll.isEnded()) {
                    toRemove.add(id);
                    status = Status.END;
                } else if (poll.repeat()) {
                    status = Status.RUN;
                }
                if (status == null) {
                    return;
                }
                FPlayer fPlayer = this.fPlayerService.getFPlayer(poll.getCreator());
                Range range = this.config().getRange();
                this.sendMessage(((PollMetadata.PollMetadataBuilder)((PollMetadata.PollMetadataBuilder)((EventMetadata.EventMetadataBuilder)((PollMetadata.PollMetadataBuilder)((PollMetadata.PollMetadataBuilder)((PollMetadata.PollMetadataBuilder)((PollMetadata.PollMetadataBuilder)PollMetadata.builder().sender(fPlayer)).format(this.resolvePollFormat(fPlayer, (Poll)poll, status))).poll((Poll)poll)).status(status)).action(Action.REPEAT)).range(range)).message(poll.getTitle())).build());
            });
            toRemove.forEach(this.pollMap::remove);
        }, 20L);
    }

    @Override
    public void onDisable() {
        super.onDisable();
        this.pollMap.clear();
    }

    @NonNull
    private BlockingSuggestionProvider<FPlayer> mapSuggestion() {
        return (context, input) -> {
            String[] words = input.input().split(" ");
            if (words.length < 5) {
                return List.of(Suggestion.suggestion((String)"title="));
            }
            String string = String.join((CharSequence)" ", Arrays.copyOfRange(words, 4, words.length));
            if (!string.contains("title=")) {
                return List.of(Suggestion.suggestion((String)"title="), Suggestion.suggestion((String)(string + ";")));
            }
            return List.of(Suggestion.suggestion((String)(string + ";")));
        };
    }

    public void executeVote(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        UUID metadataUUID;
        int numberVote;
        if (this.isModuleDisabledFor(fPlayer, true)) {
            return;
        }
        int id = (Integer)this.getArgument(commandContext, 4);
        boolean isSent = this.proxySender.send(fPlayer, MessageType.COMMAND_POLL, arg_0 -> PollModule.lambda$executeVote$8(id, numberVote = ((Integer)this.getArgument(commandContext, 5)).intValue(), arg_0), metadataUUID = UUID.randomUUID());
        if (isSent) {
            return;
        }
        this.vote(fPlayer, id, numberVote, metadataUUID);
    }

    @Override
    public void execute(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        if (this.isModuleDisabledFor(fPlayer, true)) {
            return;
        }
        String promptTime = this.getPrompt(0);
        long time = ((Duration)commandContext.get(promptTime)).toMillis();
        String promptRepeatTime = this.getPrompt(1);
        long repeatTime = ((Duration)commandContext.get(promptRepeatTime)).toMillis();
        String promptMultipleVote = this.getPrompt(2);
        boolean multipleVote = (Boolean)commandContext.get(promptMultipleVote);
        String promptMessage = this.getPrompt(3);
        String rawPoll = (String)commandContext.get(promptMessage);
        boolean hasTitle = rawPoll.startsWith("title=");
        if (hasTitle) {
            rawPoll = rawPoll.substring(6);
        }
        String[] parts = rawPoll.split(";");
        String title = hasTitle && parts.length > 0 ? parts[0] : "";
        int firstAnswerIndex = hasTitle ? 1 : 0;
        List<String> answers = parts.length > firstAnswerIndex ? List.of(Arrays.copyOfRange(parts, firstAnswerIndex, parts.length)) : List.of();
        this.createPoll(fPlayer, title, multipleVote, time, repeatTime, answers);
    }

    @Override
    public MessageType messageType() {
        return MessageType.COMMAND_POLL;
    }

    @Override
    public Command.Poll config() {
        return this.fileResolver.getCommand().getPoll();
    }

    @Override
    public Permission.Command.Poll permission() {
        return this.fileResolver.getPermission().getCommand().getPoll();
    }

    @Override
    public Localization.Command.Poll localization(FEntity sender) {
        return this.fileResolver.getLocalization(sender).getCommand().getPoll();
    }

    public void createPoll(FPlayer fPlayer, String title, boolean multipleValue, long endTimeValue, long repeatTimeValue, List<String> answers) {
        Poll poll = new Poll(this.config().getLastId(), fPlayer.getId(), endTimeValue + System.currentTimeMillis(), repeatTimeValue, multipleValue, title, answers);
        this.saveAndUpdateLast(poll);
        Range range = this.config().getRange();
        this.sendMessage(((PollMetadata.PollMetadataBuilder)((PollMetadata.PollMetadataBuilder)((PollMetadata.PollMetadataBuilder)((PollMetadata.PollMetadataBuilder)((PollMetadata.PollMetadataBuilder)((EventMetadata.EventMetadataBuilder)((PollMetadata.PollMetadataBuilder)((PollMetadata.PollMetadataBuilder)((PollMetadata.PollMetadataBuilder)((PollMetadata.PollMetadataBuilder)PollMetadata.builder().sender(fPlayer)).format(this.resolvePollFormat(fPlayer, poll, Status.START))).poll(poll)).status(Status.START)).action(Action.CREATE)).range(range)).message(poll.getTitle())).sound(this.getModuleSound())).proxy(dataOutputStream -> {
            dataOutputStream.writeUTF(Action.CREATE.name());
            dataOutputStream.writeAsJson(poll);
        })).integration()).build());
    }

    public void saveAndUpdateLast(Poll poll) {
        this.pollMap.put(poll.getId(), poll);
        this.config().setLastId(poll.getId() + 1);
        try {
            this.yamlFileProcessor.save(this.fileResolver.getCommand());
        }
        catch (IOException e) {
            this.fLogger.warning(e);
        }
    }

    public void vote(FEntity fPlayer, int id, int numberVote, UUID metadataUUID) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        Poll poll = this.pollMap.get(id);
        if (poll == null) {
            this.sendErrorMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Poll::getNullPoll)).build());
            return;
        }
        if (poll.isEnded()) {
            this.sendErrorMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Poll::getExpired)).build());
            return;
        }
        int voteType = poll.vote(fPlayer, numberVote);
        if (voteType == -1) {
            this.sendErrorMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Poll::getAlready)).build());
            return;
        }
        int count = poll.getCountAnswers()[numberVote];
        int pollID = poll.getId();
        this.sendMessage(((PollMetadata.PollMetadataBuilder)((PollMetadata.PollMetadataBuilder)((PollMetadata.PollMetadataBuilder)((PollMetadata.PollMetadataBuilder)((PollMetadata.PollMetadataBuilder)((PollMetadata.PollMetadataBuilder)PollMetadata.builder().uuid(metadataUUID)).sender(fPlayer)).format(this.resolveVote(voteType, numberVote, pollID, count))).poll(poll)).status(Status.RUN)).action(Action.VOTE)).build());
    }

    public Function<Localization.Command.Poll, String> resolveVote(int voteType, int answerID, int pollID, int count) {
        return message -> StringUtils.replaceEach((String)(voteType == 1 ? message.getVoteTrue() : message.getVoteFalse()), (String[])new String[]{"<answer_id>", "<id>", "<count>"}, (String[])new String[]{String.valueOf(answerID + 1), String.valueOf(pollID), String.valueOf(count)});
    }

    public Function<Localization.Command.Poll, String> resolvePollFormat(FEntity fPlayer, Poll poll, Status status) {
        return message -> {
            StringBuilder answersBuilder = new StringBuilder();
            int k = 0;
            for (String answer : poll.getAnswers()) {
                Component answerComponent = this.messagePipeline.builder(fPlayer, FPlayer.UNKNOWN, answer).build();
                answersBuilder.append(StringUtils.replaceEach((String)message.getAnswerTemplate(), (String[])new String[]{"<id>", "<number>", "<answer>", "<count>"}, (String[])new String[]{String.valueOf(poll.getId()), String.valueOf(k), PlainTextComponentSerializer.plainText().serialize(answerComponent), String.valueOf(poll.getCountAnswers()[k])}));
                ++k;
            }
            String messageStatus = Strings.CS.replace(switch (status.ordinal()) {
                default -> throw new J_L_MatchException(null, null);
                case 0 -> message.getStatus().getStart();
                case 1 -> message.getStatus().getRun();
                case 2 -> message.getStatus().getEnd();
            }, "<id>", String.valueOf(poll.getId()));
            return StringUtils.replaceEach((String)message.getFormat(), (String[])new String[]{"<status>", "<answers>"}, (String[])new String[]{messageStatus, answersBuilder.toString()});
        };
    }

    @Inject
    @Generated
    public PollModule(FileResolver fileResolver, FPlayerService fPlayerService, ProxySender proxySender, TaskScheduler taskScheduler, CommandParserProvider commandParserProvider, MessagePipeline messagePipeline, PacketProvider packetProvider, Provider<DialogPollBuilder> dialogPollBuilderProvider, YamlFileProcessor yamlFileProcessor, FLogger fLogger) {
        this.fileResolver = fileResolver;
        this.fPlayerService = fPlayerService;
        this.proxySender = proxySender;
        this.taskScheduler = taskScheduler;
        this.commandParserProvider = commandParserProvider;
        this.messagePipeline = messagePipeline;
        this.packetProvider = packetProvider;
        this.dialogPollBuilderProvider = dialogPollBuilderProvider;
        this.yamlFileProcessor = yamlFileProcessor;
        this.fLogger = fLogger;
    }

    private static /* synthetic */ void lambda$executeVote$8(int id, int numberVote, SafeDataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeUTF(Action.VOTE.name());
        dataOutputStream.writeInt(id);
        dataOutputStream.writeInt(numberVote);
    }

    public static enum Status {
        START,
        RUN,
        END;

    }

    public static enum Action {
        CREATE,
        REPEAT,
        VOTE;

    }
}

