/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.poll.builder;

import bukkit-downgraded.xyz.wagyourtail.jvmdg.j21.stub.java_base.J_U_List;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.library.adventure.text.Component;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.packetevents.protocol.dialog.CommonDialogData;
import net.flectone.pulse.library.packetevents.protocol.dialog.DialogAction;
import net.flectone.pulse.library.packetevents.protocol.dialog.action.Action;
import net.flectone.pulse.library.packetevents.protocol.dialog.action.DynamicCustomAction;
import net.flectone.pulse.library.packetevents.protocol.dialog.body.PlainMessage;
import net.flectone.pulse.library.packetevents.protocol.dialog.body.PlainMessageDialogBody;
import net.flectone.pulse.library.packetevents.protocol.dialog.button.ActionButton;
import net.flectone.pulse.library.packetevents.protocol.dialog.button.CommonButtonData;
import net.flectone.pulse.library.packetevents.protocol.dialog.input.BooleanInputControl;
import net.flectone.pulse.library.packetevents.protocol.dialog.input.Input;
import net.flectone.pulse.library.packetevents.protocol.dialog.input.InputControl;
import net.flectone.pulse.library.packetevents.protocol.dialog.input.NumberRangeInputControl;
import net.flectone.pulse.library.packetevents.protocol.dialog.input.TextInputControl;
import net.flectone.pulse.library.packetevents.protocol.nbt.NBTCompound;
import net.flectone.pulse.library.packetevents.resources.ResourceLocation;
import net.flectone.pulse.model.dialog.Dialog;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.command.poll.PollModule;
import net.flectone.pulse.module.command.poll.model.NBTPoll;
import net.flectone.pulse.platform.controller.DialogController;

@Singleton
public class DialogPollBuilder {
    private static final String INPUT_KEY = "fp_input";
    private static final String MULTIPLE_KEY = "fp_multiple";
    private static final String END_TIME_KEY = "fp_end_time";
    private static final String REPEAT_TIME_KEY = "fp_repeat_time";
    private static final String ANSWER_KEY = "fp_answer_";
    private final PollModule pollModule;
    private final MessagePipeline messagePipeline;
    private final DialogController dialogController;

    public void openDialog(FPlayer fPlayer) {
        Localization.Command.Poll.Modern poll = this.pollModule.localization(fPlayer).getModern();
        this.openDialog(fPlayer, poll.getInputInitial(), false, 5.0f, 1.0f, Collections.emptyList());
    }

    public void openDialog(FPlayer fPlayer, String inputValue, boolean multipleValue, float endTimeValue, float repeatTimeValue, List<String> answers) {
        Localization.Command.Poll.Modern poll = this.pollModule.localization(fPlayer).getModern();
        Component headerName = this.messagePipeline.builder(fPlayer, poll.getHeader()).build();
        PlainMessageDialogBody dialogBody = new PlainMessageDialogBody(new PlainMessage((Component)Component.empty(), 10));
        Input input = new Input(INPUT_KEY, (InputControl)new TextInputControl(200, this.messagePipeline.builder(fPlayer, poll.getInputName()).build(), true, inputValue, 256, null));
        Input multiple = new Input(MULTIPLE_KEY, (InputControl)new BooleanInputControl(this.messagePipeline.builder(fPlayer, poll.getMultipleName()).build(), multipleValue, "true", "false"));
        Input endTime = new Input(END_TIME_KEY, (InputControl)new NumberRangeInputControl(200, this.messagePipeline.builder(fPlayer, poll.getEndTimeName()).build(), "options.generic_value", new NumberRangeInputControl.RangeInfo(1.0f, 600.0f, Float.valueOf(endTimeValue), Float.valueOf(1.0f))));
        Input repeatTime = new Input(REPEAT_TIME_KEY, (InputControl)new NumberRangeInputControl(200, this.messagePipeline.builder(fPlayer, poll.getRepeatTimeName()).build(), "options.generic_value", new NumberRangeInputControl.RangeInfo(1.0f, 600.0f, Float.valueOf(repeatTimeValue), Float.valueOf(1.0f))));
        ArrayList<Input> inputs = new ArrayList<Input>(List.of(input, multiple, endTime, repeatTime));
        for (int i = 0; i < answers.size(); ++i) {
            String inputAnswerName = Strings.CS.replace(poll.getInputAnswerName(), "<number>", String.valueOf(i + 1));
            Input inputAnswer = new Input(ANSWER_KEY + i, (InputControl)new TextInputControl(200, this.messagePipeline.builder(fPlayer, inputAnswerName).build(), true, answers.get(i), 1024, new TextInputControl.MultilineOptions(Integer.valueOf(5), Integer.valueOf(40))));
            inputs.add(inputAnswer);
        }
        CommonDialogData commonDialogData = new CommonDialogData(headerName, null, true, false, DialogAction.CLOSE, List.of(dialogBody), inputs);
        Dialog.Builder dialogBuilder = new Dialog.Builder(commonDialogData, 2);
        dialogBuilder = this.addNewAnswerButton(fPlayer, dialogBuilder);
        dialogBuilder = this.addRemoveAnswerButton(fPlayer, dialogBuilder);
        dialogBuilder = this.addCreateButton(fPlayer, dialogBuilder);
        this.dialogController.open(fPlayer, dialogBuilder.build(), false);
    }

    private Dialog.Builder addNewAnswerButton(FPlayer fPlayer, Dialog.Builder builder) {
        Localization.Command.Poll.Modern poll = this.pollModule.localization(fPlayer).getModern();
        String newAnswerButtonId = "fp_new_answer";
        ActionButton button = new ActionButton(new CommonButtonData(this.messagePipeline.builder(fPlayer, poll.getNewAnswerButtonName()).build(), (Component)Component.empty(), 200), (Action)new DynamicCustomAction(ResourceLocation.minecraft((String)newAnswerButtonId), null));
        return builder.addButton(0, button).addClickHandler(newAnswerButtonId, (dialog, nbt) -> {
            if (nbt instanceof NBTCompound) {
                NBTCompound nbtCompound = (NBTCompound)nbt;
                NBTPoll nbtPoll = this.readPoll(fPlayer, nbtCompound);
                ArrayList<String> answers = new ArrayList<String>(nbtPoll.answers());
                if (answers.size() < 10) {
                    answers.add(poll.getInputAnswersInitial());
                }
                this.openDialog(fPlayer, nbtPoll.input(), nbtPoll.multiple(), nbtPoll.endTime(), nbtPoll.repeatTime(), answers);
            }
        });
    }

    private Dialog.Builder addRemoveAnswerButton(FPlayer fPlayer, Dialog.Builder builder) {
        Localization.Command.Poll.Modern poll = this.pollModule.localization(fPlayer).getModern();
        String newAnswerButtonId = "fp_remove_answer";
        ActionButton button = new ActionButton(new CommonButtonData(this.messagePipeline.builder(fPlayer, poll.getRemoveAnswerButtonName()).build(), (Component)Component.empty(), 200), (Action)new DynamicCustomAction(ResourceLocation.minecraft((String)newAnswerButtonId), null));
        return builder.addButton(1, button).addClickHandler(newAnswerButtonId, (dialog, nbt) -> {
            if (nbt instanceof NBTCompound) {
                NBTCompound nbtCompound = (NBTCompound)nbt;
                NBTPoll nbtPoll = this.readPoll(fPlayer, nbtCompound);
                ArrayList<String> answers = new ArrayList<String>(nbtPoll.answers());
                if (!answers.isEmpty()) {
                    J_U_List.removeLast(answers);
                }
                this.openDialog(fPlayer, nbtPoll.input(), nbtPoll.multiple(), nbtPoll.endTime(), nbtPoll.repeatTime(), answers);
            }
        });
    }

    private Dialog.Builder addCreateButton(FPlayer fPlayer, Dialog.Builder builder) {
        String createId = "fp_create";
        ActionButton button = new ActionButton(new CommonButtonData(this.messagePipeline.builder(fPlayer, this.pollModule.localization(fPlayer).getModern().getCreateButtonName()).build(), (Component)Component.empty(), 200), (Action)new DynamicCustomAction(ResourceLocation.minecraft((String)createId), null));
        return builder.addButton(2, button).addClickHandler(createId, (dialog, nbt) -> {
            if (nbt instanceof NBTCompound) {
                NBTCompound nbtCompound = (NBTCompound)nbt;
                NBTPoll nbtPoll = this.readPoll(fPlayer, nbtCompound);
                this.pollModule.createPoll(fPlayer, nbtPoll.input(), nbtPoll.multiple(), (long)(nbtPoll.endTime() * 60.0f * 1000.0f), (long)(nbtPoll.repeatTime() * 60.0f * 1000.0f), nbtPoll.answers());
            }
        });
    }

    private NBTPoll readPoll(FPlayer fPlayer, NBTCompound nbtCompound) {
        String answerValue;
        String inputName = nbtCompound.getStringTagValueOrDefault(INPUT_KEY, this.pollModule.localization(fPlayer).getModern().getInputInitial());
        boolean multiple = nbtCompound.getBooleanOr(MULTIPLE_KEY, false);
        float endTime = ((Float)nbtCompound.getNumberTagValueOrDefault(END_TIME_KEY, (Number)Float.valueOf(5.0f))).floatValue();
        float repeatTime = ((Float)nbtCompound.getNumberTagValueOrDefault(REPEAT_TIME_KEY, (Number)Float.valueOf(1.0f))).floatValue();
        ArrayList<String> answers = new ArrayList<String>();
        for (int i = 0; i < 10 && (answerValue = nbtCompound.getStringTagValueOrNull(ANSWER_KEY + i)) != null; ++i) {
            answers.add(answerValue);
        }
        return new NBTPoll(inputName, multiple, endTime, repeatTime, Collections.unmodifiableList(answers));
    }

    @Inject
    @Generated
    public DialogPollBuilder(PollModule pollModule, MessagePipeline messagePipeline, DialogController dialogController) {
        this.pollModule = pollModule;
        this.messagePipeline = messagePipeline;
        this.dialogController = dialogController;
    }
}

