/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.poll.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import net.flectone.pulse.model.entity.FEntity;

public class Poll {
    private final int id;
    private final int creator;
    private final long endTime;
    private final long repeatTime;
    private final boolean multipleVote;
    private final String title;
    private final List<String> answers = new ArrayList<String>();
    private final Map<UUID, boolean[]> votesMap = new HashMap<UUID, boolean[]>();
    private long nextRepeat;

    public Poll(int id, int creator, long endTime, long repeatTime, boolean multipleVote, String title, List<String> answers) {
        this.id = id;
        this.creator = creator;
        this.endTime = endTime;
        this.repeatTime = repeatTime;
        this.nextRepeat = System.currentTimeMillis() + repeatTime;
        this.multipleVote = multipleVote;
        this.title = title;
        this.answers.addAll(answers);
    }

    public int vote(FEntity fPlayer, int numberVote) {
        boolean[] votes = this.votesMap.getOrDefault(fPlayer.getUuid(), new boolean[this.answers.size()]);
        for (int x = 0; x < this.answers.size(); ++x) {
            if (!votes[x] || this.multipleVote) continue;
            return -1;
        }
        votes[numberVote] = !votes[numberVote];
        this.votesMap.put(fPlayer.getUuid(), votes);
        return votes[numberVote] ? 1 : 0;
    }

    public int[] getCountAnswers() {
        int[] countAnswers = new int[this.answers.size()];
        for (boolean[] answers : this.votesMap.values()) {
            for (int x = 0; x < answers.length; ++x) {
                if (!answers[x]) continue;
                int n = x;
                countAnswers[n] = countAnswers[n] + 1;
            }
        }
        return countAnswers;
    }

    public boolean isEnded() {
        return System.currentTimeMillis() >= this.endTime;
    }

    public boolean repeat() {
        if (System.currentTimeMillis() < this.nextRepeat) {
            return false;
        }
        this.nextRepeat = System.currentTimeMillis() + this.repeatTime;
        return true;
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public int getCreator() {
        return this.creator;
    }

    @Generated
    public long getEndTime() {
        return this.endTime;
    }

    @Generated
    public long getRepeatTime() {
        return this.repeatTime;
    }

    @Generated
    public boolean isMultipleVote() {
        return this.multipleVote;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public List<String> getAnswers() {
        return this.answers;
    }

    @Generated
    public Map<UUID, boolean[]> getVotesMap() {
        return this.votesMap;
    }

    @Generated
    public long getNextRepeat() {
        return this.nextRepeat;
    }
}

