/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.rockpaperscissors;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import lombok.Generated;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.library.adventure.text.minimessage.tag.resolver.TagResolver;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.cloud.cloud.context.CommandContext;
import net.flectone.pulse.library.cloud.cloud.parser.standard.UUIDParser;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleCommand;
import net.flectone.pulse.module.command.rockpaperscissors.model.RockPaperScissors;
import net.flectone.pulse.module.command.rockpaperscissors.model.RockPaperScissorsMetadata;
import net.flectone.pulse.module.integration.IntegrationModule;
import net.flectone.pulse.platform.provider.CommandParserProvider;
import net.flectone.pulse.platform.sender.DisableSender;
import net.flectone.pulse.platform.sender.IgnoreSender;
import net.flectone.pulse.platform.sender.ProxySender;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.constant.MessageType;

@Singleton
public class RockpaperscissorsModule
extends AbstractModuleCommand<Localization.Command.Rockpaperscissors> {
    private final Map<UUID, RockPaperScissors> gameMap = new HashMap<UUID, RockPaperScissors>();
    private final FileResolver fileResolver;
    private final ProxySender proxySender;
    private final FPlayerService fPlayerService;
    private final CommandParserProvider commandParserProvider;
    private final IntegrationModule integrationModule;
    private final IgnoreSender ignoreSender;
    private final DisableSender disableSender;

    @Override
    public void onEnable() {
        super.onEnable();
        String promptPlayer = this.addPrompt(0, Localization.Command.Prompt::getPlayer);
        String promptMove = this.addPrompt(1, Localization.Command.Prompt::getMove);
        String promptUUID = this.addPrompt(2, Localization.Command.Prompt::getId);
        this.registerCommand(manager -> manager.permission(this.permission().getName()).required(promptPlayer, this.commandParserProvider.playerParser()).optional(promptMove, this.commandParserProvider.nativeSingleMessageParser()).optional(promptUUID, UUIDParser.uuidParser()));
    }

    @Override
    public void onDisable() {
        super.onDisable();
        this.gameMap.clear();
    }

    @Override
    public void execute(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        if (this.isModuleDisabledFor(fPlayer, true)) {
            return;
        }
        String player = (String)this.getArgument(commandContext, 0);
        FPlayer fReceiver = this.fPlayerService.getFPlayer(player);
        if (!fReceiver.isOnline() || !this.integrationModule.canSeeVanished(fReceiver, fPlayer)) {
            this.sendErrorMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Rockpaperscissors::getNullPlayer)).build());
            return;
        }
        if (fReceiver.equals(fPlayer)) {
            this.sendErrorMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Rockpaperscissors::getMyself)).build());
            return;
        }
        this.fPlayerService.loadIgnoresIfOffline(fReceiver);
        if (this.ignoreSender.sendIfIgnored(fPlayer, fReceiver)) {
            return;
        }
        this.fPlayerService.loadSettingsIfOffline(fReceiver);
        if (this.disableSender.sendIfDisabled(fPlayer, fReceiver, this.messageType())) {
            return;
        }
        String promptMove = this.getPrompt(1);
        Optional optionalMove = commandContext.optional(promptMove);
        String move = optionalMove.orElse(null);
        String promptUUID = this.getPrompt(2);
        Optional optionalUUID = commandContext.optional(promptUUID);
        UUID uuid = optionalUUID.orElse(null);
        if (move != null && uuid != null) {
            this.finalMove(fPlayer, fReceiver, move, uuid);
            return;
        }
        RockPaperScissors rockPaperScissors = new RockPaperScissors(fPlayer.getUuid(), fReceiver.getUuid());
        this.proxySender.send(fPlayer, MessageType.COMMAND_ROCKPAPERSCISSORS, dataOutputStream -> {
            dataOutputStream.writeUTF(GamePhase.CREATE.name());
            dataOutputStream.writeUTF(rockPaperScissors.getId().toString());
            dataOutputStream.writeUTF(rockPaperScissors.getReceiver().toString());
        }, UUID.randomUUID());
        this.create(rockPaperScissors.getId(), fPlayer, fReceiver.getUuid());
        this.sendMessage(((RockPaperScissorsMetadata.RockPaperScissorsMetadataBuilder)((EventMetadata.EventMetadataBuilder)((RockPaperScissorsMetadata.RockPaperScissorsMetadataBuilder)((RockPaperScissorsMetadata.RockPaperScissorsMetadataBuilder)((RockPaperScissorsMetadata.RockPaperScissorsMetadataBuilder)RockPaperScissorsMetadata.builder().sender(fPlayer)).format(s -> StringUtils.replaceEach((String)s.getFormatMove(), (String[])new String[]{"<target>", "<uuid>"}, (String[])new String[]{fReceiver.getName(), rockPaperScissors.getId().toString()}))).rockPaperScissors(rockPaperScissors)).gamePhase(GamePhase.CREATE)).sound(this.getModuleSound())).build());
    }

    @Override
    public MessageType messageType() {
        return MessageType.COMMAND_ROCKPAPERSCISSORS;
    }

    @Override
    public Command.Rockpaperscissors config() {
        return this.fileResolver.getCommand().getRockpaperscissors();
    }

    @Override
    public Permission.Command.Rockpaperscissors permission() {
        return this.fileResolver.getPermission().getCommand().getRockpaperscissors();
    }

    @Override
    public Localization.Command.Rockpaperscissors localization(FEntity sender) {
        return this.fileResolver.getLocalization(sender).getCommand().getRockpaperscissors();
    }

    public void finalMove(FPlayer fPlayer, FPlayer fReceiver, String move, UUID uuid) {
        List<String> strategy = this.config().getStrategies().get(move);
        if (strategy == null) {
            this.sendErrorMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Rockpaperscissors::getWrongMove)).build());
            return;
        }
        RockPaperScissors rockPaperScissors = this.gameMap.get(uuid);
        if (rockPaperScissors == null) {
            this.sendErrorMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Rockpaperscissors::getNullGame)).build());
            return;
        }
        if (rockPaperScissors.getSenderMove() != null) {
            if (rockPaperScissors.getSender().equals(fPlayer.getUuid())) {
                this.sendErrorMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Rockpaperscissors::getAlready)).build());
                return;
            }
            boolean isSent = this.proxySender.send(fPlayer, MessageType.COMMAND_ROCKPAPERSCISSORS, dataOutputStream -> {
                dataOutputStream.writeUTF(GamePhase.END.name());
                dataOutputStream.writeUTF(rockPaperScissors.getId().toString());
                dataOutputStream.writeUTF(move);
            }, UUID.randomUUID());
            if (isSent) {
                return;
            }
            this.end(rockPaperScissors.getId(), fPlayer, move, UUID.randomUUID());
            return;
        }
        this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Rockpaperscissors::getSender)).tagResolvers(fResolver -> new TagResolver[]{this.targetTag((FPlayer)fResolver, fReceiver)})).build());
        boolean isSent = this.proxySender.send(fPlayer, MessageType.COMMAND_ROCKPAPERSCISSORS, dataOutputStream -> {
            dataOutputStream.writeUTF(GamePhase.MOVE.name());
            dataOutputStream.writeUTF(rockPaperScissors.getId().toString());
            dataOutputStream.writeUTF(move);
        }, UUID.randomUUID());
        if (isSent) {
            return;
        }
        this.move(rockPaperScissors.getId(), fPlayer, move, UUID.randomUUID());
    }

    public void end(UUID id, FPlayer fPlayer, String move, UUID metadataUUID) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        RockPaperScissors rockPaperScissors = this.gameMap.get(id);
        if (rockPaperScissors == null) {
            return;
        }
        FPlayer fReceiver = this.fPlayerService.getFPlayer(rockPaperScissors.getSender());
        this.gameMap.remove(id);
        String senderMove = rockPaperScissors.getSenderMove();
        boolean isDraw = senderMove.equalsIgnoreCase(move);
        if (isDraw) {
            BiFunction<FPlayer, Localization.Command.Rockpaperscissors, String> message = (p, m) -> Strings.CS.replace(m.getFormatDraw(), "<move>", this.localization((FEntity)p).getStrategies().get(move));
            this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().uuid(metadataUUID)).sender(fPlayer)).format(message)).build());
            this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().uuid(metadataUUID)).sender(fReceiver)).format(message)).build());
            return;
        }
        BiFunction<FPlayer, Localization.Command.Rockpaperscissors, String> message = (p, m) -> StringUtils.replaceEach((String)m.getFormatWin(), (String[])new String[]{"<sender_move>", "<receiver_move>"}, (String[])new String[]{this.localization((FEntity)p).getStrategies().get(senderMove), this.localization((FEntity)p).getStrategies().get(move)});
        FPlayer winFPlayer = this.config().getStrategies().get(move).contains(senderMove) ? fPlayer : fReceiver;
        this.sendMessage(((RockPaperScissorsMetadata.RockPaperScissorsMetadataBuilder)((RockPaperScissorsMetadata.RockPaperScissorsMetadataBuilder)((RockPaperScissorsMetadata.RockPaperScissorsMetadataBuilder)((RockPaperScissorsMetadata.RockPaperScissorsMetadataBuilder)((RockPaperScissorsMetadata.RockPaperScissorsMetadataBuilder)((RockPaperScissorsMetadata.RockPaperScissorsMetadataBuilder)RockPaperScissorsMetadata.builder().uuid(metadataUUID)).sender(winFPlayer)).filterPlayer(fPlayer)).format(message)).rockPaperScissors(rockPaperScissors)).gamePhase(GamePhase.END)).build());
        this.sendMessage(((RockPaperScissorsMetadata.RockPaperScissorsMetadataBuilder)((RockPaperScissorsMetadata.RockPaperScissorsMetadataBuilder)((RockPaperScissorsMetadata.RockPaperScissorsMetadataBuilder)((RockPaperScissorsMetadata.RockPaperScissorsMetadataBuilder)((RockPaperScissorsMetadata.RockPaperScissorsMetadataBuilder)((RockPaperScissorsMetadata.RockPaperScissorsMetadataBuilder)RockPaperScissorsMetadata.builder().uuid(metadataUUID)).sender(winFPlayer)).filterPlayer(fReceiver)).format(message)).rockPaperScissors(rockPaperScissors)).gamePhase(GamePhase.END)).build());
    }

    public void move(UUID id, FEntity fPlayer, String move, UUID metadataUUID) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        RockPaperScissors rockPaperScissors = this.gameMap.get(id);
        if (rockPaperScissors == null) {
            return;
        }
        FPlayer fReceiver = this.fPlayerService.getFPlayer(rockPaperScissors.getReceiver());
        rockPaperScissors.setSenderMove(move);
        this.sendMessage(((RockPaperScissorsMetadata.RockPaperScissorsMetadataBuilder)((RockPaperScissorsMetadata.RockPaperScissorsMetadataBuilder)((RockPaperScissorsMetadata.RockPaperScissorsMetadataBuilder)((RockPaperScissorsMetadata.RockPaperScissorsMetadataBuilder)((RockPaperScissorsMetadata.RockPaperScissorsMetadataBuilder)RockPaperScissorsMetadata.builder().sender(fPlayer)).filterPlayer(fReceiver, false)).format(Localization.Command.Rockpaperscissors::getReceiver)).rockPaperScissors(rockPaperScissors)).gamePhase(GamePhase.MOVE)).build());
        this.sendMessage(((RockPaperScissorsMetadata.RockPaperScissorsMetadataBuilder)((RockPaperScissorsMetadata.RockPaperScissorsMetadataBuilder)((RockPaperScissorsMetadata.RockPaperScissorsMetadataBuilder)((RockPaperScissorsMetadata.RockPaperScissorsMetadataBuilder)((RockPaperScissorsMetadata.RockPaperScissorsMetadataBuilder)((RockPaperScissorsMetadata.RockPaperScissorsMetadataBuilder)RockPaperScissorsMetadata.builder().uuid(metadataUUID)).sender(fPlayer)).filterPlayer(fReceiver, false)).format(s -> StringUtils.replaceEach((String)s.getFormatMove(), (String[])new String[]{"<target>", "<uuid>"}, (String[])new String[]{fPlayer.getName(), rockPaperScissors.getId().toString()}))).rockPaperScissors(rockPaperScissors)).gamePhase(GamePhase.MOVE)).build());
    }

    public void create(UUID id, FEntity fPlayer, UUID receiver) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        RockPaperScissors rockPaperScissors = new RockPaperScissors(id, fPlayer.getUuid(), receiver);
        this.gameMap.put(id, rockPaperScissors);
    }

    @Inject
    @Generated
    public RockpaperscissorsModule(FileResolver fileResolver, ProxySender proxySender, FPlayerService fPlayerService, CommandParserProvider commandParserProvider, IntegrationModule integrationModule, IgnoreSender ignoreSender, DisableSender disableSender) {
        this.fileResolver = fileResolver;
        this.proxySender = proxySender;
        this.fPlayerService = fPlayerService;
        this.commandParserProvider = commandParserProvider;
        this.integrationModule = integrationModule;
        this.ignoreSender = ignoreSender;
        this.disableSender = disableSender;
    }

    public static enum GamePhase {
        CREATE,
        MOVE,
        END;

    }
}

