/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.tell;

import java.util.HashMap;
import java.util.UUID;
import java.util.function.Function;
import lombok.Generated;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.library.adventure.text.minimessage.tag.resolver.TagResolver;
import net.flectone.pulse.library.cloud.cloud.context.CommandContext;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.model.util.Range;
import net.flectone.pulse.module.AbstractModuleCommand;
import net.flectone.pulse.module.integration.IntegrationModule;
import net.flectone.pulse.platform.adapter.PlatformPlayerAdapter;
import net.flectone.pulse.platform.provider.CommandParserProvider;
import net.flectone.pulse.platform.sender.DisableSender;
import net.flectone.pulse.platform.sender.IgnoreSender;
import net.flectone.pulse.platform.sender.ProxySender;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.constant.MessageType;

@Singleton
public class TellModule
extends AbstractModuleCommand<Localization.Command.Tell> {
    private final HashMap<UUID, String> senderReceiverMap = new HashMap();
    private final FileResolver fileResolver;
    private final FPlayerService fPlayerService;
    private final ProxySender proxySender;
    private final IntegrationModule integrationModule;
    private final CommandParserProvider commandParserProvider;
    private final PlatformPlayerAdapter platformPlayerAdapter;
    private final IgnoreSender ignoreSender;
    private final DisableSender disableSender;

    @Override
    public void onEnable() {
        super.onEnable();
        String promptPlayer = this.addPrompt(0, Localization.Command.Prompt::getPlayer);
        String promptMessage = this.addPrompt(1, Localization.Command.Prompt::getMessage);
        this.registerCommand(manager -> manager.required(promptPlayer, this.commandParserProvider.playerParser(this.config().isSuggestOfflinePlayers())).required(promptMessage, this.commandParserProvider.nativeMessageParser()).permission(this.permission().getName()));
    }

    @Override
    public void onDisable() {
        super.onDisable();
        this.senderReceiverMap.clear();
    }

    @Override
    public void execute(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        String playerName = (String)this.getArgument(commandContext, 0);
        String message = (String)this.getArgument(commandContext, 1);
        this.send(fPlayer, playerName, message);
    }

    @Override
    public MessageType messageType() {
        return MessageType.COMMAND_TELL;
    }

    @Override
    public Command.Tell config() {
        return this.fileResolver.getCommand().getTell();
    }

    @Override
    public Permission.Command.Tell permission() {
        return this.fileResolver.getPermission().getCommand().getTell();
    }

    @Override
    public Localization.Command.Tell localization(FEntity sender) {
        return this.fileResolver.getLocalization(sender).getCommand().getTell();
    }

    public void send(FPlayer fPlayer, String playerName, String message) {
        if (this.isModuleDisabledFor(fPlayer, true)) {
            return;
        }
        if (fPlayer.getName().equalsIgnoreCase(playerName)) {
            this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Tell::getMyself)).destination(this.config().getDestination())).message(message)).build());
            return;
        }
        Range range = this.config().getRange();
        FPlayer fReceiver = this.fPlayerService.getFPlayer(playerName);
        if (!(fReceiver.isConsole() || !fReceiver.isUnknown() && fReceiver.isOnline() && this.integrationModule.canSeeVanished(fReceiver, fPlayer) && (range.is(Range.Type.PROXY) || this.platformPlayerAdapter.isOnline(fReceiver)))) {
            this.sendErrorMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Tell::getNullPlayer)).build());
            return;
        }
        this.fPlayerService.loadIgnoresIfOffline(fReceiver);
        if (this.ignoreSender.sendIfIgnored(fPlayer, fReceiver)) {
            return;
        }
        this.fPlayerService.loadSettingsIfOffline(fReceiver);
        if (this.disableSender.sendIfDisabled(fPlayer, fReceiver, this.messageType())) {
            return;
        }
        this.senderReceiverMap.put(fPlayer.getUuid(), fReceiver.getName());
        if (!fPlayer.isConsole() && !fReceiver.isConsole()) {
            String receiverUUID = fReceiver.getUuid().toString();
            UUID metadataUUID = UUID.randomUUID();
            boolean isSent = this.proxySender.send(fPlayer, this.messageType(), dataOutputStream -> {
                dataOutputStream.writeUTF(receiverUUID);
                dataOutputStream.writeUTF(message);
            }, metadataUUID);
            if (isSent) {
                this.send(fPlayer, fReceiver, fPlayer, Localization.Command.Tell::getSender, message, metadataUUID);
                return;
            }
        }
        this.send(fPlayer, fReceiver, fPlayer, Localization.Command.Tell::getSender, message, UUID.randomUUID());
        this.send(fPlayer, fReceiver, fReceiver, Localization.Command.Tell::getReceiver, message, UUID.randomUUID());
    }

    public void send(FEntity sender, FPlayer target, FPlayer fReceiver, Function<Localization.Command.Tell, String> format, String string, UUID metadataUUID) {
        boolean isSenderToSender = sender.equals(fReceiver);
        this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().uuid(metadataUUID)).sender(sender)).filterPlayer(fReceiver)).format(format)).destination(this.config().getDestination())).message(string)).sound(isSenderToSender ? null : this.getModuleSound())).tagResolvers(fResolver -> new TagResolver[]{this.targetTag((FPlayer)fResolver, target)})).build());
        if (!isSenderToSender) {
            this.senderReceiverMap.put(fReceiver.getUuid(), sender.getName());
        }
    }

    @Inject
    @Generated
    public TellModule(FileResolver fileResolver, FPlayerService fPlayerService, ProxySender proxySender, IntegrationModule integrationModule, CommandParserProvider commandParserProvider, PlatformPlayerAdapter platformPlayerAdapter, IgnoreSender ignoreSender, DisableSender disableSender) {
        this.fileResolver = fileResolver;
        this.fPlayerService = fPlayerService;
        this.proxySender = proxySender;
        this.integrationModule = integrationModule;
        this.commandParserProvider = commandParserProvider;
        this.platformPlayerAdapter = platformPlayerAdapter;
        this.ignoreSender = ignoreSender;
        this.disableSender = disableSender;
    }

    @Generated
    public HashMap<UUID, String> getSenderReceiverMap() {
        return this.senderReceiverMap;
    }
}

