/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.tictactoe.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import lombok.Generated;
import net.flectone.pulse.library.apache.lang3.RegExUtils;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.cloud.cloud.type.tuple.Pair;
import net.flectone.pulse.model.entity.FPlayer;
import org.jetbrains.annotations.Nullable;

public class TicTacToe {
    private static final int FIRST_VALUE = 1;
    private static final int SECOND_VALUE = 2;
    private static final int REMOVE_MULTIPLIER = -1;
    private static final int WIN_OFFSET = 5;
    private final Map<Integer, Queue<String>> movesMap = new HashMap<Integer, Queue<String>>();
    private final int id;
    private final boolean hard;
    private final int[][] field = new int[3][3];
    private final int firstPlayer;
    private final int secondPlayer;
    private int nextPlayer;
    private int[] winningTrio = null;
    private boolean ended;
    private boolean created;

    public TicTacToe(int id, int firstPlayer, int secondPlayer, boolean hard) {
        this.id = id;
        this.hard = hard;
        this.movesMap.put(firstPlayer, new LinkedList());
        this.firstPlayer = firstPlayer;
        this.movesMap.put(secondPlayer, new LinkedList());
        this.secondPlayer = secondPlayer;
        this.nextPlayer = secondPlayer;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append(this.id).append(",").append(this.nextPlayer).append(",");
        int[][] nArray = this.field;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int[] row;
            for (int column : row = nArray[i]) {
                stringBuilder.append(column).append(";");
            }
            stringBuilder.append(",");
        }
        stringBuilder.append(this.ended ? 1 : 0);
        return stringBuilder.toString();
    }

    public String build(String formatField, String first, String firstRemove, String firstWin, String second, String secondRemove, String secondWin, String empty) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                formatField = RegExUtils.replaceFirst((String)formatField, (String)"\\[#]", (String)(switch (this.field[i][j]) {
                    case 1 -> first;
                    case -1 -> firstRemove;
                    case 6 -> firstWin;
                    case 2 -> second;
                    case -2 -> secondRemove;
                    case 7 -> secondWin;
                    default -> Strings.CS.replace(empty, "<move>", i + "-" + j);
                }));
            }
        }
        return formatField;
    }

    public boolean isWin() {
        return this.winningTrio != null;
    }

    public void checkWinningTrio() {
        for (int row = 0; row < 3; ++row) {
            if (this.field[row][0] == 0 || Math.abs(this.field[row][0]) != Math.abs(this.field[row][1]) || Math.abs(this.field[row][1]) != Math.abs(this.field[row][2])) continue;
            this.winningTrio = new int[]{row, 0, row, 1, row, 2};
            break;
        }
        for (int column = 0; column < 3; ++column) {
            if (this.field[0][column] == 0 || Math.abs(this.field[0][column]) != Math.abs(this.field[1][column]) || Math.abs(this.field[1][column]) != Math.abs(this.field[2][column])) continue;
            this.winningTrio = new int[]{0, column, 1, column, 2, column};
            break;
        }
        if (this.field[0][0] != 0 && Math.abs(this.field[0][0]) == Math.abs(this.field[1][1]) && Math.abs(this.field[1][1]) == Math.abs(this.field[2][2])) {
            this.winningTrio = new int[]{0, 0, 1, 1, 2, 2};
        }
        if (this.field[0][2] != 0 && Math.abs(this.field[0][2]) == Math.abs(this.field[1][1]) && Math.abs(this.field[1][1]) == Math.abs(this.field[2][0])) {
            this.winningTrio = new int[]{0, 2, 1, 1, 2, 0};
        }
        if (this.winningTrio != null) {
            for (int i = 1; i < this.winningTrio.length; i += 2) {
                int row = this.winningTrio[i - 1];
                int column = this.winningTrio[i];
                this.field[row][column] = Math.abs(this.field[row][column]) + 5;
            }
        }
    }

    public boolean isDraw() {
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 3; ++column) {
                if (this.field[row][column] != 0) continue;
                return false;
            }
        }
        return true;
    }

    public boolean contains(FPlayer fPlayer) {
        return this.movesMap.containsKey(fPlayer.getId());
    }

    public void setNextPlayer() {
        this.nextPlayer = this.nextPlayer == this.firstPlayer ? this.secondPlayer : this.firstPlayer;
    }

    public boolean move(FPlayer fPlayer, String move) {
        int currentPlayerValue;
        int column;
        if (this.nextPlayer != fPlayer.getId()) {
            return false;
        }
        Queue<String> moves = this.movesMap.get(fPlayer.getId());
        if (this.movesMap.values().stream().allMatch(Collection::isEmpty) && (move == null || move.equals("create"))) {
            this.setNextPlayer();
            this.created = true;
            return true;
        }
        Pair<Integer, Integer> rowColumn = this.parseMove(move);
        if (rowColumn == null) {
            return false;
        }
        int row = (Integer)rowColumn.first();
        if (this.field[row][column = ((Integer)rowColumn.second()).intValue()] != 0) {
            return false;
        }
        moves.add(move);
        this.movesMap.put(fPlayer.getId(), moves);
        this.field[row][column] = currentPlayerValue = this.firstPlayer == fPlayer.getId() ? 1 : 2;
        if (this.isHard() && moves.size() > 2) {
            this.removeMove(moves, currentPlayerValue);
        }
        this.checkWinningTrio();
        this.setNextPlayer();
        return true;
    }

    private void removeMove(Queue<String> moves, int currentPlayerValue) {
        String nextRemove;
        Pair<Integer, Integer> rowColumn;
        if (moves.size() > 3) {
            String move = moves.poll();
            rowColumn = this.parseMove(move);
            if (rowColumn == null) {
                return;
            }
            this.field[((Integer)rowColumn.first()).intValue()][((Integer)rowColumn.second()).intValue()] = 0;
        }
        if ((nextRemove = moves.peek()) == null) {
            return;
        }
        rowColumn = this.parseMove(nextRemove);
        if (rowColumn == null) {
            return;
        }
        this.field[((Integer)rowColumn.first()).intValue()][((Integer)rowColumn.second()).intValue()] = -1 * currentPlayerValue;
    }

    @Nullable
    private Pair<Integer, Integer> parseMove(String move) {
        try {
            String[] stringMove = move.split("-");
            return Pair.of((Object)Integer.parseInt(stringMove[0]), (Object)Integer.parseInt(stringMove[1]));
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    @Generated
    public Map<Integer, Queue<String>> getMovesMap() {
        return this.movesMap;
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public boolean isHard() {
        return this.hard;
    }

    @Generated
    public int[][] getField() {
        return this.field;
    }

    @Generated
    public int getFirstPlayer() {
        return this.firstPlayer;
    }

    @Generated
    public int getSecondPlayer() {
        return this.secondPlayer;
    }

    @Generated
    public int getNextPlayer() {
        return this.nextPlayer;
    }

    @Generated
    public int[] getWinningTrio() {
        return this.winningTrio;
    }

    @Generated
    public boolean isEnded() {
        return this.ended;
    }

    @Generated
    public boolean isCreated() {
        return this.created;
    }

    @Generated
    public void setNextPlayer(int nextPlayer) {
        this.nextPlayer = nextPlayer;
    }

    @Generated
    public void setEnded(boolean ended) {
        this.ended = ended;
    }
}

