/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.translateto;

import bukkit-downgraded.xyz.wagyourtail.jvmdg.j21.stub.java_base.J_L_MatchException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.cloud.cloud.context.CommandContext;
import net.flectone.pulse.library.cloud.cloud.suggestion.BlockingSuggestionProvider;
import net.flectone.pulse.library.cloud.cloud.suggestion.Suggestion;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Provider;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleCommand;
import net.flectone.pulse.module.command.translateto.model.TranslatetoMetadata;
import net.flectone.pulse.module.integration.IntegrationModule;
import net.flectone.pulse.module.message.format.translate.TranslateModule;
import net.flectone.pulse.platform.provider.CommandParserProvider;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.constant.MessageType;

@Singleton
public class TranslatetoModule
extends AbstractModuleCommand<Localization.Command.Translateto> {
    private final FileResolver fileResolver;
    private final CommandParserProvider commandParserProvider;
    private final IntegrationModule integrationModule;
    private final Provider<TranslateModule> translateModuleProvider;

    @Override
    public void onEnable() {
        super.onEnable();
        String promptLanguage = this.addPrompt(0, Localization.Command.Prompt::getLanguage);
        String promptMessage = this.addPrompt(1, Localization.Command.Prompt::getMessage);
        this.registerCommand(manager -> manager.required(promptLanguage + " main", this.commandParserProvider.singleMessageParser(), this.languageSuggestion()).required(promptLanguage + " target", this.commandParserProvider.singleMessageParser(), this.languageSuggestion()).required(promptMessage, this.commandParserProvider.nativeMessageParser()).permission(this.permission().getName()));
    }

    @NonNull
    private BlockingSuggestionProvider<FPlayer> languageSuggestion() {
        return (context, input) -> this.config().getLanguages().stream().map(Suggestion::suggestion).toList();
    }

    @Override
    public void execute(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        String translatedMessage;
        if (this.isModuleDisabledFor(fPlayer, true)) {
            return;
        }
        String promptLanguage = this.getPrompt(0);
        String mainLang = (String)commandContext.get(promptLanguage + " main");
        String targetLang = (String)commandContext.get(promptLanguage + " target");
        String message = (String)this.getArgument(commandContext, 1);
        String messageToTranslate = ((TranslateModule)this.translateModuleProvider.get()).getMessage(message);
        if (StringUtils.isEmpty((CharSequence)messageToTranslate)) {
            messageToTranslate = message;
        }
        if ((translatedMessage = this.translate(fPlayer, mainLang, targetLang, messageToTranslate)).isEmpty()) {
            this.sendErrorMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Translateto::getNullOrError)).build());
            return;
        }
        String finalMessageToTranslate = messageToTranslate;
        this.sendMessage(((TranslatetoMetadata.TranslatetoMetadataBuilder)((TranslatetoMetadata.TranslatetoMetadataBuilder)((TranslatetoMetadata.TranslatetoMetadataBuilder)((TranslatetoMetadata.TranslatetoMetadataBuilder)((TranslatetoMetadata.TranslatetoMetadataBuilder)((TranslatetoMetadata.TranslatetoMetadataBuilder)((EventMetadata.EventMetadataBuilder)((TranslatetoMetadata.TranslatetoMetadataBuilder)((TranslatetoMetadata.TranslatetoMetadataBuilder)((TranslatetoMetadata.TranslatetoMetadataBuilder)TranslatetoMetadata.builder().sender(fPlayer)).format(this.replaceLanguage(targetLang))).targetLanguage(targetLang)).messageToTranslate(messageToTranslate)).range(this.config().getRange())).destination(this.config().getDestination())).message(translatedMessage)).sound(this.getModuleSound())).proxy(dataOutputStream -> {
            dataOutputStream.writeString(targetLang);
            dataOutputStream.writeString(message);
            dataOutputStream.writeString(finalMessageToTranslate);
        })).integration(string -> Strings.CS.replace(string, "<language>", targetLang))).build());
    }

    @Override
    public MessageType messageType() {
        return MessageType.COMMAND_TRANSLATETO;
    }

    @Override
    public Command.Translateto config() {
        return this.fileResolver.getCommand().getTranslateto();
    }

    @Override
    public Permission.Command.Translateto permission() {
        return this.fileResolver.getPermission().getCommand().getTranslateto();
    }

    @Override
    public Localization.Command.Translateto localization(FEntity sender) {
        return this.fileResolver.getLocalization(sender).getCommand().getTranslateto();
    }

    public Function<Localization.Command.Translateto, String> replaceLanguage(String targetLang) {
        return message -> Strings.CS.replace(message.getFormat(), "<language>", targetLang);
    }

    public String translate(FPlayer fPlayer, String source, String target, String text) {
        return switch (this.config().getService()) {
            default -> throw new J_L_MatchException(null, null);
            case Command.Translateto.Service.DEEPL -> this.integrationModule.deeplTranslate(fPlayer, source, target, text);
            case Command.Translateto.Service.GOOGLE -> this.googleTranslate(source, target, text);
            case Command.Translateto.Service.YANDEX -> this.integrationModule.yandexTranslate(fPlayer, source, target, text);
        };
    }

    public String googleTranslate(String source, String lang, String text) {
        try {
            String inputLine;
            text = URLEncoder.encode(text, StandardCharsets.UTF_8);
            URL url = new URI("http://translate.googleapis.com/translate_a/single?client=gtx&sl=" + source + "&tl=" + lang + "&dt=t&q=" + text + "&ie=UTF-8&oe=UTF-8").toURL();
            URLConnection uc = url.openConnection();
            uc.setRequestProperty("User-Agent", "Mozilla/5.0");
            BufferedReader in = new BufferedReader(new InputStreamReader(uc.getInputStream(), StandardCharsets.UTF_8));
            while ((inputLine = in.readLine()) != null) {
                text = inputLine;
            }
            in.close();
            String jsonResponse = text;
            int startIndex = jsonResponse.indexOf("\"") + 1;
            int endIndex = jsonResponse.indexOf("\"", startIndex);
            return jsonResponse.substring(startIndex, endIndex);
        }
        catch (IOException | URISyntaxException ignored) {
            return "";
        }
    }

    @Inject
    @Generated
    public TranslatetoModule(FileResolver fileResolver, CommandParserProvider commandParserProvider, IntegrationModule integrationModule, Provider<TranslateModule> translateModuleProvider) {
        this.fileResolver = fileResolver;
        this.commandParserProvider = commandParserProvider;
        this.integrationModule = integrationModule;
        this.translateModuleProvider = translateModuleProvider;
    }
}

