/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration;

import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import net.flectone.pulse.library.adventure.text.Component;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Injector;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.util.ExternalModeration;
import net.flectone.pulse.module.integration.IntegrationModule;
import net.flectone.pulse.module.integration.advancedban.AdvancedBanModule;
import net.flectone.pulse.module.integration.interactivechat.InteractiveChatModule;
import net.flectone.pulse.module.integration.itemsadder.ItemsAdderModule;
import net.flectone.pulse.module.integration.litebans.LiteBansModule;
import net.flectone.pulse.module.integration.maintenance.MaintenanceModule;
import net.flectone.pulse.module.integration.minimotd.MiniMOTDModule;
import net.flectone.pulse.module.integration.miniplaceholders.MiniPlaceholdersModule;
import net.flectone.pulse.module.integration.motd.MOTDModule;
import net.flectone.pulse.module.integration.placeholderapi.PlaceholderAPIModule;
import net.flectone.pulse.module.integration.supervanish.SuperVanishModule;
import net.flectone.pulse.module.integration.tab.TABModule;
import net.flectone.pulse.module.integration.triton.TritonModule;
import net.flectone.pulse.module.integration.vault.VaultModule;
import net.flectone.pulse.platform.adapter.PlatformServerAdapter;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.processing.resolver.ReflectionResolver;
import net.flectone.pulse.util.logging.FLogger;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;

@Singleton
public class BukkitIntegrationModule
extends IntegrationModule {
    private final Injector injector;
    private final PlatformServerAdapter platformServerAdapter;
    private final ReflectionResolver reflectionResolver;
    private final FLogger fLogger;

    @Inject
    public BukkitIntegrationModule(FileResolver fileResolver, FLogger fLogger, PlatformServerAdapter platformServerAdapter, ReflectionResolver reflectionResolver, Injector injector) {
        super(fileResolver, fLogger, platformServerAdapter, reflectionResolver, injector);
        this.injector = injector;
        this.platformServerAdapter = platformServerAdapter;
        this.reflectionResolver = reflectionResolver;
        this.fLogger = fLogger;
    }

    @Override
    public void configureChildren() {
        super.configureChildren();
        if (this.platformServerAdapter.hasProject("AdvancedBan")) {
            this.addChildren(AdvancedBanModule.class);
        }
        if (this.platformServerAdapter.hasProject("PlaceholderAPI")) {
            this.addChildren(PlaceholderAPIModule.class);
        }
        if (this.platformServerAdapter.hasProject("Vault")) {
            this.addChildren(VaultModule.class);
        }
        if (this.platformServerAdapter.hasProject("InteractiveChat")) {
            if (this.reflectionResolver.hasClass("com.loohp.interactivechat.registry.Registry")) {
                this.addChildren(InteractiveChatModule.class);
            } else {
                this.fLogger.warning("Update InteractiveChat to the latest version");
            }
        }
        if (this.platformServerAdapter.hasProject("ItemsAdder")) {
            this.addChildren(ItemsAdderModule.class);
        }
        if (this.platformServerAdapter.hasProject("LiteBans")) {
            this.addChildren(LiteBansModule.class);
        }
        if (this.platformServerAdapter.hasProject("Maintenance")) {
            this.addChildren(MaintenanceModule.class);
        }
        if (this.platformServerAdapter.hasProject("MiniMOTD")) {
            this.addChildren(MiniMOTDModule.class);
        }
        if (this.platformServerAdapter.hasProject("MiniPlaceholders")) {
            this.addChildren(MiniPlaceholdersModule.class);
        }
        if (this.platformServerAdapter.hasProject("MOTD")) {
            this.addChildren(MOTDModule.class);
        }
        if (this.platformServerAdapter.hasProject("SuperVanish") || this.platformServerAdapter.hasProject("PremiumVanish")) {
            if (this.reflectionResolver.hasClass("de.myzelyam.api.vanish.VanishAPI")) {
                this.addChildren(SuperVanishModule.class);
            } else {
                this.fLogger.warning("Integration with SuperVanish is not possible. Are you using another plugin with the same name? It is only supported https://www.spigotmc.org/resources/supervanish-be-invisible.1331/");
            }
        }
        if (this.platformServerAdapter.hasProject("TAB")) {
            this.addChildren(TABModule.class);
        }
        if (this.platformServerAdapter.hasProject("Triton")) {
            this.addChildren(TritonModule.class);
        }
    }

    @Override
    public String checkMention(FEntity fSender, String message) {
        if (this.isModuleDisabledFor(fSender)) {
            return message;
        }
        if (this.getChildren().contains(InteractiveChatModule.class)) {
            return ((InteractiveChatModule)this.injector.getInstance(InteractiveChatModule.class)).checkMention(fSender, message);
        }
        return message;
    }

    @Override
    public boolean hasFPlayerPermission(FPlayer fPlayer, String permission) {
        boolean value = super.hasFPlayerPermission(fPlayer, permission);
        if (this.getChildren().contains(VaultModule.class)) {
            value = value && ((VaultModule)this.injector.getInstance(VaultModule.class)).hasVaultPermission(fPlayer, permission);
        }
        return value;
    }

    @Override
    public String getPrefix(FPlayer fPlayer) {
        String prefix = super.getPrefix(fPlayer);
        if (prefix != null) {
            return prefix;
        }
        if (this.getChildren().contains(VaultModule.class)) {
            return ((VaultModule)this.injector.getInstance(VaultModule.class)).getPrefix(fPlayer);
        }
        return null;
    }

    @Override
    public String getSuffix(FPlayer fPlayer) {
        String suffix = super.getSuffix(fPlayer);
        if (suffix != null) {
            return suffix;
        }
        if (this.getChildren().contains(VaultModule.class)) {
            return ((VaultModule)this.injector.getInstance(VaultModule.class)).getSuffix(fPlayer);
        }
        return null;
    }

    @Override
    public Set<String> getGroups() {
        Set<String> groups = super.getGroups();
        if (!groups.isEmpty()) {
            return groups;
        }
        if (this.getChildren().contains(VaultModule.class)) {
            return ((VaultModule)this.injector.getInstance(VaultModule.class)).getGroups();
        }
        return Collections.emptySet();
    }

    @Override
    public boolean isVanished(FEntity sender) {
        if (this.getChildren().contains(SuperVanishModule.class)) {
            return ((SuperVanishModule)this.injector.getInstance(SuperVanishModule.class)).isVanished(sender);
        }
        Player player = Bukkit.getPlayer((UUID)sender.getUuid());
        if (player == null) {
            return false;
        }
        return player.getMetadata("vanished").stream().anyMatch(MetadataValue::asBoolean);
    }

    @Override
    public boolean hasSeeVanishPermission(FEntity sender) {
        Player player = Bukkit.getPlayer((UUID)sender.getUuid());
        if (player == null) {
            return false;
        }
        return player.hasPermission("sv.see") || player.hasPermission("cmi.seevanished");
    }

    @Override
    public boolean isMuted(FPlayer fPlayer) {
        if (this.getChildren().contains(LiteBansModule.class)) {
            return ((LiteBansModule)this.injector.getInstance(LiteBansModule.class)).isMuted(fPlayer);
        }
        if (this.getChildren().contains(AdvancedBanModule.class)) {
            return ((AdvancedBanModule)this.injector.getInstance(AdvancedBanModule.class)).isMuted(fPlayer);
        }
        return false;
    }

    @Override
    public ExternalModeration getMute(FPlayer fPlayer) {
        if (this.getChildren().contains(LiteBansModule.class)) {
            return ((LiteBansModule)this.injector.getInstance(LiteBansModule.class)).getMute(fPlayer);
        }
        if (this.getChildren().contains(AdvancedBanModule.class)) {
            return ((AdvancedBanModule)this.injector.getInstance(AdvancedBanModule.class)).getMute(fPlayer);
        }
        return null;
    }

    @Override
    public String getTritonLocale(FPlayer fPlayer) {
        if (!this.isEnable()) {
            return null;
        }
        if (!this.getChildren().contains(TritonModule.class)) {
            return null;
        }
        return ((TritonModule)this.injector.getInstance(TritonModule.class)).getLocale(fPlayer);
    }

    @Override
    public boolean sendMessageWithInteractiveChat(FEntity fReceiver, Component message) {
        if (this.isModuleDisabledFor(fReceiver)) {
            return false;
        }
        if (this.getChildren().contains(InteractiveChatModule.class)) {
            return ((InteractiveChatModule)this.injector.getInstance(InteractiveChatModule.class)).sendMessage(fReceiver, message);
        }
        return false;
    }
}

