/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.discord;

import bukkit-downgraded.xyz.wagyourtail.jvmdg.j21.stub.java_base.J_U_List;
import discord4j.common.util.Snowflake;
import discord4j.core.DiscordClient;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.entity.ApplicationInfo;
import discord4j.core.object.presence.Activity;
import discord4j.core.object.presence.ClientActivity;
import discord4j.core.object.presence.ClientPresence;
import discord4j.core.object.presence.Status;
import discord4j.core.spec.EmbedCreateSpec;
import discord4j.core.spec.MessageCreateSpec;
import discord4j.core.spec.WebhookCreateSpec;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.AllowedMentionsData;
import discord4j.discordjson.json.ChannelModifyRequest;
import discord4j.discordjson.json.ImmutableWebhookExecuteRequest;
import discord4j.discordjson.json.WebhookData;
import discord4j.discordjson.json.WebhookExecuteRequest;
import discord4j.rest.util.AllowedMentions;
import discord4j.rest.util.MultipartRequest;
import java.awt.Color;
import java.time.Instant;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import lombok.Generated;
import net.flectone.pulse.config.Integration;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.execution.scheduler.TaskScheduler;
import net.flectone.pulse.library.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.apache.lang3.math.NumberUtils;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.module.integration.FIntegration;
import net.flectone.pulse.module.integration.discord.listener.MessageCreateListener;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.processing.resolver.SystemVariableResolver;
import net.flectone.pulse.service.SkinService;
import net.flectone.pulse.util.logging.FLogger;

@Singleton
public class DiscordIntegration
implements FIntegration {
    private final Map<Long, WebhookData> channelWebhooks = new HashMap<Long, WebhookData>();
    private final FileResolver fileResolver;
    private final TaskScheduler taskScheduler;
    private final SkinService skinService;
    private final MessageCreateListener messageCreateListener;
    private final MessagePipeline messagePipeline;
    private final SystemVariableResolver systemVariableResolver;
    private final FLogger fLogger;
    private DiscordClient discordClient;
    private GatewayDiscordClient gateway;
    private long clientID;

    public Integration.Discord config() {
        return this.fileResolver.getIntegration().getDiscord();
    }

    public void sendMessage(FEntity sender, String messageName, UnaryOperator<String> discordString) {
        String webhookAvatar;
        if (this.gateway == null) {
            return;
        }
        String integrationChannel = this.config().getMessageChannel().get(messageName);
        if (integrationChannel == null) {
            return;
        }
        if (integrationChannel.isEmpty()) {
            return;
        }
        Localization.Integration.Discord localization = this.fileResolver.getLocalization().getIntegration().getDiscord();
        Localization.Integration.Discord.ChannelEmbed messageChannelEmbed = localization.getMessageChannel().getOrDefault(messageName, new Localization.Integration.Discord.ChannelEmbed());
        String skin = this.skinService.getSkin(sender);
        UnaryOperator replaceSkin = s -> Strings.CS.replace(s, "<skin>", skin);
        UnaryOperator replaceString = s -> (String)discordString.andThen(replaceSkin).apply((String)s);
        Localization.Integration.Discord.Embed messageEmbed = messageChannelEmbed.getEmbed();
        EmbedCreateSpec embed = null;
        if (messageEmbed != null) {
            embed = this.createEmbed(messageEmbed, replaceSkin, replaceString);
        }
        if (StringUtils.isNotEmpty((CharSequence)(webhookAvatar = messageChannelEmbed.getWebhookAvatar()))) {
            long channelID = Snowflake.of((String)integrationChannel).asLong();
            WebhookData webhookData = this.channelWebhooks.get(channelID);
            if (webhookData == null) {
                webhookData = this.createWebhook(channelID);
                if (webhookData == null) {
                    return;
                }
                this.channelWebhooks.put(channelID, webhookData);
            }
            String username = sender.getName();
            ImmutableWebhookExecuteRequest.Builder webhookBuilder = WebhookExecuteRequest.builder().allowedMentions((AllowedMentionsData)AllowedMentionsData.builder().build()).username(username).avatarUrl((String)replaceSkin.apply(webhookAvatar)).content((String)replaceString.apply(messageChannelEmbed.getContent()));
            if (embed != null) {
                webhookBuilder.addEmbed(embed.asRequest());
            }
            this.discordClient.getWebhookService().executeWebhook(webhookData.id().asLong(), (String)webhookData.token().get(), false, MultipartRequest.ofRequest((Object)webhookBuilder.build())).subscribe();
            return;
        }
        MessageCreateSpec.Builder messageCreateSpecBuilder = MessageCreateSpec.builder().allowedMentions(AllowedMentions.suppressAll());
        if (embed != null) {
            messageCreateSpecBuilder.addEmbed(embed);
        }
        String content = (String)replaceString.apply(messageChannelEmbed.getContent());
        messageCreateSpecBuilder.content(content);
        this.discordClient.getChannelById(Snowflake.of((String)integrationChannel)).createMessage(messageCreateSpecBuilder.build().asRequest()).subscribe();
    }

    private WebhookData createWebhook(long channelID) {
        WebhookCreateSpec.Builder builder = WebhookCreateSpec.builder().name("FlectonePulseWebhook");
        WebhookCreateSpec webhook = builder.build();
        return (WebhookData)this.discordClient.getWebhookService().createWebhook(channelID, webhook.asRequest(), null).block();
    }

    private EmbedCreateSpec createEmbed(Localization.Integration.Discord.Embed embed, UnaryOperator<String> replaceSkin, UnaryOperator<String> discordString) {
        Localization.Integration.Discord.Embed.Footer footer;
        Localization.Integration.Discord.Embed.Author author;
        EmbedCreateSpec.Builder embedBuilder = EmbedCreateSpec.builder();
        if (StringUtils.isNotEmpty((CharSequence)embed.getColor())) {
            Color color = Color.decode(embed.getColor());
            embedBuilder.color(discord4j.rest.util.Color.of((int)color.getRGB()));
        }
        if (StringUtils.isNotEmpty((CharSequence)embed.getTitle())) {
            embedBuilder.title((String)discordString.apply(embed.getTitle()));
        }
        if (StringUtils.isNotEmpty((CharSequence)embed.getUrl())) {
            embedBuilder.url((String)replaceSkin.apply(embed.getUrl()));
        }
        if (StringUtils.isNotEmpty((CharSequence)(author = embed.getAuthor()).getName()) || StringUtils.isNotEmpty((CharSequence)author.getUrl()) || StringUtils.isNotEmpty((CharSequence)author.getIconUrl())) {
            embedBuilder.author((String)discordString.apply(author.getName()), (String)replaceSkin.apply(author.getUrl()), (String)replaceSkin.apply(author.getIconUrl()));
        }
        if (StringUtils.isNotEmpty((CharSequence)embed.getDescription())) {
            embedBuilder.description((String)discordString.apply(embed.getDescription()));
        }
        if (StringUtils.isNotEmpty((CharSequence)embed.getThumbnail())) {
            embedBuilder.thumbnail((String)discordString.apply(embed.getThumbnail()));
        }
        if (StringUtils.isNotEmpty((CharSequence)embed.getImage())) {
            embedBuilder.image((String)replaceSkin.apply(embed.getImage()));
        }
        if (embed.isTimestamp()) {
            embedBuilder.timestamp(Instant.now());
        }
        if (StringUtils.isNotEmpty((CharSequence)(footer = embed.getFooter()).getText()) || StringUtils.isNotEmpty((CharSequence)footer.getIconUrl())) {
            embedBuilder.footer((String)discordString.apply(footer.getText()), (String)replaceSkin.apply(footer.getIconUrl()));
        }
        if (embed.getFields() != null && !embed.getFields().isEmpty()) {
            for (Localization.Integration.Discord.Embed.Field field : embed.getFields()) {
                if (StringUtils.isEmpty((CharSequence)field.getName()) || StringUtils.isEmpty((CharSequence)field.getValue())) continue;
                embedBuilder.addField(field.getName(), field.getValue(), field.isInline());
            }
        }
        return embedBuilder.build();
    }

    @Override
    public void hook() {
        ApplicationInfo applicationInfo;
        Integration.Discord.ChannelInfo channelInfo;
        String token = this.systemVariableResolver.substituteEnvVars(this.config().getToken());
        if (token.isEmpty()) {
            return;
        }
        this.discordClient = DiscordClient.create((String)token);
        this.gateway = (GatewayDiscordClient)this.discordClient.gateway().login().block();
        if (this.gateway == null) {
            return;
        }
        Integration.Discord.Presence presence = this.config().getPresence();
        if (presence.isEnable()) {
            Integration.Discord.Presence.Activity activity = presence.getActivity();
            ClientActivity clientActivity = activity.isEnable() ? ClientActivity.of((Activity.Type)Activity.Type.valueOf((String)activity.getType()), (String)activity.getName(), (String)activity.getUrl()) : null;
            this.gateway.updatePresence(ClientPresence.of((Status)Status.valueOf((String)presence.getStatus()), (ClientActivity)clientActivity)).block();
        }
        if ((channelInfo = this.config().getChannelInfo()).isEnable() && channelInfo.getTicker().isEnable()) {
            long period = channelInfo.getTicker().getPeriod();
            this.taskScheduler.runAsyncTimer(this::updateChannelInfo, period, period);
            this.updateChannelInfo();
        }
        if (!this.config().getMessageChannel().isEmpty()) {
            this.gateway.getEventDispatcher().on(this.messageCreateListener.getEventType()).flatMap(this.messageCreateListener::execute).subscribe();
        }
        if ((applicationInfo = (ApplicationInfo)this.gateway.getApplicationInfo().block()) == null) {
            return;
        }
        this.clientID = applicationInfo.getId().asLong();
        Set uniqueChannels = this.config().getMessageChannel().values().stream().filter(id -> !id.isEmpty()).map(id -> Snowflake.of((String)id).asLong()).collect(Collectors.toSet());
        Iterator iterator = uniqueChannels.iterator();
        while (iterator.hasNext()) {
            long channelID = (Long)iterator.next();
            List botWebhooks = (List)this.discordClient.getWebhookService().getChannelWebhooks(channelID).filter(data -> data.applicationId().isPresent() && ((Id)data.applicationId().get()).asLong() == this.clientID).collectList().block();
            if (botWebhooks == null || botWebhooks.isEmpty()) continue;
            WebhookData kept = (WebhookData)J_U_List.getFirst(botWebhooks);
            for (int i = 1; i < botWebhooks.size(); ++i) {
                this.discordClient.getWebhookService().deleteWebhook(((WebhookData)botWebhooks.get(i)).id().asLong(), null).block();
            }
            this.channelWebhooks.put(channelID, kept);
        }
        this.fLogger.info("Discord integration enabled");
    }

    @Override
    public void unhook() {
        if (this.gateway == null) {
            return;
        }
        this.gateway.logout().block();
        this.channelWebhooks.clear();
        this.fLogger.info("Discord integration disabled");
    }

    public void updateChannelInfo() {
        if (this.gateway == null) {
            return;
        }
        if (!this.config().getChannelInfo().isEnable()) {
            return;
        }
        Localization.Integration.Discord localization = this.fileResolver.getLocalization().getIntegration().getDiscord();
        for (Map.Entry<String, String> entry : localization.getInfoChannel().entrySet()) {
            String id = entry.getKey();
            if (!NumberUtils.isParsable((String)id)) continue;
            Snowflake snowflake = Snowflake.of((String)id);
            this.gateway.getChannelById(snowflake).blockOptional().ifPresent(channel -> {
                String name = PlainTextComponentSerializer.plainText().serialize(this.messagePipeline.builder((String)entry.getValue()).build());
                channel.getRestChannel().modify((ChannelModifyRequest)ChannelModifyRequest.builder().name(name).build(), null).block();
            });
        }
    }

    @Inject
    @Generated
    public DiscordIntegration(FileResolver fileResolver, TaskScheduler taskScheduler, SkinService skinService, MessageCreateListener messageCreateListener, MessagePipeline messagePipeline, SystemVariableResolver systemVariableResolver, FLogger fLogger) {
        this.fileResolver = fileResolver;
        this.taskScheduler = taskScheduler;
        this.skinService = skinService;
        this.messageCreateListener = messageCreateListener;
        this.messagePipeline = messagePipeline;
        this.systemVariableResolver = systemVariableResolver;
        this.fLogger = fLogger;
    }
}

