/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.litebans;

import litebans.api.Database;
import litebans.api.Entry;
import lombok.Generated;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.util.ExternalModeration;
import net.flectone.pulse.module.integration.FIntegration;
import net.flectone.pulse.util.logging.FLogger;

@Singleton
public class LiteBansIntegration
implements FIntegration {
    private final FLogger fLogger;
    private boolean hooked;

    @Override
    public void hook() {
        this.hooked = true;
        this.fLogger.info("\u2714 LiteBans hooked");
    }

    @Override
    public void unhook() {
        this.hooked = false;
        this.fLogger.info("\u2716 LiteBans unhooked");
    }

    public boolean isMuted(FEntity fEntity) {
        return Database.get().isPlayerMuted(fEntity.getUuid(), null);
    }

    public ExternalModeration getMute(FEntity fEntity) {
        Entry mute = Database.get().getMute(fEntity.getUuid(), null, null);
        if (mute == null) {
            return null;
        }
        return new ExternalModeration(fEntity.getName(), mute.getExecutorName(), mute.getReason(), mute.getId(), mute.getDateStart(), mute.getDateEnd(), mute.isPermanent());
    }

    @Inject
    @Generated
    public LiteBansIntegration(FLogger fLogger) {
        this.fLogger = fLogger;
    }

    @Generated
    public boolean isHooked() {
        return this.hooked;
    }
}

