/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.litebans;

import lombok.Generated;
import net.flectone.pulse.config.Integration;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.util.ExternalModeration;
import net.flectone.pulse.module.AbstractModule;
import net.flectone.pulse.module.integration.litebans.LiteBansIntegration;
import net.flectone.pulse.module.integration.litebans.listener.LiteBansPulseListener;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.resolver.FileResolver;

@Singleton
public class LiteBansModule
extends AbstractModule {
    private final FileResolver fileResolver;
    private final LiteBansIntegration liteBansIntegration;
    private final ListenerRegistry listenerRegistry;

    @Override
    public void onEnable() {
        super.onEnable();
        this.liteBansIntegration.hook();
        this.listenerRegistry.register(LiteBansPulseListener.class);
    }

    @Override
    public void onDisable() {
        super.onDisable();
        this.liteBansIntegration.unhook();
    }

    @Override
    public Integration.Litebans config() {
        return this.fileResolver.getIntegration().getLitebans();
    }

    @Override
    public Permission.Integration.Litebans permission() {
        return this.fileResolver.getPermission().getIntegration().getLitebans();
    }

    public boolean isMuted(FEntity fEntity) {
        if (this.isModuleDisabledFor(fEntity)) {
            return false;
        }
        return this.liteBansIntegration.isMuted(fEntity);
    }

    public ExternalModeration getMute(FEntity fEntity) {
        if (this.isModuleDisabledFor(fEntity)) {
            return null;
        }
        return this.liteBansIntegration.getMute(fEntity);
    }

    public boolean isHooked() {
        return this.liteBansIntegration.isHooked();
    }

    @Inject
    @Generated
    public LiteBansModule(FileResolver fileResolver, LiteBansIntegration liteBansIntegration, ListenerRegistry listenerRegistry) {
        this.fileResolver = fileResolver;
        this.liteBansIntegration = liteBansIntegration;
        this.listenerRegistry = listenerRegistry;
    }
}

