/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.maintenance;

import lombok.Generated;
import net.flectone.pulse.config.Integration;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.module.AbstractModule;
import net.flectone.pulse.module.integration.maintenance.MaintenanceIntegration;
import net.flectone.pulse.module.integration.maintenance.listener.MaintenancePulseListener;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.resolver.FileResolver;

@Singleton
public class MaintenanceModule
extends AbstractModule {
    private final FileResolver fileResolver;
    private final MaintenanceIntegration maintenanceIntegration;
    private final ListenerRegistry listenerRegistry;

    @Override
    public void onEnable() {
        super.onEnable();
        this.maintenanceIntegration.hook();
        this.listenerRegistry.register(MaintenancePulseListener.class);
    }

    @Override
    public void onDisable() {
        super.onDisable();
        this.maintenanceIntegration.unhook();
    }

    @Override
    public Integration.Maintenance config() {
        return this.fileResolver.getIntegration().getMaintenance();
    }

    @Override
    public Permission.Integration.Maintenance permission() {
        return this.fileResolver.getPermission().getIntegration().getMaintenance();
    }

    public boolean isHooked() {
        return this.maintenanceIntegration.isHooked();
    }

    public boolean isMaintenance() {
        return this.maintenanceIntegration.isMaintenance();
    }

    @Inject
    @Generated
    public MaintenanceModule(FileResolver fileResolver, MaintenanceIntegration maintenanceIntegration, ListenerRegistry listenerRegistry) {
        this.fileResolver = fileResolver;
        this.maintenanceIntegration = maintenanceIntegration;
        this.listenerRegistry = listenerRegistry;
    }
}

