/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.maintenance.listener;

import lombok.Generated;
import net.flectone.pulse.annotation.Pulse;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.listener.PulseListener;
import net.flectone.pulse.model.event.message.StatusResponseEvent;
import net.flectone.pulse.model.event.module.ModuleEnableEvent;
import net.flectone.pulse.module.AbstractModule;
import net.flectone.pulse.module.integration.maintenance.MaintenanceModule;

@Singleton
public class MaintenancePulseListener
implements PulseListener {
    private final MaintenanceModule maintenanceModule;

    @Pulse
    public void onModuleEnableEvent(ModuleEnableEvent event) {
        if (!this.maintenanceModule.isHooked()) {
            return;
        }
        AbstractModule eventModule = event.getModule();
        if (eventModule instanceof net.flectone.pulse.module.command.maintenance.MaintenanceModule && this.maintenanceModule.config().isDisableFlectonepulseMaintenance()) {
            event.setCancelled(true);
        }
    }

    @Pulse
    public void onStatusResponseEvent(StatusResponseEvent event) {
        if (!this.maintenanceModule.isHooked()) {
            return;
        }
        if (!this.maintenanceModule.isMaintenance()) {
            return;
        }
        event.setCancelled(true);
    }

    @Inject
    @Generated
    public MaintenancePulseListener(MaintenanceModule maintenanceModule) {
        this.maintenanceModule = maintenanceModule;
    }
}

