/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.placeholderapi;

import java.util.HashMap;
import java.util.UUID;
import lombok.Generated;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import net.flectone.pulse.annotation.Pulse;
import net.flectone.pulse.annotation.Sync;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.listener.PulseListener;
import net.flectone.pulse.model.FColor;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.Event;
import net.flectone.pulse.model.event.message.MessageFormattingEvent;
import net.flectone.pulse.module.integration.FIntegration;
import net.flectone.pulse.module.integration.placeholderapi.PlaceholderAPIModule;
import net.flectone.pulse.platform.adapter.PlatformServerAdapter;
import net.flectone.pulse.processing.context.MessageContext;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.checker.PermissionChecker;
import net.flectone.pulse.util.constant.MessageFlag;
import net.flectone.pulse.util.constant.MessageType;
import net.flectone.pulse.util.constant.SettingText;
import net.flectone.pulse.util.logging.FLogger;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Singleton
public class PlaceholderAPIIntegration
extends PlaceholderExpansion
implements FIntegration,
PulseListener {
    private final FileResolver fileResolver;
    private final FPlayerService fPlayerService;
    private final PlatformServerAdapter platformServerAdapter;
    private final PermissionChecker permissionChecker;
    private final PlaceholderAPIModule placeholderAPIModule;
    private final FLogger fLogger;

    @NotNull
    public String getIdentifier() {
        return "FlectonePulse";
    }

    @NotNull
    public String getAuthor() {
        return "TheFaser";
    }

    @NotNull
    public String getVersion() {
        return "1.6.0";
    }

    @Override
    public void hook() {
        this.syncHook();
        this.fLogger.info("\u2714 PlaceholderAPI hooked");
    }

    @Override
    public void unhook() {
        this.syncUnhook();
        this.fLogger.info("\u2716 PlaceholderAPI unhooked");
    }

    @Sync
    public void syncHook() {
        this.register();
    }

    @Sync
    public void syncUnhook() {
        this.unregister();
    }

    public String onRequest(OfflinePlayer player, @NotNull String params) {
        if (player == null) {
            return null;
        }
        FPlayer fPlayer = this.fPlayerService.getFPlayer(player.getUniqueId());
        if ((params = params.toLowerCase()).startsWith("fcolor")) {
            String number = params.substring(params.lastIndexOf("_") + 1);
            if (!StringUtils.isNumeric((CharSequence)number)) {
                return null;
            }
            HashMap<Integer, String> colorsMap = new HashMap<Integer, String>(this.fileResolver.getMessage().getFormat().getFcolor().getDefaultColors());
            if (params.startsWith("fcolor_out")) {
                colorsMap.putAll(fPlayer.getFColors(FColor.Type.OUT));
            } else if (params.startsWith("fcolor_see")) {
                colorsMap.putAll(fPlayer.getFColors(FColor.Type.SEE));
            } else {
                colorsMap.putAll(fPlayer.getFColors(FColor.Type.SEE));
                colorsMap.putAll(fPlayer.getFColors(FColor.Type.OUT));
            }
            return (String)colorsMap.get(Integer.parseInt(number));
        }
        SettingText settingText = SettingText.fromString(params);
        if (settingText != null) {
            String value = fPlayer.getSetting(settingText);
            if (settingText == SettingText.CHAT_NAME && value == null) {
                return "default";
            }
            return StringUtils.defaultString((String)value);
        }
        try {
            MessageType messageType = MessageType.valueOf(params.toUpperCase());
            return String.valueOf(fPlayer.isSetting(messageType));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return switch (params) {
                case "player" -> fPlayer.getName();
                case "ip" -> fPlayer.getIp();
                case "ping" -> String.valueOf(this.fPlayerService.getPing(fPlayer));
                case "online" -> String.valueOf(this.platformServerAdapter.getOnlinePlayerCount());
                case "tps" -> this.platformServerAdapter.getTPS();
                default -> null;
            };
        }
    }

    @Pulse(priority=Event.Priority.LOW)
    public void onMessageFormattingEvent(MessageFormattingEvent event) {
        MessageContext messageContext = event.getContext();
        FEntity sender = messageContext.getSender();
        if (this.placeholderAPIModule.isModuleDisabledFor(sender)) {
            return;
        }
        FPlayer fReceiver = messageContext.getReceiver();
        boolean isUserMessage = messageContext.isFlag(MessageFlag.USER_MESSAGE);
        if (!this.permissionChecker.check(sender, this.placeholderAPIModule.permission().getUse()) && isUserMessage) {
            return;
        }
        if (!(sender instanceof FPlayer)) {
            return;
        }
        FPlayer fPlayer = (FPlayer)sender;
        String message = messageContext.getMessage();
        try {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)fPlayer.getUuid());
            message = PlaceholderAPI.setPlaceholders((OfflinePlayer)offlinePlayer, (String)message);
            if (fPlayer.isOnline()) {
                Player receiver = Bukkit.getPlayer((UUID)fReceiver.getUuid());
                if (receiver == null) {
                    receiver = offlinePlayer.getPlayer();
                }
                message = PlaceholderAPI.setRelationalPlaceholders((Player)offlinePlayer.getPlayer(), (Player)receiver, (String)message);
            }
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            // empty catch block
        }
        messageContext.setMessage(message);
    }

    @Inject
    @Generated
    public PlaceholderAPIIntegration(FileResolver fileResolver, FPlayerService fPlayerService, PlatformServerAdapter platformServerAdapter, PermissionChecker permissionChecker, PlaceholderAPIModule placeholderAPIModule, FLogger fLogger) {
        this.fileResolver = fileResolver;
        this.fPlayerService = fPlayerService;
        this.platformServerAdapter = platformServerAdapter;
        this.permissionChecker = permissionChecker;
        this.placeholderAPIModule = placeholderAPIModule;
        this.fLogger = fLogger;
    }
}

