/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.plasmovoice;

import java.util.UUID;
import lombok.Generated;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.integration.FIntegration;
import net.flectone.pulse.platform.formatter.ModerationMessageFormatter;
import net.flectone.pulse.platform.sender.MessageSender;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.checker.MuteChecker;
import net.flectone.pulse.util.logging.FLogger;
import su.plo.voice.api.addon.AddonInitializer;
import su.plo.voice.api.addon.AddonLoaderScope;
import su.plo.voice.api.addon.annotation.Addon;
import su.plo.voice.api.event.EventSubscribe;
import su.plo.voice.api.server.audio.source.ServerAudioSource;
import su.plo.voice.api.server.event.audio.source.ServerSourceCreatedEvent;
import su.plo.voice.api.server.event.connection.UdpPacketReceivedEvent;
import su.plo.voice.proto.data.audio.source.PlayerSourceInfo;
import su.plo.voice.proto.data.audio.source.SourceInfo;
import su.plo.voice.proto.packets.udp.serverbound.PlayerAudioPacket;

@Singleton
@Addon(id="flectonepulse", scope=AddonLoaderScope.SERVER, version="1.6.0", authors={"TheFaser"})
public class PlasmoVoiceIntegration
implements FIntegration,
AddonInitializer {
    private final FPlayerService fPlayerService;
    private final ModerationMessageFormatter moderationMessageFormatter;
    private final MuteChecker muteChecker;
    private final MessageSender messageSender;
    private final MessagePipeline messagePipeline;
    private final FLogger fLogger;
    private boolean enable;

    @Override
    public void hook() {
        this.enable = true;
        this.fLogger.info("\u2714 PlasmoVoice hooked");
    }

    @Override
    public void unhook() {
        this.enable = false;
        this.fLogger.info("\u2716 PlasmoVoice unhooked");
    }

    @EventSubscribe
    public void onServerSourceCreatedEvent(ServerSourceCreatedEvent event) {
        if (!this.enable) {
            return;
        }
        ServerAudioSource source = event.getSource();
        SourceInfo sourceInfo = source.getSourceInfo();
        if (!(sourceInfo instanceof PlayerSourceInfo)) {
            return;
        }
        PlayerSourceInfo sourceInfo2 = (PlayerSourceInfo)sourceInfo;
        UUID senderUUID = sourceInfo2.getPlayerInfo().getPlayerId();
        FPlayer fSender = this.fPlayerService.getFPlayer(senderUUID);
        source.addFilter(voicePlayer -> {
            UUID receiverUUID = voicePlayer.getInstance().getUuid();
            FPlayer fReceiver = this.fPlayerService.getFPlayer(receiverUUID);
            return !fReceiver.isIgnored(fSender);
        });
    }

    @EventSubscribe
    public void onPlayerSpeakEvent(UdpPacketReceivedEvent event) {
        if (!this.enable) {
            return;
        }
        if (!(event.getPacket() instanceof PlayerAudioPacket)) {
            return;
        }
        UUID senderUUID = event.getConnection().getPlayer().getInstance().getUuid();
        FPlayer fPlayer = this.fPlayerService.getFPlayer(senderUUID);
        MuteChecker.Status status = this.muteChecker.check(fPlayer);
        if (status == MuteChecker.Status.NONE) {
            return;
        }
        event.setCancelled(true);
        String message = this.moderationMessageFormatter.buildMuteMessage(fPlayer, status);
        this.messageSender.sendActionBar(fPlayer, this.messagePipeline.builder(fPlayer, message).build());
    }

    public void onAddonInitialize() {
    }

    @Inject
    @Generated
    public PlasmoVoiceIntegration(FPlayerService fPlayerService, ModerationMessageFormatter moderationMessageFormatter, MuteChecker muteChecker, MessageSender messageSender, MessagePipeline messagePipeline, FLogger fLogger) {
        this.fPlayerService = fPlayerService;
        this.moderationMessageFormatter = moderationMessageFormatter;
        this.muteChecker = muteChecker;
        this.messageSender = messageSender;
        this.messagePipeline = messagePipeline;
        this.fLogger = fLogger;
    }
}

