/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.supervanish;

import de.myzelyam.api.vanish.PlayerHideEvent;
import de.myzelyam.api.vanish.PlayerShowEvent;
import de.myzelyam.api.vanish.VanishAPI;
import java.util.UUID;
import lombok.Generated;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.integration.FIntegration;
import net.flectone.pulse.module.message.join.JoinModule;
import net.flectone.pulse.module.message.quit.QuitModule;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.logging.FLogger;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

@Singleton
public class SuperVanishIntegration
implements Listener,
FIntegration {
    private final FPlayerService fPlayerService;
    private final QuitModule quitModule;
    private final JoinModule joinModule;
    private final FLogger fLogger;

    @Override
    public void hook() {
        this.fLogger.info("\u2714 SuperVanish hooked");
    }

    @Override
    public void unhook() {
        this.fLogger.info("\u2716 SuperVanish unhooked");
    }

    @EventHandler
    public void onHide(PlayerHideEvent event) {
        if (event.isCancelled()) {
            return;
        }
        FPlayer fPlayer = this.fPlayerService.getFPlayer(event.getPlayer());
        this.quitModule.send(fPlayer, true);
        event.setSilent(true);
    }

    @EventHandler
    public void onShow(PlayerShowEvent event) {
        if (event.isCancelled()) {
            return;
        }
        FPlayer fPlayer = this.fPlayerService.getFPlayer(event.getPlayer());
        this.joinModule.send(fPlayer, true);
        event.setSilent(true);
    }

    public boolean isVanished(FEntity sender) {
        return VanishAPI.isInvisibleOffline((UUID)sender.getUuid());
    }

    @Inject
    @Generated
    public SuperVanishIntegration(FPlayerService fPlayerService, QuitModule quitModule, JoinModule joinModule, FLogger fLogger) {
        this.fPlayerService = fPlayerService;
        this.quitModule = quitModule;
        this.joinModule = joinModule;
        this.fLogger = fLogger;
    }
}

