/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.supervanish;

import java.util.UUID;
import lombok.Generated;
import net.flectone.pulse.config.Integration;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.module.AbstractModule;
import net.flectone.pulse.module.integration.supervanish.SuperVanishIntegration;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.resolver.FileResolver;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;

@Singleton
public class SuperVanishModule
extends AbstractModule {
    private final FileResolver fileResolver;
    private final SuperVanishIntegration superVanishIntegration;
    private final ListenerRegistry listenerRegistry;

    @Override
    public void onEnable() {
        super.onEnable();
        this.listenerRegistry.register(SuperVanishIntegration.class);
        this.superVanishIntegration.hook();
    }

    @Override
    public void onDisable() {
        super.onDisable();
        this.superVanishIntegration.unhook();
    }

    @Override
    public Integration.Supervanish config() {
        return this.fileResolver.getIntegration().getSupervanish();
    }

    @Override
    public Permission.Integration.Supervanish permission() {
        return this.fileResolver.getPermission().getIntegration().getSupervanish();
    }

    public boolean isVanished(FEntity sender) {
        if (this.isModuleDisabledFor(sender)) {
            return false;
        }
        Player player = Bukkit.getPlayer((UUID)sender.getUuid());
        if (player != null) {
            return player.getMetadata("vanished").stream().anyMatch(MetadataValue::asBoolean);
        }
        return this.superVanishIntegration.isVanished(sender);
    }

    @Inject
    @Generated
    public SuperVanishModule(FileResolver fileResolver, SuperVanishIntegration superVanishIntegration, ListenerRegistry listenerRegistry) {
        this.fileResolver = fileResolver;
        this.superVanishIntegration = superVanishIntegration;
        this.listenerRegistry = listenerRegistry;
    }
}

