/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.triton;

import com.rexcantor64.triton.api.TritonAPI;
import com.rexcantor64.triton.api.events.PlayerChangeLanguageSpigotEvent;
import com.rexcantor64.triton.api.players.LanguagePlayer;
import lombok.Generated;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.integration.FIntegration;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.constant.SettingText;
import net.flectone.pulse.util.logging.FLogger;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.Nullable;

@Singleton
public class TritonIntegration
implements Listener,
FIntegration {
    private final FPlayerService fPlayerService;
    private final FLogger fLogger;

    @Override
    public void hook() {
        this.fLogger.info("\u2714 Triton hooked");
    }

    @Override
    public void unhook() {
        this.fLogger.info("\u2716 Triton unhooked");
    }

    @EventHandler
    public void onPlayerChangeLanguageSpigotEvent(PlayerChangeLanguageSpigotEvent event) {
        if (event.isCancelled()) {
            return;
        }
        FPlayer fPlayer = this.fPlayerService.getFPlayer(event.getLanguagePlayer().getUUID());
        fPlayer.setSetting(SettingText.LOCALE, event.getNewLanguage().getLanguageId());
        this.fPlayerService.saveOrUpdateSetting(fPlayer, SettingText.LOCALE);
    }

    @Nullable
    public String getLocale(FPlayer fPlayer) {
        LanguagePlayer languagePlayer = TritonAPI.getInstance().getPlayerManager().get(fPlayer.getUuid());
        if (languagePlayer == null) {
            return null;
        }
        return languagePlayer.getLanguageId();
    }

    @Inject
    @Generated
    public TritonIntegration(FPlayerService fPlayerService, FLogger fLogger) {
        this.fPlayerService = fPlayerService;
        this.fLogger = fLogger;
    }
}

