/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.vault;

import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.integration.FIntegration;
import net.flectone.pulse.util.logging.FLogger;
import net.milkbowl.vault.chat.Chat;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;

@Singleton
public class VaultIntegration
implements FIntegration {
    private final Plugin plugin;
    private final FLogger fLogger;
    private Chat chat;
    private Permission permission;

    @Override
    public void hook() {
        RegisteredServiceProvider chatProvider;
        RegisteredServiceProvider permissionProvider = this.plugin.getServer().getServicesManager().getRegistration(Permission.class);
        if (permissionProvider != null) {
            this.permission = (Permission)permissionProvider.getProvider();
        }
        if ((chatProvider = this.plugin.getServer().getServicesManager().getRegistration(Chat.class)) != null) {
            this.chat = (Chat)chatProvider.getProvider();
        }
        this.fLogger.info("\u2714 Vault hooked");
    }

    @Override
    public void unhook() {
        this.fLogger.info("\u2716 Vault unhooked");
    }

    public boolean hasPermission(FPlayer fPlayer, String permissionName) {
        if (this.permission == null) {
            return false;
        }
        if (permissionName == null) {
            return false;
        }
        Player player = Bukkit.getPlayer((UUID)fPlayer.getUuid());
        if (player != null) {
            return this.permission.has(player, permissionName);
        }
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)fPlayer.getUuid());
        World world = (World)Bukkit.getWorlds().get(0);
        return this.permission.playerHas(world.getName(), offlinePlayer, permissionName);
    }

    public String getSuffix(FPlayer fPlayer) {
        if (this.chat == null) {
            return null;
        }
        Player player = Bukkit.getPlayer((UUID)fPlayer.getUuid());
        if (player == null) {
            return null;
        }
        return this.chat.getPlayerSuffix(player);
    }

    public String getPrefix(FPlayer fPlayer) {
        if (this.chat == null) {
            return null;
        }
        Player player = Bukkit.getPlayer((UUID)fPlayer.getUuid());
        if (player == null) {
            return null;
        }
        return this.chat.getPlayerPrefix(player);
    }

    public Set<String> getGroups() {
        if (this.chat == null) {
            return Collections.emptySet();
        }
        return Set.of(this.chat.getGroups());
    }

    @Inject
    @Generated
    public VaultIntegration(Plugin plugin, FLogger fLogger) {
        this.plugin = plugin;
        this.fLogger = fLogger;
    }
}

