/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.vault;

import java.util.Collections;
import java.util.Set;
import lombok.Generated;
import net.flectone.pulse.config.Integration;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.AbstractModule;
import net.flectone.pulse.module.integration.vault.VaultIntegration;
import net.flectone.pulse.processing.resolver.FileResolver;

@Singleton
public class VaultModule
extends AbstractModule {
    private final FileResolver fileResolver;
    private final VaultIntegration vaultIntegration;

    @Override
    public void onEnable() {
        super.onEnable();
        this.vaultIntegration.hook();
    }

    @Override
    public void onDisable() {
        super.onDisable();
        this.vaultIntegration.unhook();
    }

    @Override
    public Integration.Vault config() {
        return this.fileResolver.getIntegration().getVault();
    }

    @Override
    public Permission.Integration.Vault permission() {
        return this.fileResolver.getPermission().getIntegration().getVault();
    }

    public boolean hasVaultPermission(FPlayer fPlayer, String permission) {
        if (!this.isEnable()) {
            return false;
        }
        return this.vaultIntegration.hasPermission(fPlayer, permission);
    }

    public String getPrefix(FPlayer fPlayer) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return null;
        }
        return this.vaultIntegration.getPrefix(fPlayer);
    }

    public String getSuffix(FPlayer fPlayer) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return null;
        }
        return this.vaultIntegration.getSuffix(fPlayer);
    }

    public Set<String> getGroups() {
        if (!this.isEnable()) {
            return Collections.emptySet();
        }
        return this.vaultIntegration.getGroups();
    }

    @Inject
    @Generated
    public VaultModule(FileResolver fileResolver, VaultIntegration vaultIntegration) {
        this.fileResolver = fileResolver;
        this.vaultIntegration = vaultIntegration;
    }
}

