/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.yandex;

import lombok.Generated;
import net.flectone.pulse.config.Integration;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Injector;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.libby.Library;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.AbstractModule;
import net.flectone.pulse.module.integration.yandex.YandexIntegration;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.processing.resolver.LibraryResolver;
import net.flectone.pulse.processing.resolver.ReflectionResolver;

@Singleton
public class YandexModule
extends AbstractModule {
    private final FileResolver fileResolver;
    private final ReflectionResolver reflectionResolver;
    private final Injector injector;

    @Override
    public void onEnable() {
        super.onEnable();
        this.reflectionResolver.hasClassOrElse("yandex.cloud.sdk.auth.Auth", this::loadLibraries);
        ((YandexIntegration)this.injector.getInstance(YandexIntegration.class)).hook();
    }

    @Override
    public void onDisable() {
        super.onDisable();
        ((YandexIntegration)this.injector.getInstance(YandexIntegration.class)).unhook();
    }

    private void loadLibraries(LibraryResolver libraryResolver) {
        libraryResolver.loadLibrary(Library.builder().groupId("com{}yandex{}cloud").artifactId("java-sdk-services").version("2.10.0").repository("https://repo1.maven.org/maven2/").resolveTransitiveDependencies(true).build());
    }

    @Override
    public Integration.Yandex config() {
        return this.fileResolver.getIntegration().getYandex();
    }

    @Override
    public Permission.Integration.Yandex permission() {
        return this.fileResolver.getPermission().getIntegration().getYandex();
    }

    public String translate(FPlayer sender, String source, String target, String text) {
        if (this.isModuleDisabledFor(sender)) {
            return text;
        }
        return ((YandexIntegration)this.injector.getInstance(YandexIntegration.class)).translate(source, target, text);
    }

    @Inject
    @Generated
    public YandexModule(FileResolver fileResolver, ReflectionResolver reflectionResolver, Injector injector) {
        this.fileResolver = fileResolver;
        this.reflectionResolver = reflectionResolver;
        this.injector = injector;
    }
}

