/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.afk.listener;

import lombok.Generated;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.message.afk.AfkModule;
import net.flectone.pulse.service.FPlayerService;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;

@Singleton
public class AfkListener
implements Listener {
    private final FPlayerService fPlayerService;
    private final AfkModule afkModule;

    @EventHandler
    public void asyncPlayerChatEvent(AsyncPlayerChatEvent event) {
        FPlayer fPlayer = this.fPlayerService.getFPlayer(event.getPlayer());
        this.afkModule.remove("chat", fPlayer);
    }

    @EventHandler
    public void playerCommandPreprocessEvent(PlayerCommandPreprocessEvent event) {
        FPlayer fPlayer = this.fPlayerService.getFPlayer(event.getPlayer());
        String message = event.getMessage();
        if (!message.isEmpty()) {
            message = message.split(" ")[0].substring(1);
        }
        this.afkModule.remove(message, fPlayer);
    }

    @Inject
    @Generated
    public AfkListener(FPlayerService fPlayerService, AfkModule afkModule) {
        this.fPlayerService = fPlayerService;
        this.afkModule = afkModule;
    }
}

