/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.anvil;

import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.library.adventure.text.Component;
import net.flectone.pulse.library.adventure.text.TextComponent;
import net.flectone.pulse.library.adventure.text.minimessage.ParsingException;
import net.flectone.pulse.library.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.message.anvil.AnvilModule;
import net.flectone.pulse.module.message.anvil.listener.AnvilListener;
import net.flectone.pulse.platform.registry.BukkitListenerRegistry;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.constant.MessageFlag;
import org.bukkit.inventory.meta.ItemMeta;

@Singleton
public class BukkitAnvilModule
extends AnvilModule {
    private final ListenerRegistry listenerRegistry;
    private final MessagePipeline messagePipeline;

    @Inject
    public BukkitAnvilModule(FileResolver fileResolver, BukkitListenerRegistry listenerRegistry, MessagePipeline messagePipeline) {
        super(fileResolver);
        this.listenerRegistry = listenerRegistry;
        this.messagePipeline = messagePipeline;
    }

    @Override
    public void onEnable() {
        super.onEnable();
        this.listenerRegistry.register(AnvilListener.class);
    }

    @Override
    public boolean format(FPlayer fPlayer, Object itemMeta) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return false;
        }
        if (!(itemMeta instanceof ItemMeta)) {
            return false;
        }
        ItemMeta bukkitItemMeta = (ItemMeta)itemMeta;
        String displayName = bukkitItemMeta.getDisplayName();
        if (displayName.isEmpty()) {
            return false;
        }
        try {
            TextComponent deserialized = LegacyComponentSerializer.legacySection().deserialize(displayName);
            Component component = this.messagePipeline.builder(fPlayer, Strings.CS.replace(displayName, "\u00a7", "&")).flag(MessageFlag.USER_MESSAGE, true).flag(MessageFlag.LEGACY_COLORS, false).build().applyFallbackStyle(deserialized.style()).mergeStyle((Component)deserialized);
            bukkitItemMeta.setDisplayName(LegacyComponentSerializer.legacySection().serialize(component));
            return true;
        }
        catch (ParsingException parsingException) {
            return false;
        }
    }
}

