/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.book.listener;

import lombok.Generated;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.message.book.BukkitBookModule;
import net.flectone.pulse.service.FPlayerService;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerEditBookEvent;
import org.bukkit.inventory.meta.BookMeta;

@Singleton
public class BookListener
implements Listener {
    private final FPlayerService fPlayerService;
    private final BukkitBookModule bookModule;

    @EventHandler
    public void playerEditBookEvent(PlayerEditBookEvent event) {
        String title;
        if (event.isCancelled()) {
            return;
        }
        FPlayer fPlayer = this.fPlayerService.getFPlayer(event.getPlayer());
        BookMeta bookMeta = event.getNewBookMeta();
        for (int x = 1; x <= event.getNewBookMeta().getPages().size(); ++x) {
            String formatted;
            String string = bookMeta.getPage(x);
            if (string.isEmpty() || (formatted = this.bookModule.format(fPlayer, string)) == null) continue;
            bookMeta.setPage(x, formatted);
        }
        if (event.isSigning() && bookMeta.getTitle() != null && (title = this.bookModule.format(fPlayer, bookMeta.getTitle())) != null) {
            bookMeta.setTitle(title);
        }
        event.setNewBookMeta(bookMeta);
    }

    @Inject
    @Generated
    public BookListener(FPlayerService fPlayerService, BukkitBookModule bookModule) {
        this.fPlayerService = fPlayerService;
        this.bookModule = bookModule;
    }
}

