/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.bubble;

import java.util.List;
import lombok.Generated;
import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.AbstractModule;
import net.flectone.pulse.module.message.bubble.listener.BubblePacketListener;
import net.flectone.pulse.module.message.bubble.listener.BubblePulseListener;
import net.flectone.pulse.module.message.bubble.service.BubbleService;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.resolver.FileResolver;
import org.jetbrains.annotations.NotNull;

@Singleton
public class BubbleModule
extends AbstractModule {
    private final FileResolver fileResolver;
    private final BubbleService bubbleService;
    private final ListenerRegistry listenerRegistry;

    @Override
    public void onEnable() {
        super.onEnable();
        this.bubbleService.startTicker();
        this.listenerRegistry.register(BubblePacketListener.class);
        this.listenerRegistry.register(BubblePulseListener.class);
    }

    @Override
    public void onDisable() {
        super.onDisable();
        this.bubbleService.clear();
    }

    @Override
    public Message.Bubble config() {
        return this.fileResolver.getMessage().getBubble();
    }

    @Override
    public Permission.Message.Bubble permission() {
        return this.fileResolver.getPermission().getMessage().getBubble();
    }

    @Async
    public void add(@NotNull FPlayer fPlayer, @NotNull String inputString, List<FPlayer> receivers) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        this.bubbleService.addMessage(fPlayer, inputString, receivers);
    }

    @Inject
    @Generated
    public BubbleModule(FileResolver fileResolver, BubbleService bubbleService, ListenerRegistry listenerRegistry) {
        this.fileResolver = fileResolver;
        this.bubbleService = bubbleService;
        this.listenerRegistry = listenerRegistry;
    }

    public static enum Billboard {
        FIXED,
        VERTICAL,
        HORIZONTAL,
        CENTER;

    }
}

