/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.chat.listener;

import io.papermc.paper.event.player.AsyncChatEvent;
import java.util.function.BiConsumer;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.message.chat.ChatModule;
import net.flectone.pulse.service.FPlayerService;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class ChatPaperListener
implements Listener {
    private final FPlayerService fPlayerService;
    private final ChatModule chatModule;
    private final PlainTextComponentSerializer plainSerializer = PlainTextComponentSerializer.plainText();

    public ChatPaperListener(FPlayerService fPlayerService, ChatModule chatModule) {
        this.fPlayerService = fPlayerService;
        this.chatModule = chatModule;
    }

    @EventHandler
    public void asyncPlayerChatEvent(AsyncChatEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!this.chatModule.isEnable()) {
            return;
        }
        FPlayer fPlayer = this.fPlayerService.getFPlayer(event.getPlayer());
        if (this.chatModule.isModuleDisabledFor(fPlayer)) {
            return;
        }
        String format = this.plainSerializer.serialize(event.message());
        Runnable cancelRunnable = () -> {
            event.setCancelled(true);
            event.viewers().clear();
        };
        BiConsumer<String, Boolean> successConsumer = (finalMessage, isCancel) -> {
            event.message((Component)Component.text((String)finalMessage));
            event.setCancelled(isCancel.booleanValue());
            event.viewers().clear();
        };
        this.chatModule.send(fPlayer, format, cancelRunnable, successConsumer);
    }
}

