/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.format.fixation;

import lombok.Generated;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.module.AbstractModule;
import net.flectone.pulse.module.message.format.fixation.listener.FixationPulseListener;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.context.MessageContext;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.constant.MessageFlag;

@Singleton
public class FixationModule
extends AbstractModule {
    private final FileResolver fileResolver;
    private final ListenerRegistry listenerRegistry;

    @Override
    public void onEnable() {
        super.onEnable();
        this.listenerRegistry.register(FixationPulseListener.class);
    }

    @Override
    public Message.Format.Fixation config() {
        return this.fileResolver.getMessage().getFormat().getFixation();
    }

    @Override
    public Permission.Message.Format.Fixation permission() {
        return this.fileResolver.getPermission().getMessage().getFormat().getFixation();
    }

    public void format(MessageContext messageContext) {
        if (!messageContext.isFlag(MessageFlag.USER_MESSAGE)) {
            return;
        }
        FEntity sender = messageContext.getSender();
        if (this.isModuleDisabledFor(sender)) {
            return;
        }
        Object contextMessage = messageContext.getMessage();
        if (((String)contextMessage).isBlank()) {
            return;
        }
        if (this.config().isEndDot()) {
            if (this.config().getNonDotSymbols().stream().noneMatch(((String)contextMessage)::endsWith)) {
                contextMessage = (String)contextMessage + ".";
            }
        }
        if (this.config().isFirstLetterUppercase()) {
            contextMessage = Character.toUpperCase(((String)contextMessage).charAt(0)) + ((String)contextMessage).substring(1);
        }
        messageContext.setMessage((String)contextMessage);
    }

    @Inject
    @Generated
    public FixationModule(FileResolver fileResolver, ListenerRegistry listenerRegistry) {
        this.fileResolver = fileResolver;
        this.listenerRegistry = listenerRegistry;
    }
}

