/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.format.mention;

import java.util.Optional;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutionException;
import lombok.Generated;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.library.adventure.text.Component;
import net.flectone.pulse.library.adventure.text.minimessage.tag.Tag;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.guava.cache.Cache;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.guice.name.Named;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleLocalization;
import net.flectone.pulse.module.integration.IntegrationModule;
import net.flectone.pulse.module.message.format.mention.listener.MentionPulseListener;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.context.MessageContext;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.checker.PermissionChecker;
import net.flectone.pulse.util.constant.MessageType;
import net.flectone.pulse.util.logging.FLogger;

@Singleton
public class MentionModule
extends AbstractModuleLocalization<Localization.Message.Format.Mention> {
    private final WeakHashMap<UUID, Boolean> processedMentions = new WeakHashMap();
    @Named(value="mentionMessage")
    private final Cache<String, String> messageCache;
    private final FileResolver fileResolver;
    private final ListenerRegistry listenerRegistry;
    private final FPlayerService fPlayerService;
    private final IntegrationModule integrationModule;
    private final PermissionChecker permissionChecker;
    private final MessagePipeline messagePipeline;
    private final FLogger fLogger;

    @Override
    public void onEnable() {
        super.onEnable();
        this.createSound(this.config().getSound(), this.permission().getSound());
        this.registerPermission(this.permission().getGroup());
        this.registerPermission(this.permission().getBypass());
        this.listenerRegistry.register(MentionPulseListener.class);
    }

    @Override
    public void onDisable() {
        super.onDisable();
        this.processedMentions.clear();
        this.messageCache.invalidateAll();
    }

    @Override
    public MessageType messageType() {
        return MessageType.MENTION;
    }

    @Override
    public Message.Format.Mention config() {
        return this.fileResolver.getMessage().getFormat().getMention();
    }

    @Override
    public Permission.Message.Format.Mention permission() {
        return this.fileResolver.getPermission().getMessage().getFormat().getMention();
    }

    @Override
    public Localization.Message.Format.Mention localization(FEntity sender) {
        return this.fileResolver.getLocalization(sender).getMessage().getFormat().getMention();
    }

    public void format(MessageContext messageContext) {
        String formattedMessage;
        FEntity sender = messageContext.getSender();
        if (this.isModuleDisabledFor(sender)) {
            return;
        }
        String contextMessage = messageContext.getMessage();
        if (StringUtils.isEmpty((CharSequence)contextMessage)) {
            return;
        }
        try {
            formattedMessage = (String)this.messageCache.get((Object)contextMessage, () -> this.replace(sender, contextMessage));
        }
        catch (ExecutionException e) {
            this.fLogger.warning(e);
            formattedMessage = this.replace(sender, contextMessage);
        }
        messageContext.setMessage(formattedMessage);
    }

    public void addTags(MessageContext messageContext) {
        FEntity sender = messageContext.getSender();
        if (this.isModuleDisabledFor(sender)) {
            return;
        }
        UUID processId = messageContext.getMessageUUID();
        FPlayer receiver = messageContext.getReceiver();
        messageContext.addReplacementTag(MessagePipeline.ReplacementTag.MENTION, (argumentQueue, context) -> {
            Tag.Argument mentionTag = argumentQueue.peek();
            if (mentionTag == null) {
                return Tag.selfClosingInserting((Component)Component.empty());
            }
            String mention = mentionTag.value();
            if (mention.isEmpty()) {
                return Tag.preProcessParsed((String)(this.config().getTrigger() + mention));
            }
            Optional<String> group = this.integrationModule.getGroups().stream().filter(name -> name.equalsIgnoreCase(mention)).findFirst();
            if (group.isPresent()) {
                if (receiver instanceof FPlayer && !this.permissionChecker.check((FEntity)(mentionFPlayer = receiver), this.permission().getBypass()) && this.permissionChecker.check((FEntity)mentionFPlayer, String.valueOf(this.permission().getGroup()) + "." + group.get())) {
                    this.sendMention(processId, mentionFPlayer);
                }
            } else {
                mentionFPlayer = this.fPlayerService.getFPlayer(mention);
                if (mentionFPlayer.equals(receiver) && !this.permissionChecker.check((FEntity)mentionFPlayer, this.permission().getBypass())) {
                    this.sendMention(processId, mentionFPlayer);
                }
            }
            String format = StringUtils.replaceEach((String)this.localization(receiver).getFormat(), (String[])new String[]{"<player>", "<target>"}, (String[])new String[]{mention, mention});
            return Tag.selfClosingInserting((Component)this.messagePipeline.builder(receiver, format).build());
        });
    }

    private String replace(FEntity sender, String message) {
        CharSequence[] words = message.split(" ");
        for (int i = 0; i < words.length; ++i) {
            boolean isMention;
            String word = words[i];
            if (!word.startsWith(this.config().getTrigger())) continue;
            String wordWithoutPrefix = Strings.CS.replaceOnce(word, this.config().getTrigger(), "");
            FPlayer mentionFPlayer = this.fPlayerService.getFPlayer(wordWithoutPrefix);
            boolean bl = isMention = !mentionFPlayer.isUnknown() && this.integrationModule.canSeeVanished(mentionFPlayer, sender) || this.integrationModule.getGroups().contains(wordWithoutPrefix) && this.permissionChecker.check(sender, this.permission().getGroup());
            if (!isMention) continue;
            words[i] = "<mention:" + wordWithoutPrefix + ">";
        }
        return String.join((CharSequence)" ", words);
    }

    private void sendMention(UUID processId, FPlayer fPlayer) {
        if (this.processedMentions.containsKey(processId)) {
            return;
        }
        this.processedMentions.put(processId, true);
        this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Message.Format.Mention::getPerson)).destination(this.config().getDestination())).sound(this.getModuleSound())).build());
    }

    @Inject
    @Generated
    public MentionModule(@Named(value="mentionMessage") Cache<String, String> messageCache, FileResolver fileResolver, ListenerRegistry listenerRegistry, FPlayerService fPlayerService, IntegrationModule integrationModule, PermissionChecker permissionChecker, MessagePipeline messagePipeline, FLogger fLogger) {
        this.messageCache = messageCache;
        this.fileResolver = fileResolver;
        this.listenerRegistry = listenerRegistry;
        this.fPlayerService = fPlayerService;
        this.integrationModule = integrationModule;
        this.permissionChecker = permissionChecker;
        this.messagePipeline = messagePipeline;
        this.fLogger = fLogger;
    }
}

