/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.format.moderation.swear;

import java.util.Locale;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import lombok.Generated;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.library.adventure.text.Component;
import net.flectone.pulse.library.adventure.text.event.HoverEvent;
import net.flectone.pulse.library.adventure.text.event.HoverEventSource;
import net.flectone.pulse.library.adventure.text.minimessage.tag.Tag;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.guava.cache.Cache;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.guice.name.Named;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.AbstractModuleLocalization;
import net.flectone.pulse.module.message.format.moderation.swear.listener.SwearPulseListener;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.context.MessageContext;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.checker.PermissionChecker;
import net.flectone.pulse.util.constant.MessageFlag;
import net.flectone.pulse.util.constant.MessageType;
import net.flectone.pulse.util.logging.FLogger;

@Singleton
public class SwearModule
extends AbstractModuleLocalization<Localization.Message.Format.Moderation.Swear> {
    @Named(value="swearMessage")
    private final Cache<String, String> messageCache;
    private final FileResolver fileResolver;
    private final FLogger fLogger;
    private final ListenerRegistry listenerRegistry;
    private final PermissionChecker permissionChecker;
    private final MessagePipeline messagePipeline;
    private Pattern combinedPattern;

    @Override
    public void onEnable() {
        super.onEnable();
        this.registerPermission(this.permission().getBypass());
        this.registerPermission(this.permission().getSee());
        try {
            this.combinedPattern = Pattern.compile(String.join((CharSequence)"|", this.config().getTrigger()));
        }
        catch (PatternSyntaxException e) {
            this.fLogger.warning(e);
        }
        this.listenerRegistry.register(SwearPulseListener.class);
    }

    @Override
    public void onDisable() {
        super.onDisable();
        this.messageCache.invalidateAll();
    }

    @Override
    public MessageType messageType() {
        return MessageType.SWEAR;
    }

    @Override
    public Message.Format.Moderation.Swear config() {
        return this.fileResolver.getMessage().getFormat().getModeration().getSwear();
    }

    @Override
    public Permission.Message.Format.Moderation.Swear permission() {
        return this.fileResolver.getPermission().getMessage().getFormat().getModeration().getSwear();
    }

    @Override
    public Localization.Message.Format.Moderation.Swear localization(FEntity sender) {
        return this.fileResolver.getLocalization(sender).getMessage().getFormat().getModeration().getSwear();
    }

    public void format(MessageContext messageContext) {
        String formattedMessage;
        FEntity sender = messageContext.getSender();
        if (this.isModuleDisabledFor(sender)) {
            return;
        }
        if (!messageContext.isFlag(MessageFlag.USER_MESSAGE)) {
            return;
        }
        String contextMessage = messageContext.getMessage();
        if (StringUtils.isEmpty((CharSequence)contextMessage)) {
            return;
        }
        try {
            formattedMessage = (String)this.messageCache.get((Object)contextMessage, () -> this.replace(sender, contextMessage));
        }
        catch (ExecutionException e) {
            this.fLogger.warning(e);
            formattedMessage = this.replace(sender, contextMessage);
        }
        messageContext.setMessage(formattedMessage);
    }

    public void addTag(MessageContext messageContext) {
        FEntity sender = messageContext.getSender();
        if (this.isModuleDisabledFor(sender)) {
            return;
        }
        if (!messageContext.isFlag(MessageFlag.USER_MESSAGE)) {
            return;
        }
        FPlayer receiver = messageContext.getReceiver();
        messageContext.addReplacementTag(MessagePipeline.ReplacementTag.SWEAR, (argumentQueue, context) -> {
            Tag.Argument swearTag = argumentQueue.peek();
            if (swearTag == null) {
                return Tag.selfClosingInserting((Component)Component.empty());
            }
            String swear = swearTag.value();
            if (swear.isBlank()) {
                return Tag.selfClosingInserting((Component)Component.empty());
            }
            String symbols = this.localization(receiver).getSymbol().repeat(swear.length());
            Component component = this.messagePipeline.builder(sender, receiver, symbols).build();
            if (this.permissionChecker.check((FEntity)receiver, this.permission().getSee())) {
                component = component.hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)swear)));
            }
            return Tag.selfClosingInserting((Component)component);
        });
    }

    private String replace(FEntity sender, String string) {
        if (this.permissionChecker.check(sender, this.permission().getBypass())) {
            return string;
        }
        if (this.combinedPattern == null) {
            return string;
        }
        StringBuilder result = new StringBuilder();
        Matcher matcher = this.combinedPattern.matcher(string);
        while (matcher.find()) {
            String word = matcher.group(0);
            int start = matcher.start();
            if (this.isIgnored(word) || this.isIgnored(this.getFullWord(string, start))) continue;
            matcher.appendReplacement(result, "<swear:'" + word + "'>");
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private boolean isIgnored(String word) {
        if (StringUtils.isEmpty((CharSequence)word)) {
            return true;
        }
        if (this.config().getIgnore().isEmpty()) {
            return false;
        }
        String fullWord = word.trim().toLowerCase(Locale.ROOT);
        return this.config().getIgnore().contains(fullWord);
    }

    private String getFullWord(String text, int position) {
        int end;
        int start;
        if (position < 0 || position >= text.length()) {
            return text;
        }
        for (start = position; start > 0 && Character.isLetterOrDigit(text.charAt(start - 1)); --start) {
        }
        for (end = position; end < text.length() && Character.isLetterOrDigit(text.charAt(end)); ++end) {
        }
        return text.substring(start, end);
    }

    @Inject
    @Generated
    public SwearModule(@Named(value="swearMessage") Cache<String, String> messageCache, FileResolver fileResolver, FLogger fLogger, ListenerRegistry listenerRegistry, PermissionChecker permissionChecker, MessagePipeline messagePipeline) {
        this.messageCache = messageCache;
        this.fileResolver = fileResolver;
        this.fLogger = fLogger;
        this.listenerRegistry = listenerRegistry;
        this.permissionChecker = permissionChecker;
        this.messagePipeline = messagePipeline;
    }

    @Generated
    public Pattern getCombinedPattern() {
        return this.combinedPattern;
    }
}

