/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.format.names.listener;

import lombok.Generated;
import net.flectone.pulse.annotation.Pulse;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.packetevents.protocol.potion.PotionTypes;
import net.flectone.pulse.listener.PulseListener;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.event.Event;
import net.flectone.pulse.model.event.message.MessageFormattingEvent;
import net.flectone.pulse.module.message.format.names.NamesModule;
import net.flectone.pulse.platform.adapter.PlatformPlayerAdapter;
import net.flectone.pulse.processing.context.MessageContext;
import net.flectone.pulse.util.constant.MessageFlag;

@Singleton
public class NamesPulseListener
implements PulseListener {
    private final NamesModule namesModule;
    private final PlatformPlayerAdapter platformPlayerAdapter;

    @Pulse(priority=Event.Priority.HIGH)
    public void onMessageFormattingEvent(MessageFormattingEvent event) {
        MessageContext messageContext = event.getContext();
        FEntity sender = messageContext.getSender();
        if (messageContext.isFlag(MessageFlag.INVISIBLE_NAME) && this.isInvisible(sender)) {
            this.namesModule.addInvisibleTag(messageContext);
        } else {
            this.namesModule.addTags(messageContext);
        }
    }

    private boolean isInvisible(FEntity entity) {
        return this.namesModule.config().isShouldCheckInvisibility() && this.platformPlayerAdapter.hasPotionEffect(entity, PotionTypes.INVISIBILITY);
    }

    @Inject
    @Generated
    public NamesPulseListener(NamesModule namesModule, PlatformPlayerAdapter platformPlayerAdapter) {
        this.namesModule = namesModule;
        this.platformPlayerAdapter = platformPlayerAdapter;
    }
}

