/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.format.replacement;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.library.adventure.text.Component;
import net.flectone.pulse.library.adventure.text.TextComponent;
import net.flectone.pulse.library.adventure.text.minimessage.MiniMessage;
import net.flectone.pulse.library.adventure.text.minimessage.tag.Tag;
import net.flectone.pulse.library.adventure.text.minimessage.tag.resolver.TagResolver;
import net.flectone.pulse.library.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.apache.text.StringEscapeUtils;
import net.flectone.pulse.library.guava.cache.Cache;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.guice.name.Named;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.util.FImage;
import net.flectone.pulse.module.AbstractModuleLocalization;
import net.flectone.pulse.module.message.format.replacement.listener.ReplacementPulseListener;
import net.flectone.pulse.platform.adapter.PlatformPlayerAdapter;
import net.flectone.pulse.platform.adapter.PlatformServerAdapter;
import net.flectone.pulse.platform.formatter.UrlFormatter;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.context.MessageContext;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.service.SkinService;
import net.flectone.pulse.util.checker.PermissionChecker;
import net.flectone.pulse.util.constant.MessageFlag;
import net.flectone.pulse.util.constant.MessageType;
import net.flectone.pulse.util.logging.FLogger;

@Singleton
public class ReplacementModule
extends AbstractModuleLocalization<Localization.Message.Format.Replacement> {
    private final Map<String, Pattern> triggerPatterns = new LinkedHashMap<String, Pattern>();
    @Named(value="replacementMessage")
    private final Cache<String, String> messageCache;
    @Named(value="replacementImage")
    private final Cache<String, Component> imageCache;
    private final FileResolver fileResolver;
    private final ListenerRegistry listenerRegistry;
    private final MessagePipeline messagePipeline;
    private final FPlayerService fPlayerService;
    private final PlatformServerAdapter platformServerAdapter;
    private final PlatformPlayerAdapter platformPlayerAdapter;
    private final SkinService skinService;
    private final UrlFormatter urlFormatter;
    private final MiniMessage defaultMiniMessage;
    private final PermissionChecker permissionChecker;
    private final FLogger fLogger;

    @Override
    public void onEnable() {
        super.onEnable();
        this.permission().getValues().values().forEach(this::registerPermission);
        this.listenerRegistry.register(ReplacementPulseListener.class);
        this.config().getTriggers().forEach((name, regex) -> this.triggerPatterns.put((String)name, Pattern.compile(regex)));
    }

    @Override
    public void onDisable() {
        super.onDisable();
        this.triggerPatterns.clear();
        this.messageCache.invalidateAll();
        this.imageCache.invalidateAll();
    }

    @Override
    public MessageType messageType() {
        return MessageType.REPLACEMENT;
    }

    @Override
    public Message.Format.Replacement config() {
        return this.fileResolver.getMessage().getFormat().getReplacement();
    }

    @Override
    public Permission.Message.Format.Replacement permission() {
        return this.fileResolver.getPermission().getMessage().getFormat().getReplacement();
    }

    @Override
    public Localization.Message.Format.Replacement localization(FEntity sender) {
        return this.fileResolver.getLocalization(sender).getMessage().getFormat().getReplacement();
    }

    public void format(MessageContext messageContext) {
        String formattedMessage;
        FEntity sender = messageContext.getSender();
        if (this.isModuleDisabledFor(sender)) {
            return;
        }
        String contextMessage = messageContext.getMessage();
        if (StringUtils.isEmpty((CharSequence)contextMessage)) {
            return;
        }
        try {
            formattedMessage = (String)this.messageCache.get((Object)contextMessage, () -> this.processMessage(contextMessage));
        }
        catch (ExecutionException e) {
            this.fLogger.warning(e);
            formattedMessage = this.processMessage(contextMessage);
        }
        messageContext.setMessage(formattedMessage);
    }

    public void addTags(MessageContext messageContext) {
        FEntity sender = messageContext.getSender();
        if (this.isModuleDisabledFor(sender)) {
            return;
        }
        FPlayer receiver = messageContext.getReceiver();
        boolean isTranslateItem = messageContext.isFlag(MessageFlag.TRANSLATE_ITEM);
        messageContext.addReplacementTag(MessagePipeline.ReplacementTag.REPLACEMENT, (argumentQueue, context) -> {
            Tag.Argument argument = argumentQueue.peek();
            if (argument == null) {
                return Tag.selfClosingInserting((Component)Component.empty());
            }
            String name = argument.value();
            if (!this.permissionChecker.check(sender, this.permission().getValues().get(name))) {
                return Tag.selfClosingInserting((Component)Component.empty());
            }
            String replacement = this.localization(receiver).getValues().get(name);
            if (replacement == null) {
                return Tag.selfClosingInserting((Component)Component.empty());
            }
            ArrayList<String> values = new ArrayList<String>();
            while (argumentQueue.hasNext()) {
                Tag.Argument groupArg = argumentQueue.pop();
                values.add(StringEscapeUtils.unescapeJava((String)groupArg.value()));
            }
            return switch (name) {
                case "ping" -> this.pingTag(sender, receiver);
                case "tps" -> this.tpsTag(sender, receiver);
                case "online" -> this.onlineTag(sender, receiver);
                case "coords" -> this.coordsTag(sender, receiver);
                case "stats" -> this.statsTag(sender, receiver);
                case "skin" -> this.skinTag(sender, receiver);
                case "item" -> this.itemTag(sender, receiver, isTranslateItem);
                case "url" -> {
                    if (values.size() < 2) {
                        yield Tag.selfClosingInserting((Component)Component.empty());
                    }
                    yield this.urlTag(sender, receiver, (String)values.get(1));
                }
                case "image" -> {
                    if (values.size() < 2) {
                        yield Tag.selfClosingInserting((Component)Component.empty());
                    }
                    yield this.imageTag(sender, receiver, (String)values.get(1));
                }
                case "spoiler" -> {
                    if (values.size() < 2) {
                        yield Tag.selfClosingInserting((Component)Component.empty());
                    }
                    yield this.spoilerTag(sender, receiver, (String)values.get(1), messageContext.getFlags());
                }
                default -> {
                    String[] searchList = new String[values.size()];
                    String[] replacementList = new String[values.size()];
                    for (int i = 0; i < values.size(); ++i) {
                        searchList[i] = "<message_" + i + ">";
                        replacementList[i] = (String)values.get(i);
                    }
                    replacement = StringUtils.replaceEach((String)replacement, (String[])searchList, (String[])replacementList);
                    Component component = this.messagePipeline.builder(sender, receiver, replacement).flag(MessageFlag.REPLACEMENT, false).build();
                    yield Tag.selfClosingInserting((Component)component);
                }
            };
        });
        if (this.permissionChecker.check(sender, this.permission().getValues().get("ping"))) {
            messageContext.addReplacementTag(MessagePipeline.ReplacementTag.PING, (argumentQueue, context) -> this.pingTag(sender, receiver));
        }
        if (this.permissionChecker.check(sender, this.permission().getValues().get("tps"))) {
            messageContext.addReplacementTag(MessagePipeline.ReplacementTag.TPS, (argumentQueue, context) -> this.tpsTag(sender, receiver));
        }
        if (this.permissionChecker.check(sender, this.permission().getValues().get("online"))) {
            messageContext.addReplacementTag(MessagePipeline.ReplacementTag.ONLINE, (argumentQueue, context) -> this.onlineTag(sender, receiver));
        }
        if (this.permissionChecker.check(sender, this.permission().getValues().get("coords"))) {
            messageContext.addReplacementTag(MessagePipeline.ReplacementTag.COORDS, (argumentQueue, context) -> this.coordsTag(sender, receiver));
        }
        if (this.permissionChecker.check(sender, this.permission().getValues().get("stats"))) {
            messageContext.addReplacementTag(MessagePipeline.ReplacementTag.STATS, (argumentQueue, context) -> this.statsTag(sender, receiver));
        }
        if (this.permissionChecker.check(sender, this.permission().getValues().get("skin"))) {
            messageContext.addReplacementTag(MessagePipeline.ReplacementTag.SKIN, (argumentQueue, context) -> this.skinTag(sender, receiver));
        }
        if (this.permissionChecker.check(sender, this.permission().getValues().get("item"))) {
            messageContext.addReplacementTag(MessagePipeline.ReplacementTag.ITEM, (argumentQueue, context) -> this.itemTag(sender, receiver, isTranslateItem));
        }
        if (this.permissionChecker.check(sender, this.permission().getValues().get("url"))) {
            messageContext.addReplacementTag(MessagePipeline.ReplacementTag.URL, (argumentQueue, context) -> {
                Tag.Argument argument = argumentQueue.peek();
                if (argument == null) {
                    return Tag.selfClosingInserting((Component)Component.empty());
                }
                return this.urlTag(sender, receiver, argument.value());
            });
        }
        if (this.permissionChecker.check(sender, this.permission().getValues().get("image"))) {
            messageContext.addReplacementTag(MessagePipeline.ReplacementTag.IMAGE, (argumentQueue, context) -> {
                Tag.Argument argument = argumentQueue.peek();
                if (argument == null) {
                    return Tag.selfClosingInserting((Component)Component.empty());
                }
                return this.imageTag(sender, receiver, argument.value());
            });
        }
        if (this.permissionChecker.check(sender, this.permission().getValues().get("spoiler"))) {
            messageContext.addReplacementTag(MessagePipeline.ReplacementTag.SPOILER, (argumentQueue, context) -> {
                Tag.Argument argument = argumentQueue.peek();
                if (argument == null) {
                    return Tag.selfClosingInserting((Component)Component.empty());
                }
                return this.spoilerTag(sender, receiver, argument.value(), messageContext.getFlags());
            });
        }
    }

    private String processMessage(String message) {
        ArrayList<MatchInfo> matches = new ArrayList<MatchInfo>();
        for (Map.Entry<String, Pattern> entry : this.triggerPatterns.entrySet()) {
            String name = entry.getKey();
            boolean isUrl = name.equals("url") || name.equals("image");
            Matcher matcher = entry.getValue().matcher(message);
            while (matcher.find()) {
                String replacement = this.buildReplacement(name, matcher, isUrl);
                matches.add(new MatchInfo(matcher.start(), matcher.end(), replacement));
            }
        }
        matches.sort(Comparator.comparingInt(MatchInfo::start));
        StringBuilder stringBuilder = new StringBuilder();
        int lastPos = 0;
        for (MatchInfo matchInfo : matches) {
            if (matchInfo.start() < lastPos) continue;
            stringBuilder.append(message, lastPos, matchInfo.start());
            stringBuilder.append(matchInfo.replacement());
            lastPos = matchInfo.end();
        }
        stringBuilder.append(message.substring(lastPos));
        return stringBuilder.toString();
    }

    private String buildReplacement(String name, Matcher matcher, boolean isUrl) {
        StringBuilder stringBuilder = new StringBuilder("<replacement:'").append(name);
        for (int i = 1; i <= matcher.groupCount(); ++i) {
            String groupText = matcher.group(i);
            stringBuilder.append("':'").append(StringEscapeUtils.escapeJava((String)(isUrl ? this.urlFormatter.escapeAmpersand(groupText) : groupText)));
        }
        return stringBuilder.append("'>").toString();
    }

    private Tag spoilerTag(FEntity sender, FPlayer receiver, String spoilerText, Map<MessageFlag, Boolean> flags) {
        if (spoilerText.equals("\\")) {
            return Tag.selfClosingInserting((Component)Component.empty());
        }
        Component spoilerComponent = this.messagePipeline.builder(sender, receiver, "." + spoilerText).flags(new EnumMap<MessageFlag, Boolean>(flags)).flag(MessageFlag.TRANSLATE_ITEM, false).build();
        int length = PlainTextComponentSerializer.plainText().serialize(spoilerComponent).length();
        length = spoilerText.endsWith(" ") ? length : Math.max(1, length - 1);
        Localization.Message.Format.Replacement replacement = this.localization(receiver);
        String format = StringUtils.replaceEach((String)replacement.getValues().getOrDefault("spoiler", ""), (String[])new String[]{"<message_1>", "<symbols>"}, (String[])new String[]{spoilerText, StringUtils.repeat((String)replacement.getSpoilerSymbol(), (int)length)});
        Component component = this.messagePipeline.builder(sender, receiver, format).build();
        return Tag.selfClosingInserting((Component)component);
    }

    private Tag pingTag(FEntity sender, FPlayer receiver) {
        if (!(sender instanceof FPlayer)) {
            return Tag.selfClosingInserting((Component)Component.empty());
        }
        FPlayer fPlayer = (FPlayer)sender;
        int ping = this.fPlayerService.getPing(fPlayer);
        String format = Strings.CS.replace(this.localization(receiver).getValues().getOrDefault("ping", ""), "<ping>", String.valueOf(ping));
        Component component = this.messagePipeline.builder(fPlayer, receiver, format).flag(MessageFlag.REPLACEMENT, false).build();
        return Tag.selfClosingInserting((Component)component);
    }

    private Tag tpsTag(FEntity sender, FPlayer receiver) {
        String format = Strings.CS.replace(this.localization(receiver).getValues().getOrDefault("tps", ""), "<tps>", this.platformServerAdapter.getTPS());
        Component component = this.messagePipeline.builder(sender, receiver, format).flag(MessageFlag.REPLACEMENT, false).build();
        return Tag.selfClosingInserting((Component)component);
    }

    private Tag onlineTag(FEntity sender, FPlayer receiver) {
        String format = Strings.CS.replace(this.localization(receiver).getValues().getOrDefault("online", ""), "<online>", String.valueOf(this.platformServerAdapter.getOnlinePlayerCount()));
        Component component = this.messagePipeline.builder(sender, receiver, format).flag(MessageFlag.REPLACEMENT, false).build();
        return Tag.selfClosingInserting((Component)component);
    }

    private Tag coordsTag(FEntity sender, FPlayer receiver) {
        TextComponent component = Component.empty();
        PlatformPlayerAdapter.Coordinates coordinates = this.platformPlayerAdapter.getCoordinates(sender);
        if (coordinates != null) {
            String format = StringUtils.replaceEach((String)this.localization(receiver).getValues().getOrDefault("coords", ""), (String[])new String[]{"<x>", "<y>", "<z>"}, (String[])new String[]{String.valueOf(coordinates.x()), String.valueOf(coordinates.y()), String.valueOf(coordinates.z())});
            component = this.messagePipeline.builder(sender, receiver, format).flag(MessageFlag.REPLACEMENT, false).build();
        }
        return Tag.selfClosingInserting((Component)component);
    }

    private Tag statsTag(FEntity sender, FPlayer receiver) {
        TextComponent component = Component.empty();
        PlatformPlayerAdapter.Statistics statistics = this.platformPlayerAdapter.getStatistics(sender);
        if (statistics != null) {
            String format = StringUtils.replaceEach((String)this.localization(receiver).getValues().getOrDefault("stats", ""), (String[])new String[]{"<hp>", "<armor>", "<exp>", "<food>", "<attack>"}, (String[])new String[]{String.valueOf(statistics.health()), String.valueOf(statistics.armor()), String.valueOf(statistics.level()), String.valueOf(statistics.food()), String.valueOf(statistics.damage())});
            component = this.messagePipeline.builder(sender, receiver, format).flag(MessageFlag.REPLACEMENT, false).build();
        }
        return Tag.selfClosingInserting((Component)component);
    }

    private Tag skinTag(FEntity sender, FPlayer receiver) {
        Component componentPixels;
        String url = this.skinService.getBodyUrl(sender);
        try {
            componentPixels = this.createImageComponent(url);
        }
        catch (ExecutionException ignored) {
            return Tag.selfClosingInserting((Component)Component.empty());
        }
        String format = Strings.CS.replace(this.localization(receiver).getValues().getOrDefault("skin", ""), "<message_1>", url);
        Component component = this.messagePipeline.builder(sender, receiver, format).flag(MessageFlag.REPLACEMENT, false).tagResolvers(TagResolver.resolver((String)"pixels", (argumentQueue, context) -> Tag.inserting((Component)componentPixels))).build();
        return Tag.selfClosingInserting((Component)component);
    }

    private Tag itemTag(FEntity sender, FPlayer receiver, boolean isTranslateItem) {
        Object itemStackObject = this.platformPlayerAdapter.getItem(sender.getUuid());
        Component componentItem = this.platformServerAdapter.translateItemName(itemStackObject, isTranslateItem);
        String format = this.localization(receiver).getValues().getOrDefault("item", "");
        Component componentFormat = this.messagePipeline.builder(sender, receiver, format).flag(MessageFlag.REPLACEMENT, false).tagResolvers(TagResolver.resolver((String)"message_1", (argumentQueue, context) -> Tag.selfClosingInserting((Component)componentItem))).build();
        return Tag.selfClosingInserting((Component)componentFormat);
    }

    private Tag urlTag(FEntity sender, FPlayer receiver, String url) {
        if ((url = this.urlFormatter.toASCII(this.urlFormatter.unescapeAmpersand(url))).isEmpty()) {
            return Tag.selfClosingInserting((Component)Component.empty());
        }
        String string = Strings.CS.replace(this.localization(receiver).getValues().getOrDefault("url", ""), "<message_1>", url);
        Component component = this.messagePipeline.builder(sender, receiver, string).flag(MessageFlag.REPLACEMENT, false).flag(MessageFlag.LEGACY_COLORS, false).build();
        return Tag.selfClosingInserting((Component)component);
    }

    private Tag imageTag(FEntity sender, FPlayer receiver, String url) {
        Component componentPixels;
        if ((url = this.urlFormatter.toASCII(this.urlFormatter.unescapeAmpersand(url))).isEmpty()) {
            return Tag.selfClosingInserting((Component)Component.empty());
        }
        try {
            componentPixels = this.createImageComponent(url);
        }
        catch (ExecutionException ignored) {
            return Tag.selfClosingInserting((Component)Component.empty());
        }
        String string = Strings.CS.replace(this.localization(receiver).getValues().getOrDefault("image", ""), "<message_1>", url);
        Component component = this.messagePipeline.builder(sender, receiver, string).flag(MessageFlag.REPLACEMENT, false).flag(MessageFlag.LEGACY_COLORS, false).tagResolvers(TagResolver.resolver((String)"pixels", (argumentQueue, context) -> Tag.inserting((Component)componentPixels))).build();
        return Tag.selfClosingInserting((Component)component);
    }

    public Component createImageComponent(String link) throws ExecutionException {
        return (Component)this.imageCache.get((Object)link, () -> {
            FImage fImage = new FImage(link);
            TextComponent component = Component.empty();
            try {
                List<String> pixels = fImage.convertImageUrl();
                for (int i = 0; i < pixels.size(); ++i) {
                    component = component.append((Component)Component.newline()).append(this.defaultMiniMessage.deserialize((Object)pixels.get(i)));
                    if (i != pixels.size() - 1) continue;
                    component = component.append((Component)Component.newline());
                }
                this.imageCache.put((Object)link, (Object)component);
            }
            catch (IOException | URISyntaxException exception) {
                // empty catch block
            }
            return component;
        });
    }

    @Inject
    @Generated
    public ReplacementModule(@Named(value="replacementMessage") Cache<String, String> messageCache, @Named(value="replacementImage") Cache<String, Component> imageCache, FileResolver fileResolver, ListenerRegistry listenerRegistry, MessagePipeline messagePipeline, FPlayerService fPlayerService, PlatformServerAdapter platformServerAdapter, PlatformPlayerAdapter platformPlayerAdapter, SkinService skinService, UrlFormatter urlFormatter, MiniMessage defaultMiniMessage, PermissionChecker permissionChecker, FLogger fLogger) {
        this.messageCache = messageCache;
        this.imageCache = imageCache;
        this.fileResolver = fileResolver;
        this.listenerRegistry = listenerRegistry;
        this.messagePipeline = messagePipeline;
        this.fPlayerService = fPlayerService;
        this.platformServerAdapter = platformServerAdapter;
        this.platformPlayerAdapter = platformPlayerAdapter;
        this.skinService = skinService;
        this.urlFormatter = urlFormatter;
        this.defaultMiniMessage = defaultMiniMessage;
        this.permissionChecker = permissionChecker;
        this.fLogger = fLogger;
    }

    private record MatchInfo(int start, int end, String replacement) {
    }
}

